/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.List;
import java.util.ListIterator;
import progress.message.client.EGeneralException;
import progress.message.msg.IMgram;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.xonce.IIDRInboundSupport;
import progress.message.zclient.xonce.IIDROutboundSupport;
import progress.message.zclient.xonce.IIDRTransport;

public abstract class BaseIDRTransport
extends DebugObject
implements IIDRTransport {
    protected IIDROutboundSupport m_sender;
    protected IIDRInboundSupport m_receiver;
    protected String m_appid;
    protected boolean m_isBroker = false;

    @Override
    public abstract void close();

    @Override
    public abstract void abort();

    @Override
    public abstract void handleIDR(Envelope var1);

    protected abstract void sendRequestNoResponseRequired(IMgram var1) throws EGeneralException;

    protected abstract void sendRequestResponseRequired(IMgram var1) throws EGeneralException;

    protected abstract void sendResponse(IMgram var1, Envelope var2) throws EGeneralException;

    protected abstract void sendResponse(IMgram var1) throws EGeneralException;

    public BaseIDRTransport(boolean isBroker, String appid, IIDROutboundSupport sender, IIDRInboundSupport receiver) {
        super("BaseIDRTransport");
        this.m_isBroker = isBroker;
        this.m_appid = appid;
        this.m_sender = sender;
        this.m_receiver = receiver;
    }

    @Override
    public void initiateIDRProtocol() throws EGeneralException, IOException {
        List preql = null;
        boolean senderDoubt = false;
        if (this.m_sender != null) {
            int numPREQs = 0;
            preql = this.m_sender.getPREQTrackNums();
            if (preql != null) {
                numPREQs = preql.size();
            }
            senderDoubt = this.m_sender.hasGuaranteedMessagesPending() || numPREQs > 0;
        }
        boolean needsResponseOnLast = senderDoubt || this.m_isBroker;
        int numAcksAndDNRs = this.m_receiver.getDNRTrackNums(1).size() + this.m_receiver.getDNRTrackNums(0).size() + this.m_receiver.getUGATrackNums(1).size() + this.m_receiver.getUGATrackNums(0).size();
        if (this.DEBUG) {
            this.debug("sendIDRRequest: " + this.m_appid + ": sending IDR request, num=" + numAcksAndDNRs);
        }
        boolean receiverDoubt = numAcksAndDNRs > 0;
        List l = MgramFactory.getMgramFactory().buildIDRMgramList(true, needsResponseOnLast, senderDoubt, this.m_receiver.getDNRTrackNums(1), this.m_receiver.getDNRTrackNums(0), this.m_receiver.getUGATrackNums(1), this.m_receiver.getUGATrackNums(0), preql, this.m_receiver.getPREPTrackNums());
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            IMgram m = (IMgram)it.next();
            if (it.hasNext() || !senderDoubt && !this.m_isBroker) {
                this.sendRequestNoResponseRequired(m);
                continue;
            }
            this.sendRequestResponseRequired(m);
        }
        if (!senderDoubt && !this.m_isBroker) {
            this.informLocalSenderComplete();
            this.informLocalReceiverComplete();
        }
    }

    private void sendIDRReply(Envelope request) throws EGeneralException, IOException {
        if (this.DEBUG) {
            this.debug("sendIDRReply: " + this.m_appid);
        }
        boolean numGMPs = false;
        List preql = null;
        boolean senderDoubt = false;
        if (this.m_sender != null) {
            int numPREQs = 0;
            preql = this.m_sender.getPREQTrackNums();
            if (preql != null) {
                numPREQs = preql.size();
            }
            senderDoubt = this.m_sender.hasGuaranteedMessagesPending() || numPREQs > 0;
        }
        List l = MgramFactory.getMgramFactory().buildIDRMgramList(false, false, senderDoubt, this.m_receiver.getDNRTrackNums(1), this.m_receiver.getDNRTrackNums(0), this.m_receiver.getUGATrackNums(1), this.m_receiver.getUGATrackNums(0), preql, this.m_receiver.getPREPTrackNums());
        ListIterator it = l.listIterator();
        while (it.hasNext()) {
            IMgram m = (IMgram)it.next();
            if (request != null) {
                this.sendResponse(m, request);
                continue;
            }
            this.sendResponse(m);
        }
    }

    private void sendIDRAcknowledgement() throws EGeneralException, IOException {
        if (this.DEBUG) {
            this.debug("sendIDRAcknowledgement: " + this.m_appid);
        }
        IMgram m = MgramFactory.getMgramFactory().buildIDRAckMgram();
        this.sendRequestNoResponseRequired(m);
    }

    @Override
    public void handleIDR(IMgram mgram) throws IOException {
        ObjectInput di = mgram.getPayloadInputStreamHandle();
        this.interpretIDR(di, null);
    }

    public void interpretIDR(Envelope env) throws IOException {
        this.interpretIDR(env.getMessage(), env);
    }

    public void interpretIDR(DataInput m, Envelope env) throws IOException {
        byte requestType = m.readByte();
        if (requestType == 3) {
            this.informLocalReceiverComplete();
            this.informLocalSenderComplete();
            return;
        }
        boolean more = m.readBoolean();
        boolean senderDoubt = m.readBoolean();
        boolean responseRequired = m.readBoolean();
        int ct = 0;
        try {
            while (true) {
                byte typ = m.readByte();
                long tracking = m.readLong();
                int category = 1;
                category = (typ & MgramConstants.MASK_CATEGORY) == MgramConstants.MASK_PTP_VAL ? 0 : 1;
                if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_DNR_VAL) {
                    if (this.m_sender != null) {
                        this.m_sender.dnrReceived(tracking, category);
                    }
                } else if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_UGA_VAL) {
                    if (this.m_sender != null) {
                        this.m_sender.ugaReceived(tracking, category);
                    }
                } else if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_PREP_VAL) {
                    if (this.m_sender != null) {
                        this.m_sender.PREPReceived(tracking);
                    }
                } else if ((typ & MgramConstants.MASK_LIST_TYPE) == MgramConstants.MASK_PREQ_VAL && this.m_receiver != null) {
                    this.m_receiver.PREQReceived(tracking);
                }
                ++ct;
            }
        }
        catch (EOFException e) {
            if (!more) {
                if (requestType == 2) {
                    if (this.DEBUG) {
                        this.debug("handleReply: " + this.m_appid + ": no more (nonfinal) replies");
                    }
                    this.informLocalReceiverComplete();
                    this.informLocalSenderComplete();
                    this.sendIDRAcknowledgement();
                } else if (responseRequired) {
                    this.sendIDRReply(env);
                } else {
                    this.informLocalReceiverComplete();
                    this.informLocalSenderComplete();
                }
            }
            return;
        }
    }

    @Override
    public void setIDRInboundSupport(IIDRInboundSupport receiver) {
        this.m_receiver = receiver;
    }

    @Override
    public void setIDROutboundSupport(IIDROutboundSupport sender) {
        this.m_sender = sender;
    }

    private void informLocalSenderComplete() {
        if (this.DEBUG) {
            this.debug("informLocalSenderComplete: " + this.m_appid);
        }
        if (this.m_sender == null) {
            return;
        }
        this.m_sender.allDNRsReceived();
        this.m_sender.allUGAsReceived();
        this.m_sender.allPREPsReceived();
    }

    private void informLocalReceiverComplete() {
        if (this.DEBUG) {
            this.debug("informLocalReceiverComplete: " + this.m_appid);
        }
        this.m_receiver.allDNRsConfirmed();
        this.m_receiver.allUGAsConfirmed();
        this.m_receiver.allPREQsReceived();
    }
}

