/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.WriterUtil;
import com.sonicsw.sdf.threads.ThreadDumpHandler;
import java.nio.file.Paths;
import java.util.HashMap;

public class JVMThreadDiagnostics
extends AbstractDiagnosticsProvider {
    private static String[] OPERATIONS;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap PARAM_DESCRIPTOR;

    JVMThreadDiagnostics() {
        super("jvm.threads");
    }

    void setContext(IDiagnosticsContext diagContext) {
        this.m_diagnosticsContext = diagContext;
    }

    @Override
    public String describe() {
        String desc = "Generates a JVM thread dump.";
        if (!ThreadDumpHandler.isLockInfoSupported()) {
            desc = desc + "  Use a 1.6 JVM to get full lock information in the thread dump.";
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendStateDump(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
        IStateWriter writer = null;
        try {
            writer = parameters.isEmpty() ? this.m_diagnosticsContext.getStateWriter() : this.m_diagnosticsContext.getStateWriter(parameters);
        }
        catch (Exception e) {
            buffer.append("jvm.threads").append(" failed to use state file:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(e));
            if (writer != null) {
                writer.close();
            }
            return;
        }
        try {
            String instruction = WriterUtil.rebuildInstruction(this, "dumpState", parameters);
            WriterUtil.writeHeader(writer, instruction, null);
            ThreadDumpHandler.writeThreadDump(writer);
            WriterUtil.writeFooter(writer, null);
            String filePath = writer.getFilePath();
            if (parameters.containsKey("output_access")) {
                String permissions = parameters.get("output_access").toString();
                WriterUtil.setFileAccessPermissions(Paths.get(filePath, new String[0]), permissions);
            }
            buffer.append("The thread dump is written to file ").append(filePath);
        }
        catch (IllegalArgumentException e) {
            buffer.append("jvm.heap").append(" failed to generate a thread dump:");
            buffer.append(NEWLINE).append(e.getMessage());
        }
        catch (Throwable t) {
            buffer.append("jvm.threads").append(" failed to generate a thread dump:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(t));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public HashMap describeParameters(String operationName) {
        return (HashMap)PARAM_DESCRIPTOR.get(operationName);
    }

    @Override
    public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
    }

    @Override
    public String[] getOperations() {
        return OPERATIONS;
    }

    static {
        DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();
        DUMP_STATE_PARAM_DESCIPTOR.put("overwrite", OP_PARAM_OVERWRITE_DESCRIPTION + " Default to true");
        DUMP_STATE_PARAM_DESCIPTOR.put("output", OP_PARAM_OUTPUT_LOCATION_DESCRIPTION);
        DUMP_STATE_PARAM_DESCIPTOR.put("output_access", OP_PARAM_FILE_ACCESS_DESCRIPTION + " Default to 'rw-r--r--'");
        PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
    }
}

