/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageListener;
import progress.message.jclient.AbstractJMSContext;
import progress.message.jclient.JMSExceptionUtils;

public class JMSConsumer
implements javax.jms.JMSConsumer {
    private static final String MESSAGE_HAS_NO_BODY = "Message has no body";
    private static final String MESSAGE_WAS_NULL = "Message was null";
    private final AbstractJMSContext context;
    private final MessageConsumer consumer;

    public JMSConsumer(AbstractJMSContext context, MessageConsumer messageConsumer) {
        this.context = context;
        this.consumer = messageConsumer;
    }

    @Override
    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive() {
        try {
            Message message = this.consumer.receive();
            return this.context.setLastMessage(message);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            return this.context.setLastMessage(message);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        try {
            Message message = this.consumer.receiveNoWait();
            return this.context.setLastMessage(message);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> clazz) {
        try {
            Message message = this.consumer.receive();
            this.context.setLastMessage(message);
            return this.getMessageBody(message, clazz);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> clazz, long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            this.context.setLastMessage(message);
            return this.getMessageBody(message, clazz);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> clazz) {
        try {
            Message message = this.consumer.receiveNoWait();
            this.context.setLastMessage(message);
            return this.getMessageBody(message, clazz);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    private <T> T getMessageBody(Message message, Class<T> clazz) throws JMSException {
        if (message == null) {
            throw new MessageFormatRuntimeException(MESSAGE_WAS_NULL);
        }
        T body = message.getBody(clazz);
        if (body == null) {
            throw new MessageFormatRuntimeException(MESSAGE_HAS_NO_BODY);
        }
        return body;
    }
}

