/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import progress.message.client.EBrokerFailoverRedirected;
import progress.message.client.EBrokerRedirected;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.EUserAlreadyConnected;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Connection;
import progress.message.zclient.ContinuousWeightedItemIterator;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IOnDisconnectListener;
import progress.message.zclient.IVetoableOnConnectListener;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.WeightedConnectionTable;
import progress.message.zclient.WeightedItem;

public class ReconnectHelper
extends DebugObject {
    private static final String SEPARATOR = ",";
    private static final long INITIAL_RETRY_INTERVAL = 1000L;
    private static final long RETRY_INTERVAL_INCREMENT = 1000L;
    private static final long MAX_RETRY_INTERVAL_RECONNECT = 5000L;
    private static final long MAX_RETRY_INTERVAL_NORMAL = 1000L;
    private Connection m_con = null;
    private WeightedConnectionTable m_table = null;
    private String[] m_standbyUrls = null;
    private String[] m_localUrls = null;
    private String m_connectedUrl = null;
    private IVetoableOnConnectListener m_vetoable = null;
    private IOnDisconnectListener m_disconnectListener = null;
    private IOException m_ioe = null;
    private boolean m_preemptFTReconnect = false;
    private Object m_sleepMutex = new Object();

    public ReconnectHelper(Connection con) {
        super("ReconnectHelper");
        this.m_con = con;
        this.m_table = new WeightedConnectionTable();
        this.m_standbyUrls = new String[0];
        this.m_localUrls = new String[0];
    }

    public void setVetoableOnConnectListener(IVetoableOnConnectListener vetoable) {
        this.m_vetoable = vetoable;
    }

    public IVetoableOnConnectListener getVetoableOnConnectListener() {
        return this.m_vetoable;
    }

    public void setOnDisconnectListener(IOnDisconnectListener disconnectListener) {
        this.m_disconnectListener = disconnectListener;
    }

    public IOnDisconnectListener getOnDisconnectListener() {
        return this.m_disconnectListener;
    }

    public void notifyConnectedChoice(String host) {
        this.reloadConnectTable(host);
    }

    public void reloadConnectTable() {
        this.reloadConnectTable(this.m_connectedUrl);
    }

    public void reloadConnectTable(String host) {
        int i;
        this.m_table.clear();
        if (this.m_localUrls != null && this.m_localUrls.length > 0) {
            for (i = 0; i < this.m_localUrls.length; ++i) {
                this.m_table.updateItem(this.m_localUrls[i], WeightedConnectionTable.RECONNECT_WEIGHT);
            }
        }
        if (this.m_standbyUrls != null && this.m_standbyUrls.length > 0) {
            for (i = 0; i < this.m_standbyUrls.length; ++i) {
                this.m_table.updateItem(this.m_standbyUrls[i], WeightedConnectionTable.STANDBY_RECONNECT_WEIGHT);
            }
        }
        WeightedItem wi = this.m_table.updateItem(host, WeightedConnectionTable.CONNECTED_WEIGHT);
        wi.setSecondaryWeight(-1L);
    }

    public void notifyRedundancyAssociation(String host, String[] local, String[] standby) {
        this.m_localUrls = local;
        this.m_standbyUrls = standby;
        this.m_connectedUrl = host;
    }

    public void notifyRedundancyAssociation(String[] local, String[] standby) {
        this.m_localUrls = local;
        this.m_standbyUrls = standby;
    }

    public String[] getStandbyBrokerURLs() {
        return this.m_standbyUrls;
    }

    public String[] getLocalBrokerURLs() {
        return this.m_localUrls;
    }

    public void notifyInitialChoices(String host) {
        this.m_table.loadInitialItems(host, WeightedConnectionTable.INITIAL_WEIGHT);
    }

    public void notifyInitialChoices(String[] hosts) {
        this.m_table.loadInitialItems(hosts, WeightedConnectionTable.INITIAL_WEIGHT);
    }

    public void notifyInitialChoices(String[] hosts, int startHost) {
        this.m_table.loadInitialItems(hosts, startHost, WeightedConnectionTable.INITIAL_WEIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptFTReconnect() {
        this.m_preemptFTReconnect = true;
        Object object = this.m_sleepMutex;
        synchronized (object) {
            this.m_sleepMutex.notifyAll();
        }
    }

    public boolean connect(boolean recovery) throws ESecurityGeneralException, EGeneralException {
        long totalWeight;
        this.returnFalseOrThrowExceptionCheckingRecovery(recovery);
        long triesPerIntervalRemaining = totalWeight = this.m_table.totalWeight();
        boolean saved_lb = this.m_con.isLoadBalancingEnabled();
        this.m_con.setFollowRedirect(true);
        this.m_ioe = null;
        boolean fullScanComplete = false;
        if (totalWeight == 0L) {
            throw new EAssertFailure("No host choices !");
        }
        long timeToWorkWith = recovery ? this.m_con.getFailoverReconnectTimeout() : this.m_con.getInitialConnectTimeout();
        long retryInterval = 1000L;
        if (!recovery) {
            retryInterval = 0L;
        }
        long maxRetryInterval = 1000L;
        if (recovery) {
            maxRetryInterval = 5000L;
        }
        WeightedItem current = null;
        ContinuousWeightedItemIterator it = new ContinuousWeightedItemIterator(this.m_table);
        long endtime = timeToWorkWith <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeToWorkWith;
        boolean singlepass = timeToWorkWith == -1L;
        boolean failedRedirect = false;
        boolean retrySameBroker = false;
        String host = null;
        long weight = -1L;
        while (true) {
            if (recovery) {
                this.m_con.setEnableLoadBalancing(false);
            }
            if (retrySameBroker) {
                retrySameBroker = false;
            } else {
                if (!it.hasNext()) {
                    throw new EAssertFailure("Continuous iterator has ended!");
                }
                current = (WeightedItem)it.next();
                host = (String)current.getItem();
                weight = current.getWeight();
                if (weight == 0L) continue;
            }
            if (this.DEBUG) {
                this.debug("Trying:" + host + ", weight:" + weight + ", interval:" + retryInterval + "ms, recovery:" + recovery);
            }
            try {
                boolean rc = ReconnectHelper.connectAndChaseSingleFailoverRedirect(this.m_con, host, recovery);
                if (rc) {
                    this.mVetoableOnConnect(recovery);
                    this.notifyConnectedChoice(host);
                    this.debugSuccessTableDump();
                    return true;
                }
            }
            catch (ESecurityGeneralException esge) {
                throw esge;
            }
            catch (EBrokerRedirected ebr) {
                this.m_con.setEnableLoadBalancing(false);
                boolean success = this.chaseRedirect(ebr, recovery);
                if (success) {
                    return true;
                }
                retrySameBroker = true;
                this.m_con.setEnableLoadBalancing(false);
            }
            catch (EUserAlreadyConnected euc) {
                throw euc;
            }
            catch (EConnectionNotResumable enr) {
                throw enr;
            }
            catch (ENetworkFailure enf) {
                this.m_ioe = enf;
            }
            catch (EInterrupted ei) {
                throw ei;
            }
            catch (EGeneralException ege) {
                this.m_ioe = ege;
            }
            catch (IOException ioe) {
                this.m_ioe = ioe;
            }
            try {
                --triesPerIntervalRemaining;
                if (!singlepass && System.currentTimeMillis() > endtime && fullScanComplete) {
                    return this.returnFalseOrThrowException();
                }
                if (retryInterval > 0L) {
                    this.internalSleep(retryInterval);
                }
                if (triesPerIntervalRemaining == 0L) {
                    fullScanComplete = true;
                    if (retryInterval < maxRetryInterval) {
                        retryInterval += 1000L;
                    }
                    triesPerIntervalRemaining = totalWeight;
                }
            }
            catch (InterruptedException ex) {
                throw new EInterrupted();
            }
            if (singlepass && fullScanComplete || System.currentTimeMillis() > endtime) {
                return this.returnFalseOrThrowException();
            }
            this.returnFalseOrThrowExceptionCheckingRecovery(recovery);
        }
    }

    private void returnFalseOrThrowExceptionCheckingRecovery(boolean recovery) throws EGeneralException {
        if (recovery && this.m_preemptFTReconnect) {
            this.returnFalseOrThrowException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSleep(long ms) throws InterruptedException {
        Object object = this.m_sleepMutex;
        synchronized (object) {
            this.m_sleepMutex.wait(ms);
        }
    }

    private boolean returnFalseOrThrowException() throws EGeneralException {
        if (this.m_con.m_disableConnectException) {
            return false;
        }
        if (this.m_ioe == null) {
            throw new ENetworkFailure(154, SessionConfig.CONNECT_EXCEPTION);
        }
        if (this.m_ioe instanceof EGeneralException) {
            throw (EGeneralException)this.m_ioe;
        }
        throw new ENetworkFailure(153, this.m_ioe.toString());
    }

    private boolean chaseRedirect(EBrokerRedirected ebr, boolean recovery) throws ESecurityGeneralException {
        try {
            boolean rc;
            String urls;
            String premierChoice = urls = ebr.getNewBrokerURL();
            String redundantChoice = null;
            int separator = urls.indexOf(SEPARATOR);
            if (separator != -1) {
                premierChoice = urls.substring(0, separator);
                redundantChoice = urls.substring(separator + 1);
            }
            if (redundantChoice != null) {
                this.notifyRedundancyAssociation(premierChoice, new String[]{redundantChoice}, null);
            }
            if (this.DEBUG) {
                this.debug("Chasing redirect to:" + premierChoice + ", recovery:" + recovery);
            }
            if (rc = ReconnectHelper.connectAndChaseSingleFailoverRedirect(this.m_con, premierChoice, recovery)) {
                this.mVetoableOnConnect(recovery);
                this.notifyConnectedChoice(premierChoice);
                this.debugSuccessTableDump();
            }
            return rc;
        }
        catch (ESecurityGeneralException esge) {
            throw esge;
        }
        catch (EGeneralException ege) {
            this.m_ioe = ege;
            return false;
        }
        catch (IOException ioe) {
            this.m_ioe = ioe;
            return false;
        }
    }

    private void debugSuccessTableDump() {
        if (this.DEBUG) {
            this.debug("Success!\n" + this.m_table.dump());
        }
    }

    private void mVetoableOnConnect(boolean recovery) throws IOException {
        if (this.m_vetoable != null) {
            this.m_vetoable.onConnect(recovery);
        }
    }

    public static boolean connectAndChaseSingleFailoverRedirect(Connection con, String host, boolean recovery) throws EGeneralException {
        try {
            return con.connectWithRecoveryOpt(host, recovery);
        }
        catch (EBrokerFailoverRedirected ebfr) {
            return con.connectWithRecoveryOpt(ebfr.getNewBrokerURL(), recovery);
        }
    }
}

