/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.http.impl.HTTPConstants;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public final class HTTPParseUtil {
    public static final String CHARSET = "US-ASCII";
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SP = 32;
    static final byte HT = 9;
    static final String CRLF = "\r\n";
    static final String SPACE = " ";
    static final String COMMA = ",";
    static final String EMPTY = "";
    private static final String SEPARATORS = "()<>@,;:\\\"/[]?={} \t";
    private static final String ESCAPE_CHARS = "\"\\";
    static final String HEADER_DELIM = ":";
    static final char HEADER_DELIM_CHAR = ':';
    static final String CHUNKED_TRANSFER_EXTENSION_DELIM = ";";
    static final int MAX_HTTP_CHUNK_HEADER_SIZE;
    private static final byte[] LAST_CHUNK_HEADER_BYTES;
    private static final char[] ASCII_DECODER;
    private static final char[] BASE_64_ENCODING;
    private static final byte[] BASE_64_DECODER;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL;

    public static byte[] getHEX0() {
        return HTTPParseUtil.getAsciiBytes(Integer.toHexString(0));
    }

    public static byte[] getLastChunkHeaderBytes() {
        return (byte[])LAST_CHUNK_HEADER_BYTES.clone();
    }

    public static char decodeASCII(int idx) {
        return ASCII_DECODER[idx];
    }

    public static final byte[] getAsciiBytes(String str) {
        return HTTPParseUtil.encodeString(str, CHARSET);
    }

    public static final byte[] encodeString(String str, String charset) {
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Unsupported charset: " + charset);
        }
    }

    public static final void appendParamValPair(StringBuffer buffer, String param, String value, boolean alwaysQuote, boolean commaPrefix) {
        if (commaPrefix) {
            buffer.append(", ");
        }
        buffer.append(param);
        if (value == null) {
            return;
        }
        buffer.append("=");
        if (alwaysQuote) {
            buffer.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                HTTPParseUtil.appendDoubleSlash(buffer, ch);
            }
            buffer.append('\"');
        } else {
            int offset = buffer.length();
            boolean unsafe = false;
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (SEPARATORS.indexOf(ch) != -1) {
                    unsafe = true;
                }
                HTTPParseUtil.appendDoubleSlash(buffer, ch);
            }
            if (unsafe) {
                buffer.insert(offset, '\"');
                buffer.append('\"');
            }
        }
    }

    private static void appendDoubleSlash(StringBuffer buffer, char ch) {
        if (ESCAPE_CHARS.indexOf(ch) != -1) {
            buffer.append('\\');
        }
        buffer.append(ch);
    }

    public static final Properties parseHeaderParams(String header) {
        String[][] params = HTTPParseUtil.tokenizeHeader(header);
        Properties props = new Properties();
        for (int i = 0; i < params.length && params[i][0] != null; ++i) {
            props.put(params[i][0], params[i][1]);
        }
        return props;
    }

    public static final String formatDate(long time, StringBuffer buf) {
        buf.setLength(0);
        return DATE_PARSER_THREAD_LOCAL.get().format(new Date(time), buf, new FieldPosition(3)).toString();
    }

    public static final Map parseAuthenticateHeader(String auth) {
        String[][] parsed = HTTPParseUtil.tokenizeHeader(auth);
        HashMap schemes = new HashMap();
        HashMap<String, String> schemeParams = null;
        String currentScheme = null;
        for (int i = 0; i < parsed.length && parsed[i][0] != null; ++i) {
            if (parsed[i][1] == null) {
                currentScheme = parsed[i][0].toLowerCase();
                schemeParams = new HashMap<String, String>();
                LinkedList schemeChallenges = (LinkedList)schemes.get(currentScheme);
                if (schemeChallenges == null) {
                    schemeChallenges = new LinkedList();
                    schemes.put(currentScheme, schemeChallenges);
                }
                schemeChallenges.add(schemeParams);
                if (!currentScheme.equalsIgnoreCase("ntlm") || parsed[i][2] != SPACE) continue;
                String rawChallenge = parsed[++i][0];
                if (parsed[i][1] != null) {
                    if (HTTPConstants.DEBUG) {
                        HTTPParseUtil.debug("'=' detected in NTLM challenge, reappending");
                    }
                    rawChallenge = rawChallenge + "=" + parsed[i][1];
                }
                schemeParams.put(rawChallenge, null);
                continue;
            }
            schemeParams.put(parsed[i][0].toLowerCase(), parsed[i][1]);
        }
        return schemes;
    }

    static final String[][] tokenizeHeader(String lineParam) {
        String line = lineParam;
        String[][] tab = new String[10][3];
        if (line != null) {
            line = line.trim();
            char[] ca = line.toCharArray();
            int beg = 0;
            int end = 0;
            int i = 0;
            boolean inKey = true;
            boolean inQuote = false;
            int len = ca.length;
            while (end < len) {
                char c = ca[end];
                if (c == '=' && !inQuote && inKey) {
                    tab[i][0] = new String(ca, beg, end - beg);
                    inKey = false;
                    beg = ++end;
                } else if (c == '\"') {
                    if (inQuote) {
                        tab[i][1] = new String(ca, beg, end - beg);
                        inQuote = false;
                        ++end;
                        end = HTTPParseUtil.configCommaSpaceEmpty(ca, end, i, len, tab);
                        ++i;
                        inKey = true;
                        beg = end;
                    } else {
                        inQuote = true;
                        beg = ++end;
                    }
                } else if (c == ' ' || c == ',') {
                    if (inQuote) {
                        ++end;
                        continue;
                    }
                    if (inKey) {
                        tab[i][0] = new String(ca, beg, end - beg);
                    } else {
                        tab[i][1] = new String(ca, beg, end - beg);
                    }
                    end = HTTPParseUtil.configCommaSpaceEmpty(ca, end, i, len, tab);
                    ++i;
                    inKey = true;
                    beg = end;
                } else {
                    ++end;
                }
                if (i != tab.length) continue;
                String[][] ntab = new String[tab.length * 2][3];
                System.arraycopy(tab, 0, ntab, 0, tab.length);
                tab = ntab;
            }
            if (--end > beg) {
                if (!inKey) {
                    tab[i++][1] = ca[end] == '\"' ? new String(ca, beg, end - beg) : new String(ca, beg, end - beg + 1);
                } else {
                    tab[i++][0] = new String(ca, beg, end - beg + 1).toLowerCase();
                }
            } else if (end == beg) {
                if (!inKey) {
                    tab[i++][1] = ca[end] == '\"' ? String.valueOf(ca[end - 1]) : String.valueOf(ca[end]);
                } else {
                    tab[i++][0] = String.valueOf(ca[end]).toLowerCase();
                }
            }
            tab[i][2] = EMPTY;
        }
        return tab;
    }

    private static int configCommaSpaceEmpty(char[] ca, int endParam, int i, int len, String[][] tab) {
        int end;
        boolean comma = false;
        boolean lws = false;
        for (end = endParam; end < len && (ca[end] == ' ' || ca[end] == ',' || ca[end] == '\t'); ++end) {
            if (ca[end] == ',') {
                comma = true;
            }
            if (ca[end] != ' ' && ca[end] != '\t') continue;
            lws = true;
        }
        tab[i][2] = comma ? COMMA : (lws ? SPACE : EMPTY);
        return end;
    }

    public static String bas64Encode(byte[] bytes, int offset, int count) {
        int segments = count / 3;
        if (count % 3 > 0) {
            ++segments;
        }
        char[] result = new char[segments * 4];
        int i = offset;
        for (int r = 0; r < result.length; r += 4) {
            byte c;
            byte b;
            byte a;
            int rem = count - i - offset;
            if (rem == 1) {
                a = bytes[i];
                b = 0;
                c = 0;
                result[r] = BASE_64_ENCODING[a >>> 2 & 0x3F];
                result[r + 1] = BASE_64_ENCODING[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                result[r + 2] = 61;
                result[r + 3] = 61;
            } else if (rem == 2) {
                a = bytes[i];
                b = bytes[i + 1];
                c = 0;
                HTTPParseUtil.encodeResult012(a, b, c, r, result);
                result[r + 3] = 61;
            } else {
                a = bytes[i];
                b = bytes[i + 1];
                c = bytes[i + 2];
                HTTPParseUtil.encodeResult012(a, b, c, r, result);
                result[r + 3] = BASE_64_ENCODING[c & 0x3F];
            }
            i += 3;
        }
        return new String(result);
    }

    private static void encodeResult012(byte a, byte b, byte c, int r, char[] result) {
        result[r] = BASE_64_ENCODING[a >>> 2 & 0x3F];
        result[r + 1] = BASE_64_ENCODING[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
        result[r + 2] = BASE_64_ENCODING[(b << 2 & 0x3C) + (c >>> 6 & 3)];
    }

    public static final byte[] base64Decode(String str) throws IOException {
        if (str.length() % 4 != 0) {
            throw new IOException("Base 64 decoding error, input length not a multiple of 4");
        }
        int bytes = str.length() / 4 * 3;
        int trailingPad = 0;
        if (str.charAt(str.length() - 1) == '=') {
            ++trailingPad;
        }
        if (str.charAt(str.length() - 2) == '=') {
            ++trailingPad;
        }
        byte[] result = new byte[bytes - trailingPad];
        int r = 0;
        for (int i = 0; i < str.length(); i += 4) {
            byte a = BASE_64_DECODER[str.charAt(i)];
            byte b = BASE_64_DECODER[str.charAt(i + 1)];
            byte c = BASE_64_DECODER[str.charAt(i + 2)];
            byte d = BASE_64_DECODER[str.charAt(i + 3)];
            result[r] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (++r < result.length) {
                result[r] = (byte)(b << 4 & 0xF0 | c >>> 2 & 0xF);
            }
            if (++r < result.length) {
                result[r] = (byte)(c << 6 & 0xC0 | d & 0x3F);
            }
            ++r;
        }
        return result;
    }

    private static final void debug(String str) {
        System.out.println("HTTPParseUtil: " + str);
    }

    static {
        int i;
        BASE_64_ENCODING = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                dateFormat.applyPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
                return dateFormat;
            }
        };
        char[] decoder = new char[256];
        byte[] ascii = new byte[decoder.length];
        for (int i2 = 0; i2 < decoder.length; ++i2) {
            ascii[i2] = (byte)i2;
        }
        try {
            String s = new String(ascii, CHARSET);
            for (i = 0; i < decoder.length; ++i) {
                decoder[i] = s.charAt(i);
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        ASCII_DECODER = decoder;
        byte[] base64Decoder = new byte[256];
        for (i = 0; i < 255; ++i) {
            base64Decoder[i] = -1;
        }
        for (i = 0; i < BASE_64_ENCODING.length; ++i) {
            base64Decoder[HTTPParseUtil.BASE_64_ENCODING[i]] = (byte)i;
        }
        BASE_64_DECODER = base64Decoder;
        MAX_HTTP_CHUNK_HEADER_SIZE = HTTPParseUtil.getAsciiBytes(Integer.toHexString(65536)).length + 2;
        LAST_CHUNK_HEADER_BYTES = HTTPParseUtil.getAsciiBytes(Integer.toHexString(0) + CRLF + CRLF);
    }
}

