/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Topic;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSelectorException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnusableConnection;
import progress.message.client.prAccessor;
import progress.message.jclient.DestinationFactory;
import progress.message.jimpl.Connection;
import progress.message.jimpl.Destination;
import progress.message.jimpl.ISelectorFactory;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.Session;
import progress.message.jimpl.SessionAcknowledgeQueue;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Subscription;

public class TopicSubscriber
extends MessageConsumer
implements javax.jms.TopicSubscriber {
    private static final String MESSAGE_SELECTOR_FACTORY_CLASS = "progress.message.jimpl.parser.SelectorFactory";
    boolean m_inhibitLocalDelivery = false;
    Topic m_appTopic = null;
    Destination m_dest = null;
    private IMessageHandler m_ihandler;
    private Subscription m_subscription = null;
    private boolean m_isSelectorAtBroker = false;
    private int m_flowToDisk = 0;

    public TopicSubscriber(Session session, Topic topic) throws JMSException {
        this(session, topic, null, false);
    }

    public TopicSubscriber(Session session, Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        super(session);
        if (topic == null) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_UNIDENT_TOPIC"));
        }
        ISubject subject = this.setConnectionAndTopicAndCreateSubject(topic);
        try {
            Session sess;
            this.m_selectorString = messageSelector;
            this.m_isSelectorAtBroker = this.m_jconnection.isSelectorAtBroker();
            this.m_flowToDisk = this.m_jsession.getFlowToDisk();
            if (!subject.hasGroup()) {
                this.m_inhibitLocalDelivery = noLocal;
            }
            this.m_ihandler = new IHandler();
            if (!this.m_isSelectorAtBroker && this.m_selectorString != null && this.m_selectorString.length() > 0) {
                ISelectorFactory factory = null;
                try {
                    Class<?> c = Class.forName(MESSAGE_SELECTOR_FACTORY_CLASS);
                    factory = (ISelectorFactory)c.newInstance();
                }
                catch (Exception e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + MESSAGE_SELECTOR_FACTORY_CLASS, e);
                }
                if (factory != null) {
                    this.m_selector = factory.createMessageSelector(this.m_selectorString);
                }
            }
            if ((noLocal || !this.m_isSelectorAtBroker && this.m_selector != null) && (sess = this.m_jsession).getAcknowledgeQueue() == null) {
                sess.startSAP();
            }
            this.m_zmessageHandler = new MessageHandler(null, true, true);
            this.m_zmessageHandler.setGuaranteed(true);
            String appId = "$NONDURABLE$";
            this.m_zconnection = this.m_jconnection.getMinimizeSubscriberTraffic() ? new progress.message.zclient.Connection(appId, null, this.m_zmessageHandler, true) : new progress.message.zclient.Connection(appId, null, this.m_zmessageHandler);
            this.m_jconnection.addZConnection(this.m_zconnection);
            long parentID = this.m_jsession.m_zconnection.getClientId();
            this.m_zconnection.setAckMode(this.m_jsession.getZAckMode());
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            progress.message.zclient.Session s = this.m_zmessageHandler.getSession();
            if (s == null) {
                throw new ENotConnected();
            }
            this.m_subscription = s.submitJMSSubscription(subject, new Label(), this.m_selectorString, this.m_isSelectorAtBroker, false, this.m_flowToDisk, false);
            this.m_zmessageHandler.bind(subject, this.m_ihandler);
            session.addTopicSubscriber(this);
        }
        catch (InvalidSelectorException ise) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw ise;
        }
        catch (EInvalidSelectorException e) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw new InvalidSelectorException(e.getMessage() + " (Topic: " + this.m_appTopic + ", Selector: " + (this.m_selectorString == null ? "null" : "\"" + this.m_selectorString + "\"") + ")");
        }
        catch (ESecurityPolicyViolation espv) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(espv);
        }
        catch (EParameterIsNull epis) {
            this.connectionCleanup();
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (EInvalidSubjectSyntax eiss) {
            this.removeConnectionAndCleanup();
            throw JMSExceptionUtil.createJMSException(eiss);
        }
        catch (ENetworkFailure enf) {
            this.removeAndCleanup();
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EUnusableConnection euc) {
            throw this.cleanupZConnectionAndCreateJMSException(euc);
        }
        catch (EGeneralException ege) {
            throw this.cleanUpAndCreateJMSException(ege);
        }
        catch (JMSException jmse) {
            this.mzConnectionCleanup();
            throw jmse;
        }
    }

    public TopicSubscriber(Connection connection, Session session, Topic topic, String messageSelector, IMessageHandler ihr) throws JMSException {
        super(session);
        this.m_jconnection = connection;
        ISubject subject = this.setConnectionAndTopicAndCreateSubject(topic);
        this.m_selectorString = messageSelector;
        this.m_isSelectorAtBroker = this.m_jconnection.isSelectorAtBroker();
        this.m_flowToDisk = this.m_jconnection.getFlowToDisk();
        this.m_ihandler = ihr;
        this.m_isCC = true;
        try {
            if (!this.m_isSelectorAtBroker && this.m_selectorString != null && this.m_selectorString.length() > 0) {
                ISelectorFactory factory = null;
                try {
                    Class<?> c = Class.forName(MESSAGE_SELECTOR_FACTORY_CLASS);
                    factory = (ISelectorFactory)c.newInstance();
                }
                catch (Exception e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + MESSAGE_SELECTOR_FACTORY_CLASS, e);
                }
                if (factory != null) {
                    this.m_selector = factory.createMessageSelector(this.m_selectorString);
                }
            }
            this.m_zmessageHandler = new MessageHandler(null, true, !this.m_isCC);
            this.m_zmessageHandler.setName("TopicSubscriber msg handler");
            this.m_zmessageHandler.setGuaranteed(true);
            this.m_zconnection = this.m_jconnection.getMinimizeSubscriberTraffic() ? new progress.message.zclient.Connection("$CC$$TS$", null, this.m_zmessageHandler, true) : new progress.message.zclient.Connection("$CC$$TS$", null, this.m_zmessageHandler);
            this.m_jconnection.addZConnection(this.m_zconnection);
            long parentID = this.m_jconnection.m_zconnection.getClientId();
            this.m_zconnection.setAckMode(this.m_jsession.getZAckMode());
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            this.m_subscription = this.m_zmessageHandler.getSession().submitJMSSubscription(subject, new Label(), this.m_selectorString, this.m_isSelectorAtBroker, false, this.m_flowToDisk, false);
            this.m_zmessageHandler.bind(subject, this.m_ihandler);
            this.m_jconnection.addTopicSubscriber(this);
        }
        catch (ESecurityPolicyViolation espv) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("NOT_AUTH_RECV") + this.m_appTopic.getTopicName(), espv);
        }
        catch (EParameterIsNull epis) {
            this.connectionCleanup();
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (EInvalidSubjectSyntax eiss) {
            this.removeConnectionAndCleanup();
            throw JMSExceptionUtil.createJMSException(eiss);
        }
        catch (ENetworkFailure enf) {
            this.removeAndCleanup();
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EUnusableConnection euc) {
            throw this.cleanupZConnectionAndCreateJMSException(euc);
        }
        catch (InvalidSelectorException ise) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw ise;
        }
        catch (EInvalidSelectorException e) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw new InvalidSelectorException(e.getMessage());
        }
        catch (EGeneralException ege) {
            throw this.cleanUpAndCreateJMSException(ege);
        }
        catch (JMSException jmse) {
            this.mzConnectionCleanup();
            throw jmse;
        }
    }

    private ISubject setConnectionAndTopicAndCreateSubject(Topic topic) throws JMSException {
        this.m_jconnection = this.m_jsession.m_jconnection;
        this.setupTopic(topic);
        ISubject subject = this.m_dest.getSubject().clearSubjectTracking();
        return subject;
    }

    private void removeConnectionAndCleanup() {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
    }

    private void removeAndCleanup() {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
    }

    private JMSException cleanupZConnectionAndCreateJMSException(EUnusableConnection euc) {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
        return JMSExceptionUtil.createJMSException(euc);
    }

    private JMSException cleanUpAndCreateJMSException(EGeneralException ege) {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
        return JMSExceptionUtil.createJMSException(ege);
    }

    private void connectionCleanup() {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
    }

    private void mzConnectionCleanup() {
        this.m_jconnection.removeZConnection(this.m_zconnection);
        if (this.m_zconnection != null) {
            this.m_zconnection.cleanUp();
        }
    }

    private final void setupTopic(Topic topic) throws JMSException {
        ISubject subject;
        this.m_appTopic = topic;
        this.m_dest = (Destination)DestinationFactory.createSonicDestination(this.m_appTopic);
        if (this.m_dest.hasRouting()) {
            String routingNodeName = this.m_dest.getRouting();
            String localRoutingNodeName = this.m_jconnection.getRoutingNodeName();
            if (routingNodeName != null && !routingNodeName.equals(localRoutingNodeName) && !routingNodeName.equals("")) {
                throw new InvalidDestinationException(prAccessor.getString("TOPICSUBSCRIBER_CANNOT_USE_REMOTE_TOPIC"));
            }
        }
        if (!(subject = this.m_dest.getSubject()).isSubjectSet()) {
            throw JMSExceptionUtil.createJMSException(new EInvalidSubjectSyntax(prAccessor.getString("STR128")));
        }
        if (subject.isMultiSubject()) {
            this.m_dest = ((MultiTopic)this.m_dest).protectedClone();
            this.m_appTopic = (MultiTopic)this.m_dest;
        }
    }

    @Override
    void closeInternalConsumer() throws JMSException {
        if (this.checkIfAlreadyClosing()) {
            return;
        }
        this.m_pendingClose = false;
        this.acknowledgePendingMessages();
        try {
            this.completePendingTasks();
            this.cancelSubscription();
            this.disconnect();
        }
        catch (ESecurityPolicyViolation espv) {
            throw JMSExceptionUtil.createJMSSecurityException(espv);
        }
        catch (EGeneralException epin) {
            throw JMSExceptionUtil.createJMSException(epin);
        }
    }

    private boolean checkIfAlreadyClosing() throws JMSException {
        if (this.m_isCC) {
            if (!this.m_jconnection.isClosing()) {
                Enumeration<Session> sessions = this.m_jconnection.getSessions();
                while (sessions.hasMoreElements()) {
                    Session sess = sessions.nextElement();
                    if (sess.okToCloseConsumer(this)) continue;
                    this.stop();
                    this.m_pendingClose = true;
                    return true;
                }
            }
        } else if (!this.m_jsession.okToCloseConsumer(this)) {
            this.stop();
            this.m_pendingClose = true;
            return true;
        }
        return false;
    }

    private void acknowledgePendingMessages() throws JMSException {
        block2: {
            try {
                this.m_jsession.setDelayedAcknowledgeMessage(null);
            }
            catch (JMSException e) {
                if (e.getLinkedException() instanceof ENotConnected) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePendingTasks() {
        if (this.m_isCC) {
            this.m_jconnection.removeZConnection(this.m_zconnection);
            this.m_jconnection.removeNondurableCC(this);
        } else {
            Message[] msgs;
            Message[] messageArray = this.getReceivedMessagesQueue();
            synchronized (messageArray) {
                msgs = this.getReceivedMessagesQueue().removeAllMessages();
                this.getReceivedMessagesQueue().notifyAll();
            }
            for (Message msg : msgs) {
                Envelope envelope = msg.getEnvelope();
                if (envelope == null) continue;
                envelope.handlerDone(this.m_zmessageHandler.isGuaranteed(), false);
            }
            this.m_jsession.removeConsumer(this);
            this.m_jconnection.removeZConnection(this.m_zconnection);
        }
    }

    private void cancelSubscription() throws EGeneralException {
        try {
            this.m_subscription.cancel();
        }
        catch (ENotConnected eNotConnected) {
            // empty catch block
        }
    }

    private void disconnect() throws EGeneralException {
        this.m_zmessageHandler.unbind(this.m_dest.getSubject(), this.m_ihandler);
        if (this.m_zconnection != null) {
            try {
                this.m_zconnection.disconnect(false);
            }
            catch (ENotConnected eNotConnected) {
                // empty catch block
            }
        }
    }

    @Override
    public Topic getTopic() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_appTopic;
    }

    @Override
    public boolean getNoLocal() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_inhibitLocalDelivery;
    }

    @Override
    void acknowledge(Envelope env) throws JMSException {
        if (this.m_jsession.getTransactedFlag()) {
            if (this.m_jsession.getAckListEnabled()) {
                this.batchAck(env);
            } else {
                this.acknowledge(env, this.m_jsession.getAckSession());
            }
        } else {
            progress.message.zclient.Session zs = this.m_zmessageHandler.getSession();
            if (zs == null) {
                throw JMSExceptionUtil.createJMSException(new ENotConnected());
            }
            this.acknowledge(env, zs);
        }
    }

    @Override
    void batchAck(Envelope env) throws JMSException {
        try {
            if (this.m_jsession.getTransactedFlag()) {
                this.m_jsession.getAckSession().batchAck(env, this.m_zconnection.getClientId());
            } else {
                this.m_zmessageHandler.getSession().batchAck(env, this.m_zconnection.getClientId());
            }
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    void processUndeliverable(Envelope env, int errorCode) throws JMSException {
    }

    @Override
    public Message checkUndeliverable(Message msg) throws JMSException {
        return msg;
    }

    @Override
    public javax.jms.Message receive() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return super.receive();
    }

    @Override
    public javax.jms.Message receive(long timeout) throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return super.receive(timeout);
    }

    @Override
    public javax.jms.Message receiveNoWait() throws JMSException {
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return super.receiveNoWait();
    }

    @Override
    public int getPrefetchCount() {
        return -1;
    }

    @Override
    public int getPrefetchThreshold() {
        return -1;
    }

    @Override
    public void setPrefetchCount(int count) throws JMSException {
        throw new IllegalStateException("Prefetch Settings are PTP domain specific settings");
    }

    @Override
    public void setPrefetchThreshold(int threshold) throws JMSException {
        throw new IllegalStateException("Prefetch Settings are PTP domain specific settings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void enqueueReceivedMessage(Envelope env, Message msg) throws JMSException {
        MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.getReceivedMessagesQueue();
        synchronized (receivedMessagesQueue) {
            if (!this.isClosing()) {
                super.enqueueReceivedMessage(env, msg);
            } else {
                env.handlerDone(this.m_zmessageHandler.isGuaranteed(), false);
            }
        }
    }

    private class IHandler
    implements IMessageHandler {
        private IHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            Message msg = null;
            if (TopicSubscriber.this.m_inhibitLocalDelivery && env.getBrokerID() == TopicSubscriber.this.m_jsession.m_jconnection.getBrokerID()) {
                long connID = TopicSubscriber.this.m_jsession.m_jconnection.getConnectionID();
                long msgID = env.getConnectionAndLocalID();
                long connIDInMessage = msgID >> 16;
                if (connIDInMessage == connID || TopicSubscriber.this.m_jsession.m_jconnection.wasOldConnID(connIDInMessage)) {
                    try {
                        SessionAcknowledgeQueue msgQueue;
                        msg = TopicSubscriber.this.extract(env);
                        msg.setConsumer(TopicSubscriber.this);
                        SessionAcknowledgeQueue sessionAcknowledgeQueue = msgQueue = TopicSubscriber.this.m_jsession.getAcknowledgeQueue();
                        synchronized (sessionAcknowledgeQueue) {
                            msgQueue.addMessage(msg);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
            }
            try {
                msg = TopicSubscriber.this.extract(env);
                if (TopicSubscriber.this.m_selector != null && !TopicSubscriber.this.m_selector.match(msg)) {
                    try {
                        SessionAcknowledgeQueue msgQueue;
                        msg.setConsumer(TopicSubscriber.this);
                        SessionAcknowledgeQueue sessionAcknowledgeQueue = msgQueue = TopicSubscriber.this.m_jsession.getAcknowledgeQueue();
                        synchronized (sessionAcknowledgeQueue) {
                            msgQueue.addMessage(msg);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                TopicSubscriber.this.enqueueReceivedMessage(env, msg);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

