/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.security.pass.client.ILogin;
import java.applet.Applet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import progress.message.client.EUnresolvedConnectionURLs;
import progress.message.client.prAccessor;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.Constants;
import progress.message.jclient.JMSContext;
import progress.message.jclient.JMSExceptionUtils;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.net.ProgressInetAddress;
import progress.message.util.DebugState;
import progress.message.zclient.BrokerURL;
import progress.message.zclient.SessionConfig;

public class ConnectionFactory
implements javax.jms.ConnectionFactory,
Referenceable,
Serializable {
    public static final String NOT_SUPPORTED_YET = "Not supported yet.";
    static final long serialVersionUID = 6928769617021574282L;
    public static final String ENABLE_LOCAL_STORE = "EnableLocalStore";
    public static final String LOCAL_STORE_DIRECTORY = "LocalStoreDirectory";
    public static final String LOCAL_STORE_SIZE = "LocalStoreSize";
    public static final String LOCAL_STORE_WAIT_TIME = "LocalStoreWaitTime";
    public static final String RECONNECT_TIMEOUT = "ReconnectTimeout";
    public static final String RECONNECT_INTERVAL = "ReconnectInterval";
    public static final String LOCAL_STORE_LISTENER_FACTORY_CLASS = "LocalStoreListenerFactoryClass";
    public static final String PING_INTERVAL = "pingInterval";
    public static final String FAULT_TOLERANT = "faultTolerant";
    public static final String FAULT_TOLERANT_RECONNECT_TIMEOUT = "faultTolerantReconnectTimeout";
    public static final String INITIAL_CONNECT_TIMEOUT = "initialConnectTimeout";
    public static final String CLIENT_TRANSACTION_BUFFER_SIZE = "clientTransactionBufferSize";
    public static final String FLOW_TO_DISK = "FLOW_TO_DISK";
    public static final String SOCKET_CONNECT_TIMEOUT = "SOCKET_CONNECT_TIMEOUT";
    public static final String LG_ENABLED = "LG_ENABLED";
    public static final String LG_DOWN_STREAM_NODE_TYPE = "LG_DOWN_STREAM_NODE_TYPE";
    public static final String ENABLE_COMPRESSION = "ENABLE_COMPRESSION";
    public static final String COMPRESSION_FACTORY = "COMPRESSION_FACTORY";
    public static final String COMPRESSION_METRICS_LISTENER = "COMPRESSION_METRICS_LISTENER";
    public static final String MINIMIZE_SUBSCRIBER_TRAFFIC = "MINIMIZE_SUBSCRIBER_TRAFFIC";
    public static final String SEND_TIMEOUT = "SEND_TIMEOUT";
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    public static final String SSL = "ssl";
    protected static final String CF_EMPTY_PASSWORD = "";
    protected static final String CF_EMPTY_USERNAME = "";
    public static final String LOGIN_SPI_OBJECT = "login_spi_object";
    protected Hashtable env;
    private String brokerURL;
    private String connectID;
    private String defaultUserName;
    private String defaultPassword;
    private String brokerHostName = ProgressInetAddress.getLocalHostName();
    private String brokerProtocol = "tcp";
    private int brokerPort;
    private String clientID;
    private Applet applet = null;
    private transient Context context;
    public static final Long DELIVERY_CLOSE_TIMEOUT_DEFAULT;
    public static final Integer DELIVERY_DOUBT_WINDOW_DEFAULT;
    public static final Integer ASYNCHRONOUS_DELIVERY_MODE_DEFAULT;

    public ConnectionFactory() throws JMSException {
        this(ProgressInetAddress.getLocalHostName());
    }

    protected ConnectionFactory(Hashtable env) throws JMSException {
        this((String)env.get("brokerURL"), (String)env.get("connectID"), (String)env.get("defaultUserName"), (String)env.get("defaultPassword"));
        String clientID = (String)env.get("clientID");
        if (clientID != null) {
            this.setClientID(clientID);
        }
        this.env = env;
        if (this.brokerURL != null && !this.env.containsKey("brokerList")) {
            this.env.put("brokerList", this.brokerURL);
            this.env.put("RESOLVED_BROKER_LIST", this.brokerURL.startsWith("sonicrn:///") ? "" : this.brokerURL);
        }
        this.setDefaultProperties();
    }

    public ConnectionFactory(String brokerlist) throws JMSException {
        this(brokerlist, null, "", "");
    }

    public ConnectionFactory(String brokerlist, String connectID) throws JMSException {
        this(brokerlist, connectID, "", "");
    }

    public ConnectionFactory(String brokerlist, String defaultUserName, String defaultPassword) throws JMSException {
        this(brokerlist, null, defaultUserName, defaultPassword);
    }

    public ConnectionFactory(String brokerlist, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        this.setDefaultProperties();
        this.connectID = connectID;
        this.brokerURL = brokerlist;
        this.defaultUserName = defaultUserName == null ? "" : defaultUserName;
        this.defaultPassword = defaultPassword == null ? "" : defaultPassword;
        this.envPutBrokerLists();
        try {
            String brokerurl = null;
            if (brokerlist != null) {
                int idx = brokerlist.indexOf(44);
                String string = brokerurl = idx < 0 ? brokerlist : brokerlist.substring(0, idx);
            }
            if (brokerurl != null && brokerurl.length() >= 7 && brokerurl.substring(0, 7).equalsIgnoreCase("sonicrn")) {
                return;
            }
            BrokerURL broker = new BrokerURL(brokerurl, true);
            this.configBrokerConnectionDetails(broker);
        }
        catch (MalformedURLException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Deprecated
    public ConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String defaultUserName, String defaultPassword) throws JMSException {
        this(brokerHostName, brokerPort, brokerProtocol, null, defaultUserName, defaultPassword);
    }

    @Deprecated
    public ConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        this.setDefaultProperties();
        this.connectID = connectID;
        this.defaultUserName = defaultUserName == null ? "" : defaultUserName;
        this.defaultPassword = defaultPassword == null ? "" : defaultPassword;
        try {
            BrokerURL broker = new BrokerURL(brokerHostName, brokerPort, brokerProtocol);
            this.configBrokerConnectionDetails(broker);
            this.brokerURL = broker.getBrokerURL();
            this.envPutBrokerLists();
        }
        catch (MalformedURLException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void configBrokerConnectionDetails(BrokerURL broker) {
        this.brokerHostName = broker.getBrokerHostName();
        this.brokerPort = broker.getBrokerPort();
        this.brokerProtocol = broker.getBrokerProtocol();
    }

    private void envPutBrokerLists() {
        if (this.brokerURL != null) {
            this.env.put("brokerList", this.brokerURL);
            this.env.put("RESOLVED_BROKER_LIST", this.brokerURL.startsWith("sonicrn:///") ? "" : this.brokerURL);
        }
    }

    protected final void setDefaultProperties() {
        this.initEnv();
        if (this.env.get(ENABLE_LOCAL_STORE) == null) {
            this.env.put(ENABLE_LOCAL_STORE, new Boolean(false));
        }
        if (this.env.get(LOCAL_STORE_DIRECTORY) == null) {
            try {
                this.env.put(LOCAL_STORE_DIRECTORY, System.getProperty("user.dir"));
            }
            catch (SecurityException e) {
                this.env.put(LOCAL_STORE_DIRECTORY, "");
            }
        }
        if (this.env.get(LOCAL_STORE_SIZE) == null) {
            this.env.put(LOCAL_STORE_SIZE, new Long(10000L));
        }
        if (this.env.get(LOCAL_STORE_WAIT_TIME) == null) {
            this.env.put(LOCAL_STORE_WAIT_TIME, new Integer(0));
        }
        if (this.env.get(RECONNECT_TIMEOUT) == null) {
            this.env.put(RECONNECT_TIMEOUT, new Integer(0));
        }
        if (this.env.get(RECONNECT_INTERVAL) == null) {
            this.env.put(RECONNECT_INTERVAL, new Integer(30));
        }
        if (this.env.get(FAULT_TOLERANT) == null) {
            this.env.put(FAULT_TOLERANT, new Boolean(false));
        }
        if (this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT) == null) {
            this.env.put(FAULT_TOLERANT_RECONNECT_TIMEOUT, new Integer(60));
        }
        if (this.env.get(INITIAL_CONNECT_TIMEOUT) == null) {
            this.env.put(INITIAL_CONNECT_TIMEOUT, new Integer(-1));
        }
        if (this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE) == null) {
            this.env.put(CLIENT_TRANSACTION_BUFFER_SIZE, new Long(0L));
        }
        if (this.env.get(FLOW_TO_DISK) == null) {
            this.env.put(FLOW_TO_DISK, new Integer(0));
        }
        if (this.env.get(SOCKET_CONNECT_TIMEOUT) == null) {
            this.env.put(SOCKET_CONNECT_TIMEOUT, new Integer(10000));
        }
        if (this.env.get(PING_INTERVAL) == null) {
            this.env.put(PING_INTERVAL, String.valueOf(60));
        }
        if (this.env.get("MULTI_TOPIC_SPLIT_DELIVERY") == null) {
            this.env.put("MULTI_TOPIC_SPLIT_DELIVERY", new Boolean(false));
        }
        if (this.env.get("QOP_CACHE_SIZE") == null) {
            this.env.put("QOP_CACHE_SIZE", new Integer(128));
        }
        if (this.env.get("MAX_DELIVERY_COUNT") == null) {
            this.env.put("MAX_DELIVERY_COUNT", new Integer(0));
        }
        if (this.env.get("ASYNCHRONOUS_DELIVERY_MODE") == null) {
            this.env.put("ASYNCHRONOUS_DELIVERY_MODE", ASYNCHRONOUS_DELIVERY_MODE_DEFAULT);
        }
        if (this.env.get("DELIVERY_CLOSE_TIMEOUT") == null) {
            this.env.put("DELIVERY_CLOSE_TIMEOUT", DELIVERY_CLOSE_TIMEOUT_DEFAULT);
        }
        if (this.env.get("DELIVERY_DOUBT_WINDOW") == null) {
            this.env.put("DELIVERY_DOUBT_WINDOW", DELIVERY_DOUBT_WINDOW_DEFAULT);
        }
        if (this.env.get(LG_ENABLED) == null) {
            this.env.put(LG_ENABLED, new Boolean(false));
        }
        if (this.env.get(LG_DOWN_STREAM_NODE_TYPE) == null) {
            this.env.put(LG_DOWN_STREAM_NODE_TYPE, new Integer(-1));
        }
        if (this.env.get(ENABLE_COMPRESSION) == null) {
            this.env.put(ENABLE_COMPRESSION, new Boolean(false));
        }
        if (this.env.get(MINIMIZE_SUBSCRIBER_TRAFFIC) == null) {
            this.env.put(MINIMIZE_SUBSCRIBER_TRAFFIC, new Boolean(false));
        }
        if (this.env.get(SEND_TIMEOUT) == null) {
            this.env.put(SEND_TIMEOUT, new Integer(0));
        }
    }

    public void setEnableLocalStore(boolean value) {
        this.initEnv();
        this.env.put(ENABLE_LOCAL_STORE, new Boolean(value));
    }

    public void setEnableLocalStoreBoolean(Boolean value) {
        this.initEnv();
        this.env.put(ENABLE_LOCAL_STORE, value);
    }

    public boolean isEnableLocalStore() {
        return (Boolean)this.env.get(ENABLE_LOCAL_STORE);
    }

    public Boolean isEnableLocalStoreBoolean() {
        return (Boolean)this.env.get(ENABLE_LOCAL_STORE);
    }

    public void setLocalStoreDirectory(String name) {
        this.initEnv();
        this.env.put(LOCAL_STORE_DIRECTORY, name);
    }

    public String getLocalStoreDirectory() {
        return (String)this.env.get(LOCAL_STORE_DIRECTORY);
    }

    public void setLocalStoreSize(long size) {
        this.initEnv();
        this.env.put(LOCAL_STORE_SIZE, new Long(size));
    }

    public void setLocalStoreSizeLong(Long size) {
        this.initEnv();
        this.env.put(LOCAL_STORE_SIZE, size);
    }

    public long getLocalStoreSize() {
        return (Long)this.env.get(LOCAL_STORE_SIZE);
    }

    public Long getLocalStoreSizeLong() {
        return (Long)this.env.get(LOCAL_STORE_SIZE);
    }

    public void setLocalStoreWaitTime(Integer seconds) {
        this.initEnv();
        this.env.put(LOCAL_STORE_WAIT_TIME, seconds);
    }

    public Integer getLocalStoreWaitTime() {
        return (Integer)this.env.get(LOCAL_STORE_WAIT_TIME);
    }

    public void setReconnectTimeout(int minutes) {
        this.initEnv();
        this.env.put(RECONNECT_TIMEOUT, new Integer(minutes));
    }

    public void setReconnectTimeoutInteger(Integer minutes) {
        this.initEnv();
        this.env.put(RECONNECT_TIMEOUT, minutes);
    }

    public int getReconnectTimeout() {
        return (Integer)this.env.get(RECONNECT_TIMEOUT);
    }

    public Integer getReconnectTimeoutInteger() {
        return (Integer)this.env.get(RECONNECT_TIMEOUT);
    }

    public void setReconnectInterval(int seconds) {
        this.initEnv();
        this.env.put(RECONNECT_INTERVAL, new Integer(seconds));
    }

    public void setReconnectIntervalInteger(Integer seconds) {
        this.initEnv();
        this.env.put(RECONNECT_INTERVAL, seconds);
    }

    public int getReconnectInterval() {
        return (Integer)this.env.get(RECONNECT_INTERVAL);
    }

    public Integer getReconnectIntervalInteger() {
        return (Integer)this.env.get(RECONNECT_INTERVAL);
    }

    public String getUrlsOrUrl() {
        String urls = (String)this.env.get("brokerList");
        if (urls != null && urls.length() > 0) {
            return urls;
        }
        return this.getBrokerURL();
    }

    public void setLoginSPI(String className) {
        this.env.put("login_spi_classname", className);
    }

    public String getLoginSPI() {
        return (String)this.env.get("login_spi_classname");
    }

    public void setSelectorAtBroker(Boolean flag) {
        this.initEnv();
        this.env.put("selectorAtBroker", flag);
    }

    public Boolean getSelectorAtBroker() {
        if (this.env.containsKey("selectorAtBroker")) {
            return (Boolean)this.env.get("selectorAtBroker");
        }
        return Boolean.FALSE;
    }

    public void setDurableMessageOrder(Boolean durableSubscriberMessageOrder) {
        this.initEnv();
        this.env.put("durableSubscriberMessageOrder", durableSubscriberMessageOrder);
    }

    public Boolean getDurableMessageOrder() {
        if (this.env.containsKey("durableSubscriberMessageOrder")) {
            return (Boolean)this.env.get("durableSubscriberMessageOrder");
        }
        return Boolean.FALSE;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(ConnectionFactory.class.getName(), AdministeredObjectFactory.class.getName(), null);
        this.addReferences(ref);
        return ref;
    }

    protected void addReferences(Reference ref) {
        if (this.env != null) {
            String loginSPI;
            if (this.env.get(ENABLE_LOCAL_STORE) != null) {
                ref.add(new StringRefAddr(ENABLE_LOCAL_STORE, String.valueOf(this.isEnableLocalStore())));
            }
            if (this.env.get(LOCAL_STORE_DIRECTORY) != null) {
                ref.add(new StringRefAddr(LOCAL_STORE_DIRECTORY, this.getLocalStoreDirectory()));
            }
            if (this.env.get(LOCAL_STORE_SIZE) != null) {
                ref.add(new StringRefAddr(LOCAL_STORE_SIZE, String.valueOf(this.getLocalStoreSize())));
            }
            if (this.env.get(RECONNECT_TIMEOUT) != null) {
                ref.add(new StringRefAddr(RECONNECT_TIMEOUT, String.valueOf(this.getReconnectTimeout())));
            }
            if (this.env.get(RECONNECT_INTERVAL) != null) {
                ref.add(new StringRefAddr(RECONNECT_INTERVAL, String.valueOf(this.getReconnectInterval())));
            }
            if (this.env.get(FAULT_TOLERANT) != null) {
                ref.add(new StringRefAddr(FAULT_TOLERANT, String.valueOf(this.getFaultTolerant())));
            }
            if (this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT) != null) {
                ref.add(new StringRefAddr(FAULT_TOLERANT_RECONNECT_TIMEOUT, String.valueOf(this.getFaultTolerantReconnectTimeout())));
            }
            if (this.env.get(INITIAL_CONNECT_TIMEOUT) != null) {
                ref.add(new StringRefAddr(INITIAL_CONNECT_TIMEOUT, String.valueOf(this.getInitialConnectTimeout())));
            }
            if (this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE) != null) {
                ref.add(new StringRefAddr(CLIENT_TRANSACTION_BUFFER_SIZE, String.valueOf(this.getClientTransactionBufferSize())));
            }
            if (this.env.get(FLOW_TO_DISK) != null) {
                ref.add(new StringRefAddr(FLOW_TO_DISK, String.valueOf(this.getFlowToDisk())));
            }
            if (this.env.get(SOCKET_CONNECT_TIMEOUT) != null) {
                ref.add(new StringRefAddr(SOCKET_CONNECT_TIMEOUT, String.valueOf(this.getSocketConnectTimeout())));
            }
            if (this.env.get("MULTI_TOPIC_SPLIT_DELIVERY") != null) {
                ref.add(new StringRefAddr("MULTI_TOPIC_SPLIT_DELIVERY", this.getSplitMultiTopicDelivery().toString()));
            }
            if (this.env.get("QOP_CACHE_SIZE") != null) {
                ref.add(new StringRefAddr("QOP_CACHE_SIZE", this.getQopCacheSize().toString()));
            }
            if (this.env.get(LOCAL_STORE_WAIT_TIME) != null) {
                ref.add(new StringRefAddr(LOCAL_STORE_WAIT_TIME, String.valueOf(this.getLocalStoreWaitTime())));
            }
            if ((loginSPI = (String)this.env.get("login_spi_classname")) != null && loginSPI.length() > 0) {
                ref.add(new StringRefAddr("login_spi_classname", loginSPI));
            }
            if (this.env.get("defaultTxnBatchSize") != null) {
                ref.add(new StringRefAddr("defaultTxnBatchSize", String.valueOf(this.getDefaultTxnBatchSize())));
            }
            if (this.env.get("MAX_DELIVERY_COUNT") != null) {
                ref.add(new StringRefAddr("MAX_DELIVERY_COUNT", String.valueOf(this.getMaxDeliveryCount())));
            }
            if (this.env.get(LG_ENABLED) != null) {
                ref.add(new StringRefAddr(LG_ENABLED, String.valueOf(this.getEnableActionalInstrumentation())));
            }
            if (this.env.get(LG_DOWN_STREAM_NODE_TYPE) != null) {
                ref.add(new StringRefAddr(LG_DOWN_STREAM_NODE_TYPE, String.valueOf(this.getLGDownStreamNodeType())));
            }
            if (this.env.get(ENABLE_COMPRESSION) != null) {
                ref.add(new StringRefAddr(ENABLE_COMPRESSION, String.valueOf(this.getEnableCompression())));
            }
            if (this.env.get(COMPRESSION_FACTORY) != null) {
                ref.add(new StringRefAddr(COMPRESSION_FACTORY, this.getCompressionFactory()));
            }
            if (this.env.get(MINIMIZE_SUBSCRIBER_TRAFFIC) != null) {
                ref.add(new StringRefAddr(MINIMIZE_SUBSCRIBER_TRAFFIC, String.valueOf(this.getMinimizeSubscriberTraffic())));
            }
            if (this.env.get(SEND_TIMEOUT) != null) {
                ref.add(new StringRefAddr(SEND_TIMEOUT, String.valueOf(this.getSendTimeout())));
            }
        }
        ref.add(new StringRefAddr("brokerURL", this.brokerURL));
        if (this.connectID != null) {
            if (this.connectID.length() == 0) {
                ref.add(new StringRefAddr("connectID", "\"\""));
            } else {
                ref.add(new StringRefAddr("connectID", this.connectID));
            }
        }
        ref.add(new StringRefAddr("defaultUserName", this.defaultUserName));
        ref.add(new StringRefAddr("defaultPassword", this.defaultPassword));
        if (this.clientID != null) {
            if (this.clientID.length() == 0) {
                ref.add(new StringRefAddr("clientID", "\"\""));
            } else {
                ref.add(new StringRefAddr("clientID", this.clientID));
            }
        }
        ref.add(new StringRefAddr("versionID", "12.0"));
        if (this.env != null) {
            if (this.env.get("brokerList") != null) {
                ref.add(new StringRefAddr("brokerList", (String)this.env.get("brokerList")));
            }
            if (this.env.get("randomizeBrokers") != null) {
                ref.add(new StringRefAddr("randomizeBrokers", (String)this.env.get("randomizeBrokers")));
            }
            if (this.env.get("loadBalancing") != null) {
                ref.add(new StringRefAddr("loadBalancing", (String)this.env.get("loadBalancing")));
            }
            if (this.env.get("clientData") != null) {
                ref.add(new StringRefAddr("clientData", (String)this.env.get("clientData")));
            }
            if (this.env.get("persistentDelivery") != null) {
                ref.add(new StringRefAddr("persistentDelivery", (String)this.env.get("persistentDelivery")));
            }
            if (this.env.get("monitorInterval") != null) {
                ref.add(new StringRefAddr("monitorInterval", (String)this.env.get("monitorInterval")));
            }
            if (this.env.get(PING_INTERVAL) != null) {
                ref.add(new StringRefAddr(PING_INTERVAL, (String)this.env.get(PING_INTERVAL)));
            }
            if (this.env.get("prefetchCount") != null) {
                ref.add(new StringRefAddr("prefetchCount", (String)this.env.get("prefetchCount")));
            }
            if (this.env.get("prefetchThreshold") != null) {
                ref.add(new StringRefAddr("prefetchThreshold", (String)this.env.get("prefetchThreshold")));
            }
            if (this.env.get("selectorAtBroker") != null) {
                ref.add(new StringRefAddr("selectorAtBroker", ((Boolean)this.env.get("selectorAtBroker")).toString()));
            }
            if (this.env.get("durableSubscriberMessageOrder") != null) {
                ref.add(new StringRefAddr("durableSubscriberMessageOrder", ((Boolean)this.env.get("durableSubscriberMessageOrder")).toString()));
            }
            if (this.env.get("RESOLVED_BROKER_LIST") != null) {
                ref.add(new StringRefAddr("RESOLVED_BROKER_LIST", (String)this.env.get("RESOLVED_BROKER_LIST")));
            }
        }
        ref.add(new StringRefAddr("ASYNCHRONOUS_DELIVERY_MODE", this.getAsynchronousDeliveryMode().toString()));
        ref.add(new StringRefAddr("DELIVERY_CLOSE_TIMEOUT", this.getDeliveryCloseTimeout().toString()));
        ref.add(new StringRefAddr("DELIVERY_DOUBT_WINDOW", this.getDeliveryDoubtWindow().toString()));
    }

    void setEnv(Hashtable factoryEnv) {
        this.env = factoryEnv;
        this.setDefaultProperties();
        if (this.brokerURL != null && !this.env.containsKey("brokerList")) {
            this.env.put("brokerList", this.brokerURL);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.brokerURL != null && this.env == null || !this.env.containsKey("brokerList")) {
            this.setConnectionURLs(this.brokerURL);
        }
        this.setDefaultProperties();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    public void setPingInterval(long seconds) {
        this.setPingIntervalLong(new Long(seconds));
    }

    public long getPingInterval() {
        return this.getPingIntervalLong();
    }

    public void setPingIntervalLong(Long seconds) {
        this.initEnv();
        this.env.put(PING_INTERVAL, seconds.toString());
    }

    public Long getPingIntervalLong() {
        if (this.env == null) {
            return new Long(60L);
        }
        String interval = (String)this.env.get(PING_INTERVAL);
        return interval == null ? new Long(60L) : Long.valueOf(interval.trim());
    }

    public void setMonitorInterval(Integer seconds) {
        if (seconds < 0 && !seconds.equals(Constants.MONITOR_INTERVAL_USE_BROKER_SETTING)) {
            throw new IllegalArgumentException(prAccessor.getString("INVALID_INTERVAL"));
        }
        this.initEnv();
        this.env.put("monitorInterval", seconds.toString());
    }

    public Integer getMonitorInterval() {
        if (this.env == null) {
            return Constants.MONITOR_INTERVAL_USE_BROKER_SETTING;
        }
        String interval = (String)this.env.get("monitorInterval");
        return interval == null ? Constants.MONITOR_INTERVAL_USE_BROKER_SETTING : Integer.valueOf(interval.trim());
    }

    public void setFaultTolerant(Boolean faultTolerant) {
        this.initEnv();
        this.env.put(FAULT_TOLERANT, faultTolerant);
    }

    public Boolean getFaultTolerant() {
        return (Boolean)this.env.get(FAULT_TOLERANT);
    }

    public void setFaultTolerantReconnectTimeout(Integer seconds) {
        this.initEnv();
        this.env.put(FAULT_TOLERANT_RECONNECT_TIMEOUT, seconds);
    }

    public Integer getFaultTolerantReconnectTimeout() {
        return (Integer)this.env.get(FAULT_TOLERANT_RECONNECT_TIMEOUT);
    }

    public void setInitialConnectTimeout(Integer seconds) {
        this.initEnv();
        this.env.put(INITIAL_CONNECT_TIMEOUT, seconds);
    }

    public Integer getInitialConnectTimeout() {
        return (Integer)this.env.get(INITIAL_CONNECT_TIMEOUT);
    }

    public void setClientTransactionBufferSize(Long size) {
        this.initEnv();
        this.env.put(CLIENT_TRANSACTION_BUFFER_SIZE, size);
    }

    public Long getClientTransactionBufferSize() {
        return (Long)this.env.get(CLIENT_TRANSACTION_BUFFER_SIZE);
    }

    public void setFlowToDisk(Integer flag) {
        if (flag > 2 || flag < 0) {
            return;
        }
        this.initEnv();
        this.env.put(FLOW_TO_DISK, flag);
    }

    public Integer getFlowToDisk() {
        if (this.env.containsKey(FLOW_TO_DISK)) {
            return (Integer)this.env.get(FLOW_TO_DISK);
        }
        return new Integer(0);
    }

    public void setSocketConnectTimeout(Integer milliseconds) {
        this.initEnv();
        this.env.put(SOCKET_CONNECT_TIMEOUT, milliseconds);
    }

    public Integer getSocketConnectTimeout() {
        Integer timeout = (Integer)this.env.get(SOCKET_CONNECT_TIMEOUT);
        if (timeout == null) {
            timeout = new Integer(10000);
        }
        return timeout;
    }

    protected Hashtable getEnv() {
        return this.env;
    }

    @Deprecated
    public String getBrokerURL() {
        return this.brokerURL;
    }

    @Deprecated
    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
        if (this.brokerURL != null) {
            this.initEnv();
            this.env.put("brokerList", this.brokerURL);
            this.env.put("RESOLVED_BROKER_LIST", this.brokerURL.startsWith("sonicrn:///") ? "" : this.brokerURL);
        }
    }

    public String getConnectID() {
        return this.connectID;
    }

    public void setConnectID(String connectID) {
        this.connectID = connectID;
    }

    public String getDefaultUser() {
        return this.defaultUserName;
    }

    public void setDefaultUser(String username) {
        this.defaultUserName = username;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String password) {
        this.defaultPassword = password;
    }

    @Deprecated
    public String getBrokerHostName() {
        return this.brokerHostName;
    }

    @Deprecated
    public void setBrokerHostName(String brokerHostName) {
        this.brokerHostName = brokerHostName;
    }

    @Deprecated
    public String getBrokerProtocol() {
        return this.brokerProtocol;
    }

    @Deprecated
    public void setBrokerProtocol(String brokerProtocol) {
        this.brokerProtocol = brokerProtocol;
    }

    @Deprecated
    public int getBrokerPort() {
        return this.brokerPort;
    }

    @Deprecated
    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String getClientID() {
        return this.clientID;
    }

    public final void setClientID(String clientID) throws JMSException {
        if (clientID.indexOf("#") != -1 || clientID.indexOf("*") != -1 || clientID.indexOf("$") != -1 || clientID.indexOf(".") != -1) {
            throw new InvalidClientIDException(prAccessor.getString("CONN_INVALID_CLIENT_ID") + clientID);
        }
        this.clientID = clientID;
    }

    public void setLoadBalancing(boolean loadBalancing) {
        this.initEnv();
        this.env.put("loadBalancing", new Boolean(loadBalancing).toString());
    }

    public void setLoadBalancingBoolean(Boolean loadBalancing) {
        this.initEnv();
        this.env.put("loadBalancing", loadBalancing.toString());
    }

    public boolean getLoadBalancing() {
        if (this.env == null) {
            return false;
        }
        String loadBalancing = (String)this.env.get("loadBalancing");
        return loadBalancing != null ? Boolean.valueOf(loadBalancing.trim()) : false;
    }

    public Boolean getLoadBalancingBoolean() {
        if (this.env == null) {
            return Boolean.FALSE;
        }
        String loadBalancing = (String)this.env.get("loadBalancing");
        return loadBalancing != null ? Boolean.valueOf(loadBalancing.trim()) : Boolean.FALSE;
    }

    public void setLoadBalancingClientData(String clientData) {
        this.initEnv();
        if (clientData == null || clientData.trim().length() == 0) {
            this.env.remove("clientData");
            return;
        }
        this.env.put("clientData", clientData);
    }

    public String getLoadBalancingClientData() {
        if (this.env == null) {
            return null;
        }
        return (String)this.env.get("clientData");
    }

    public void setConnectionURLs(String brokerList) {
        this.initEnv();
        this.env.put("brokerList", brokerList);
        this.env.put("RESOLVED_BROKER_LIST", brokerList.startsWith("sonicrn:///") ? "" : brokerList);
    }

    public String getConnectionURLs() {
        if (this.env == null) {
            return null;
        }
        return (String)this.env.get("brokerList");
    }

    public void setSequential(boolean sequential) {
        this.initEnv();
        this.env.put("randomizeBrokers", new Boolean(!sequential).toString());
    }

    public void setSequentialBoolean(Boolean sequential) {
        this.initEnv();
        this.env.put("randomizeBrokers", new Boolean(sequential == false).toString());
    }

    public boolean getSequential() {
        if (this.env == null) {
            return true;
        }
        String randomize = (String)this.env.get("randomizeBrokers");
        return randomize == null || !Boolean.valueOf(randomize.trim()).booleanValue();
    }

    public Boolean getSequentialBoolean() {
        if (this.env == null) {
            return Boolean.TRUE;
        }
        String randomize = (String)this.env.get("randomizeBrokers");
        return new Boolean(randomize == null || !Boolean.valueOf(randomize.trim()).booleanValue());
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        this.initEnv();
        this.env.put("persistentDelivery", new Boolean(persistentDelivery).toString());
    }

    public void setPersistentDeliveryBoolean(Boolean persistentDelivery) {
        this.initEnv();
        this.env.put("persistentDelivery", persistentDelivery.toString());
    }

    public boolean getPersistentDelivery() {
        if (this.env == null) {
            return false;
        }
        String persistentDelivery = (String)this.env.get("persistentDelivery");
        return persistentDelivery != null ? Boolean.valueOf(persistentDelivery.trim()) : false;
    }

    public Boolean getPersistentDeliveryBoolean() {
        if (this.env == null) {
            return Boolean.FALSE;
        }
        String persistentDelivery = (String)this.env.get("persistentDelivery");
        return persistentDelivery != null ? Boolean.valueOf(persistentDelivery.trim()) : Boolean.FALSE;
    }

    public void setPrefetchCount(int count) {
        this.setPrefetchCountInteger(new Integer(count));
    }

    public int getPrefetchCount() {
        return this.getPrefetchCountInteger();
    }

    public void setPrefetchCountInteger(Integer count) {
        this.initEnv();
        this.env.put("prefetchCount", count.toString());
    }

    public Integer getPrefetchCountInteger() {
        if (this.env == null) {
            return new Integer(-1);
        }
        String val = (String)this.env.get("prefetchCount");
        return val == null ? new Integer(-1) : Integer.valueOf(val.trim());
    }

    public void setPrefetchThreshold(int val) {
        this.setPrefetchThresholdInteger(new Integer(val));
    }

    public int getPrefetchThreshold() {
        return this.getPrefetchThresholdInteger();
    }

    public void setPrefetchThresholdInteger(Integer val) {
        this.initEnv();
        this.env.put("prefetchThreshold", val.toString());
    }

    public Integer getPrefetchThresholdInteger() {
        if (this.env == null) {
            return new Integer(-1);
        }
        String val = (String)this.env.get("prefetchThreshold");
        return val == null ? new Integer(-1) : Integer.valueOf(val.trim());
    }

    protected void checkSPILoginBind() throws JMSSecurityException {
        String loginClassName;
        ILogin loginSpiImpl;
        if (this.env != null && !this.env.containsKey(LOGIN_SPI_OBJECT) && (loginSpiImpl = SessionConfig.createILoginInstance(loginClassName = (String)this.env.get("login_spi_classname"))) != null) {
            this.env.put(LOGIN_SPI_OBJECT, loginSpiImpl);
        }
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.createConnection(this.defaultUserName, this.defaultPassword);
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        this.checkSPILoginBind();
        SessionConfig.initHTTPSProxySetting();
        this.resolveConnectionURLs();
        return new progress.message.jimpl.Connection(this.connectID, userName, password, this.applet, this.clientID, this.env);
    }

    @Override
    public javax.jms.JMSContext createContext() {
        return this.createContext(this.defaultUserName, this.defaultPassword);
    }

    @Override
    public javax.jms.JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, 1);
    }

    @Override
    public javax.jms.JMSContext createContext(int sessionMode) {
        return this.createContext(this.defaultUserName, this.defaultPassword, sessionMode);
    }

    @Override
    public javax.jms.JMSContext createContext(String userName, String password, int sessionMode) {
        try {
            ConnectionFactory.validateSessionMode(sessionMode);
            return new JMSContext(this.createConnection(userName, password), sessionMode);
        }
        catch (JMSException e) {
            throw JMSExceptionUtils.convertToRuntimeException(e);
        }
    }

    private static void validateSessionMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new JMSRuntimeException("Invalid Session Mode: " + mode);
    }

    public void setDefaultTxnBatchSize(int size) {
        this.setDefaultTxnBatchSizeInteger(new Integer(size));
    }

    public int getDefaultTxnBatchSize() {
        return this.getDefaultTxnBatchSizeInteger();
    }

    public void setDefaultTxnBatchSizeInteger(Integer size) {
        this.initEnv();
        this.env.put("defaultTxnBatchSize", size);
    }

    public Integer getDefaultTxnBatchSizeInteger() {
        if (this.env == null) {
            return new Integer(51200);
        }
        Integer txnsize = null;
        Integer size = (Integer)this.env.get("defaultTxnBatchSize");
        txnsize = size == null ? new Integer(51200) : size;
        return txnsize;
    }

    public Boolean getSplitMultiTopicDelivery() {
        if (this.env == null) {
            return new Boolean(false);
        }
        Boolean val = (Boolean)this.env.get("MULTI_TOPIC_SPLIT_DELIVERY");
        return val == null ? new Boolean(false) : val;
    }

    public void setSplitMultiTopicDelivery(Boolean value) {
        this.initEnv();
        this.env.put("MULTI_TOPIC_SPLIT_DELIVERY", value);
    }

    public Boolean getRethrowCCRuntimeExceptions() {
        if (this.env == null) {
            return new Boolean(false);
        }
        Boolean val = (Boolean)this.env.get("RETHROW_CC_RUNTIME_EXCEPTIONS");
        return val == null ? new Boolean(false) : val;
    }

    public void setRethrowCCRuntimeExceptions(Boolean value) {
        this.initEnv();
        this.env.put("RETHROW_CC_RUNTIME_EXCEPTIONS", value);
    }

    public Integer getQopCacheSize() {
        if (this.env == null) {
            return new Integer(128);
        }
        Integer val = (Integer)this.env.get("QOP_CACHE_SIZE");
        return val == null ? new Integer(128) : val;
    }

    public void setQopCacheSize(Integer value) {
        this.initEnv();
        this.env.put("QOP_CACHE_SIZE", value);
    }

    public Integer getMaxDeliveryCount() {
        if (this.env == null) {
            return new Integer(0);
        }
        Integer val = (Integer)this.env.get("MAX_DELIVERY_COUNT");
        return val == null ? new Integer(0) : val;
    }

    public void setMaxDeliveryCount(Integer value) {
        this.initEnv();
        this.env.put("MAX_DELIVERY_COUNT", value);
    }

    public void setMaxSendBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("MAX_IO_SEND_BUFFER_SIZE");
        } else {
            this.env.put("MAX_IO_SEND_BUFFER_SIZE", value);
        }
    }

    public Integer getMaxSendBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("MAX_IO_SEND_BUFFER_SIZE");
    }

    public void setMinSendBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("MIN_IO_SEND_BUFFER_SIZE");
        } else {
            this.env.put("MIN_IO_SEND_BUFFER_SIZE", value);
        }
    }

    public Integer getMinSendBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("MIN_IO_SEND_BUFFER_SIZE");
    }

    public void setInitialSendBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("INITIAL_IO_SEND_BUFFER_SIZE");
        } else {
            this.env.put("INITIAL_IO_SEND_BUFFER_SIZE", value);
        }
    }

    public Integer getInitialSendBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("INITIAL_IO_SEND_BUFFER_SIZE");
    }

    public void setMaxRcvBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("MAX_IO_RCV_BUFFER_SIZE");
        } else {
            this.env.put("MAX_IO_RCV_BUFFER_SIZE", value);
        }
    }

    public Integer getMaxRcvBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("MAX_IO_RCV_BUFFER_SIZE");
    }

    public void setMinRcvBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("MIN_IO_RCV_BUFFER_SIZE");
        } else {
            this.env.put("MIN_IO_RCV_BUFFER_SIZE", value);
        }
    }

    public Integer getMinRcvBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("MIN_IO_RCV_BUFFER_SIZE");
    }

    public void setInitialRcvBufferSize(Integer value) {
        this.initEnv();
        if (value == null) {
            this.env.remove("INITIAL_IO_RCV_BUFFER_SIZE");
        } else {
            this.env.put("INITIAL_IO_RCV_BUFFER_SIZE", value);
        }
    }

    public Integer getInitialRcvBufferSize() {
        if (this.env == null) {
            return null;
        }
        return (Integer)this.env.get("INITIAL_IO_RCV_BUFFER_SIZE");
    }

    public final void setAsynchronousDeliveryMode(Integer mode) throws IllegalArgumentException {
        if (!(Constants.ASYNC_DELIVERY_MODE_DEFAULT.equals(mode) || Constants.ASYNC_DELIVERY_MODE_DISABLED.equals(mode) || Constants.ASYNC_DELIVERY_MODE_ENABLED.equals(mode))) {
            throw new IllegalArgumentException("" + mode);
        }
        this.initEnv();
        this.env.put("ASYNCHRONOUS_DELIVERY_MODE", mode);
    }

    public final Integer getAsynchronousDeliveryMode() {
        Integer val = null;
        if (this.env != null) {
            val = (Integer)this.env.get("ASYNCHRONOUS_DELIVERY_MODE");
        }
        if (val != null) {
            return val;
        }
        return ASYNCHRONOUS_DELIVERY_MODE_DEFAULT;
    }

    public final void setDeliveryCloseTimeout(Long milliseconds) throws IllegalArgumentException {
        if (milliseconds == null) {
            throw new IllegalArgumentException("" + milliseconds);
        }
        if (milliseconds < -1L) {
            throw new IllegalArgumentException("" + milliseconds);
        }
        this.initEnv();
        this.env.put("DELIVERY_CLOSE_TIMEOUT", milliseconds);
    }

    public final Long getDeliveryCloseTimeout() {
        Long val = null;
        if (this.env != null) {
            val = (Long)this.env.get("DELIVERY_CLOSE_TIMEOUT");
        }
        if (val != null) {
            return val;
        }
        return DELIVERY_CLOSE_TIMEOUT_DEFAULT;
    }

    public final void setDeliveryDoubtWindow(Integer numMessages) throws IllegalArgumentException {
        if (numMessages == null) {
            throw new IllegalArgumentException("" + numMessages);
        }
        if (numMessages < 0) {
            throw new IllegalArgumentException("" + numMessages);
        }
        this.initEnv();
        this.env.put("DELIVERY_DOUBT_WINDOW", numMessages);
    }

    public final Integer getDeliveryDoubtWindow() {
        Integer val = null;
        if (this.env != null) {
            val = (Integer)this.env.get("DELIVERY_DOUBT_WINDOW");
        }
        if (val != null) {
            return val;
        }
        return DELIVERY_DOUBT_WINDOW_DEFAULT;
    }

    public void setEnableActionalInstrumentation(boolean enabled) {
        this.initEnv();
        this.env.put(LG_ENABLED, new Boolean(enabled));
    }

    public void setEnableActionalInstrumentationBoolean(Boolean enabled) {
        this.initEnv();
        this.env.put(LG_ENABLED, enabled);
    }

    public boolean getEnableActionalInstrumentation() {
        return (Boolean)this.env.get(LG_ENABLED);
    }

    public Boolean getEnableActionalInstrumentationBoolean() {
        return (Boolean)this.env.get(LG_ENABLED);
    }

    public void setRequireActionalJMSNode(boolean required) {
        this.initEnv();
        if (required) {
            this.setLGDownStreamNodeType(1);
        }
    }

    public void setRequireActionalJMSNodeBoolean(Boolean required) {
        this.initEnv();
        if (required.booleanValue()) {
            this.setLGDownStreamNodeType(1);
        }
    }

    public boolean getRequireActionalJMSNode() {
        int type = this.getLGDownStreamNodeType();
        return type == 1;
    }

    public Boolean getRequireActionalJMSNodeBoolean() {
        int type = this.getLGDownStreamNodeType();
        return new Boolean(type == 1);
    }

    public void setLGDownStreamNodeType(int peerType) {
        this.initEnv();
        this.env.put(LG_DOWN_STREAM_NODE_TYPE, new Integer(peerType));
    }

    public int getLGDownStreamNodeType() {
        Integer val = (Integer)this.env.get(LG_DOWN_STREAM_NODE_TYPE);
        if (val != null) {
            return val;
        }
        return -1;
    }

    public void setEnableCompression(boolean enabled) {
        this.initEnv();
        this.env.put(ENABLE_COMPRESSION, new Boolean(enabled));
    }

    public boolean getEnableCompression() {
        return (Boolean)this.env.get(ENABLE_COMPRESSION);
    }

    public void setEnableCompressionBoolean(Boolean enabled) {
        this.initEnv();
        this.env.put(ENABLE_COMPRESSION, enabled);
    }

    public Boolean getEnableCompressionBoolean() {
        return (Boolean)this.env.get(ENABLE_COMPRESSION);
    }

    public void setCompressionFactory(String factory) {
        this.initEnv();
        this.env.put(COMPRESSION_FACTORY, factory);
    }

    public String getCompressionFactory() {
        return (String)this.env.get(COMPRESSION_FACTORY);
    }

    public void setMinimizeSubscriberTraffic(boolean minimizeTraffic) {
        this.initEnv();
        this.env.put(MINIMIZE_SUBSCRIBER_TRAFFIC, new Boolean(minimizeTraffic));
    }

    public boolean getMinimizeSubscriberTraffic() {
        return (Boolean)this.env.get(MINIMIZE_SUBSCRIBER_TRAFFIC);
    }

    public void setMinimizeSubscriberTrafficBoolean(Boolean minimizeTraffic) {
        this.initEnv();
        this.env.put(MINIMIZE_SUBSCRIBER_TRAFFIC, minimizeTraffic);
    }

    public Boolean getMinimizeSubscriberTrafficBoolean() {
        return (Boolean)this.env.get(MINIMIZE_SUBSCRIBER_TRAFFIC);
    }

    public void setSendTimeout(int milliseconds) {
        this.initEnv();
        this.env.put(SEND_TIMEOUT, milliseconds);
    }

    public int getSendTimeout() {
        return (Integer)this.env.get(SEND_TIMEOUT);
    }

    void setResolvedConnectionURLs(String brokerList) {
        this.initEnv();
        this.env.put("RESOLVED_BROKER_LIST", brokerList);
    }

    private void initEnv() {
        if (this.env == null) {
            this.env = new Hashtable();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setNamingContext(Context ctx) {
        this.context = ctx;
    }

    public String getResolvedConnectionURLs() {
        if (this.env == null) {
            return null;
        }
        return (String)this.env.get("RESOLVED_BROKER_LIST");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resolveConnectionURLs() throws JMSException {
        String unresolvedConnectionURLs = (String)this.env.get("brokerList");
        if (unresolvedConnectionURLs.startsWith("sonicrn:///")) {
            if (this.context == null) return;
            try {
                Class[] parameters = new Class[]{String.class};
                Method m = this.context.getClass().getMethod("resolveURL", parameters);
                Object[] args = new Object[]{unresolvedConnectionURLs};
                String result = (String)m.invoke((Object)this.context, args);
                this.setResolvedConnectionURLs(result);
                return;
            }
            catch (Exception e) {
                if (this.getResolvedConnectionURLs() != null && this.getResolvedConnectionURLs().length() != 0) return;
                EUnresolvedConnectionURLs ex1 = new EUnresolvedConnectionURLs(unresolvedConnectionURLs, this.getResolvedConnectionURLs());
                ex1.initCause(e);
                throw JMSExceptionUtil.createJMSException(ex1);
            }
        } else {
            this.setResolvedConnectionURLs(unresolvedConnectionURLs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + " properties: ");
        if (this.brokerHostName != null) {
            sb = sb.append(" brokerHostName= ").append(this.brokerHostName);
        }
        if (this.brokerProtocol != null) {
            sb = sb.append("; brokerProtocol= ").append(this.brokerProtocol);
        }
        sb = sb.append("; brokerPort= ").append(this.brokerPort);
        if (this.brokerURL != null) {
            sb = sb.append("; brokerURL= ").append(this.brokerURL);
        }
        if (this.clientID != null) {
            sb = sb.append("; clientID= ").append(this.clientID);
        }
        if (this.connectID != null) {
            sb = sb.append("; connectID= ").append(this.connectID);
        }
        if (this.env != null) {
            sb.append("; ENV= { ");
            for (Map.Entry me : this.env.entrySet()) {
                String key = (String)me.getKey();
                Object val = me.getValue();
                sb = sb.append("; ").append(key).append("= ").append(val);
            }
            sb.append(" }");
        }
        return sb.toString();
    }

    static {
        DiagnosticsManagerAccess.createManager();
        DebugState.registerSonicDiagnostics();
        DELIVERY_CLOSE_TIMEOUT_DEFAULT = new Long(0L);
        DELIVERY_DOUBT_WINDOW_DEFAULT = new Integer(0);
        ASYNCHRONOUS_DELIVERY_MODE_DEFAULT = Constants.ASYNC_DELIVERY_MODE_DEFAULT;
    }
}

