/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.DataInput;
import java.io.IOException;
import progress.message.util.EMessageFormatException;

public class TypedInputStream {
    static final int TYPE_BOOLEAN = 0;
    static final int TYPE_BYTE = 1;
    static final int TYPE_SHORT = 2;
    static final int TYPE_CHAR = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_FLOAT = 6;
    static final int TYPE_DOUBLE = 7;
    static final int TYPE_STRING = 8;
    static final int TYPE_BYTES = 9;
    static final int TYPE_EMPTY_STRING = 10;
    static final int TYPE_NULL_STRING = 11;
    private int m_type = -1;
    private DataInput m_datain = null;

    public TypedInputStream(DataInput in) {
        this.m_datain = in;
    }

    public boolean readBoolean() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 0: {
                this.clearType();
                return this.m_datain.readBoolean();
            }
            case 8: {
                this.clearType();
                return Boolean.valueOf(this.m_datain.readUTF());
            }
            case 10: 
            case 11: {
                this.clearType();
                return false;
            }
        }
        throw new EMessageFormatException("");
    }

    public byte readByte() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 8: {
                this.clearType();
                return Byte.valueOf(this.m_datain.readUTF());
            }
            case 10: 
            case 11: {
                this.clearType();
                return 0;
            }
        }
        throw new EMessageFormatException("");
    }

    public int readBytes(byte[] value) throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 9: {
                this.clearType();
                int length = this.m_datain.readInt();
                int count = value.length > length ? length : value.length;
                this.m_datain.readFully(value, 0, count);
                this.m_datain.skipBytes(length - count);
                return count;
            }
        }
        throw new EMessageFormatException("");
    }

    public char readChar() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 3: {
                this.clearType();
                return this.m_datain.readChar();
            }
            case 8: {
                this.clearType();
                String str = this.m_datain.readUTF();
                if (str.length() == 0) {
                    return '\u0000';
                }
                return str.charAt(0);
            }
            case 10: 
            case 11: {
                this.clearType();
                return '\u0000';
            }
        }
        throw new EMessageFormatException("");
    }

    public double readDouble() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 7: {
                this.clearType();
                return this.m_datain.readDouble();
            }
            case 6: {
                this.clearType();
                return new Float(this.m_datain.readFloat()).doubleValue();
            }
            case 8: {
                this.clearType();
                return Double.valueOf(this.m_datain.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public float readFloat() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 6: {
                this.clearType();
                return this.m_datain.readFloat();
            }
            case 8: {
                this.clearType();
                return Float.valueOf(this.m_datain.readUTF()).floatValue();
            }
        }
        throw new EMessageFormatException("");
    }

    public int readInt() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 4: {
                this.clearType();
                return this.m_datain.readInt();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 8: {
                this.clearType();
                return Integer.valueOf(this.m_datain.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public long readLong() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 5: {
                this.clearType();
                return this.m_datain.readLong();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 4: {
                this.clearType();
                return this.m_datain.readInt();
            }
            case 8: {
                this.clearType();
                return Long.valueOf(this.m_datain.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public Object readObject() throws IOException {
        switch (this.getType()) {
            case 0: {
                this.clearType();
                return new Boolean(this.m_datain.readBoolean());
            }
            case 1: {
                this.clearType();
                return new Byte(this.m_datain.readByte());
            }
            case 9: {
                this.clearType();
                int length = this.m_datain.readInt();
                byte[] value = new byte[length];
                this.m_datain.readFully(value);
                return value;
            }
            case 3: {
                this.clearType();
                return new Character(this.m_datain.readChar());
            }
            case 7: {
                this.clearType();
                return new Double(this.m_datain.readDouble());
            }
            case 6: {
                this.clearType();
                return new Float(this.m_datain.readFloat());
            }
            case 4: {
                this.clearType();
                return new Integer(this.m_datain.readInt());
            }
            case 5: {
                this.clearType();
                return new Long(this.m_datain.readLong());
            }
            case 2: {
                this.clearType();
                return new Short(this.m_datain.readShort());
            }
            case 8: {
                this.clearType();
                return this.m_datain.readUTF();
            }
            case 10: 
            case 11: {
                this.clearType();
                return "";
            }
        }
        throw new IOException("Unexpected type code found in stream");
    }

    public short readShort() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 8: {
                this.clearType();
                return Short.valueOf(this.m_datain.readUTF());
            }
        }
        throw new EMessageFormatException("");
    }

    public String readString() throws IOException, EMessageFormatException {
        switch (this.getType()) {
            case 8: {
                this.clearType();
                return this.m_datain.readUTF();
            }
            case 0: {
                this.clearType();
                return String.valueOf(this.m_datain.readBoolean());
            }
            case 1: {
                this.clearType();
                return String.valueOf(this.m_datain.readByte());
            }
            case 3: {
                this.clearType();
                return String.valueOf(this.m_datain.readChar());
            }
            case 7: {
                this.clearType();
                return String.valueOf(this.m_datain.readDouble());
            }
            case 6: {
                this.clearType();
                return String.valueOf(this.m_datain.readFloat());
            }
            case 4: {
                this.clearType();
                return String.valueOf(this.m_datain.readInt());
            }
            case 5: {
                this.clearType();
                return String.valueOf(this.m_datain.readLong());
            }
            case 2: {
                this.clearType();
                return String.valueOf(this.m_datain.readShort());
            }
            case 10: 
            case 11: {
                this.clearType();
                return "";
            }
        }
        throw new EMessageFormatException("");
    }

    private int getType() throws IOException {
        if (this.m_type == -1) {
            this.m_type = this.m_datain.readByte();
        }
        return this.m_type;
    }

    private void clearType() {
        this.m_type = -1;
    }
}

