/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISHA;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.prAccessor;

public final class ProgressPasswordUser
extends ProgressPrincipal {
    private static final String SHA_CLASS = "progress.message.crypto.SHA";
    private static volatile Class m_shaClass = null;
    private String m_username;
    private String m_routingNodeName;
    private byte[] m_passwordHash;
    private short m_logOperation;
    private Vector m_groups;
    private String m_clearPassword;
    private ArrayList m_externalGroups;
    public static final short DB_CTOR = 0;
    public static final short OTHER_CTOR = 1;
    public static final short GROUP_ADD = 2;
    public static final short GROUP_DELETE = 3;

    public ProgressPasswordUser(String username, String clear_password) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ProgressPasswordUser" : null);
        this.m_username = username;
        this.m_passwordHash = this.doSHA(clear_password);
        this.initData((short)1);
    }

    public ProgressPasswordUser(String username, String clear_password, boolean delayHash) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ProgressPasswordUser" : null);
        this.m_username = username;
        this.m_logOperation = 1;
        this.m_groups = new Vector();
        this.m_routingNodeName = null;
        if (delayHash) {
            this.m_clearPassword = clear_password;
        } else {
            this.m_passwordHash = this.doSHA(clear_password);
        }
        this.m_isInternalUser = true;
    }

    public ProgressPasswordUser(String username, byte[] password_hash) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ProgressPasswordUser" : null);
        this.m_username = username;
        this.m_passwordHash = password_hash;
        this.initData((short)0);
    }

    private void initData(short DB_CTOR) {
        this.m_logOperation = DB_CTOR;
        this.m_groups = new Vector();
        this.m_routingNodeName = null;
        this.m_isInternalUser = true;
    }

    @Override
    public boolean equals(Object another) {
        if (this.DEBUG) {
            this.debug("in equals(...)");
        }
        return another instanceof ProgressPasswordUser && this.m_username.equals(((ProgressPasswordUser)another).getName());
    }

    @Override
    public String toString() {
        if (this.DEBUG) {
            this.debug("in toString()");
        }
        String mf77 = prAccessor.getString("STR188");
        Object[] ob77 = new Object[]{this.m_username, Integer.toString(this.m_logOperation)};
        return MessageFormat.format(mf77, ob77);
    }

    @Override
    public String getName() {
        if (this.DEBUG) {
            this.debug("in getName()");
        }
        return this.m_username;
    }

    public String getRoutingNodeName() {
        return this.m_routingNodeName;
    }

    public void setRoutingNodeName(String routingNodeName) {
        this.m_routingNodeName = routingNodeName;
    }

    public final void setExternalGroups(ArrayList externalGroups) {
        this.m_externalGroups = externalGroups;
    }

    public final ArrayList getExternalGroups() {
        return this.m_externalGroups;
    }

    @Override
    public int hashCode() {
        if (this.DEBUG) {
            this.debug("in hashCode()");
        }
        return this.m_username.hashCode();
    }

    public byte[] getTestPattern() {
        if (this.m_passwordHash == null && this.m_clearPassword != null) {
            this.m_passwordHash = this.doSHA(this.m_clearPassword);
        }
        return this.m_passwordHash;
    }

    public void setPasswordHash(byte[] hash) {
        this.m_passwordHash = hash;
    }

    public short getlogOperation() {
        return this.m_logOperation;
    }

    public void setlogOperation(short state_indicator) {
        this.m_logOperation = state_indicator;
    }

    public boolean authenticate(String plainTextPassword) {
        byte[] hash = this.doSHA(plainTextPassword);
        if (hash.length != this.m_passwordHash.length) {
            return false;
        }
        for (int i = 0; i < this.m_passwordHash.length; ++i) {
            if (hash[i] == this.m_passwordHash[i]) continue;
            return false;
        }
        return true;
    }

    public Vector getGroups() {
        return this.m_groups;
    }

    public void addGroup(ProgressGroup g) {
        this.m_groups.addElement(g);
    }

    public void removeGroup(ProgressGroup g) {
        this.m_groups.removeElement(g);
    }

    private byte[] doSHA(String in) {
        byte[] hash = null;
        try {
            if (m_shaClass == null) {
                m_shaClass = Class.forName(SHA_CLASS);
            }
            ISHA sha = (ISHA)m_shaClass.newInstance();
            sha.add(in);
            hash = sha.digest();
        }
        catch (Exception e) {
            String mf165 = prAccessor.getString("STR189");
            Object[] ob165 = new Object[]{e.toString()};
            throw new EAssertFailure(MessageFormat.format(mf165, ob165));
        }
        return hash;
    }

    public static byte[] doSHA(byte[] in) {
        byte[] hash = null;
        try {
            if (m_shaClass == null) {
                m_shaClass = Class.forName(SHA_CLASS);
            }
            ISHA sha = (ISHA)m_shaClass.newInstance();
            sha.add(in);
            hash = sha.digest();
        }
        catch (Exception e) {
            String mf165 = prAccessor.getString("STR189");
            Object[] ob165 = new Object[]{e.toString()};
            throw new EAssertFailure(MessageFormat.format(mf165, ob165));
        }
        return hash;
    }
}

