/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Accept;
import com.sonicsw.ws.rm.protocol.AckRequested;
import com.sonicsw.ws.rm.protocol.AcksTo;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.CreateSequence;
import com.sonicsw.ws.rm.protocol.CreateSequenceResponse;
import com.sonicsw.ws.rm.protocol.Expires;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.LastMessage;
import com.sonicsw.ws.rm.protocol.MessageNumber;
import com.sonicsw.ws.rm.protocol.Offer;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.Sequence;
import com.sonicsw.ws.rm.protocol.SequenceAcknowledgement;
import com.sonicsw.ws.rm.protocol.TerminateSequence;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.From;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.ReplyTo;
import org.apache.axis.message.addressing.To;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.URI;
import progress.message.zclient.SessionConfig;

public class ElementCreator {
    private static final String WSA_UNSPECIFIED_ACTOR_URI = null;
    private static final boolean WSA_DONT_PROCESS = false;
    private static final boolean WSA_DONT_REMOVE = false;
    private static final boolean WSA_MUST_UNDERSTAND = true;
    private static final List WSA_EMPTY_REFERENCE_PROPERTIES = null;
    private static final String UUID_PREFIX = "uuid:";
    private static volatile String NODE_SUFFIX = null;
    private static UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public static org.apache.axis.message.SOAPEnvelope createCreateSequenceResponseEnvelope(String uuid, AddressingHeaders addressingHeaders, SOAPConstants constants, Constants RMConstants) throws Exception {
        CreateSequenceResponse response = new CreateSequenceResponse(RMConstants);
        Identifier id = new Identifier(RMConstants);
        id.setIdentifier(uuid);
        response.setIdentifier(id);
        return ElementCreator.createCreateSequenceResponseEnvelope(response, addressingHeaders, constants, RMConstants);
    }

    public static org.apache.axis.message.SOAPEnvelope createCreateSequenceResponseEnvelope(EndpointReference acksTo, long expires, String uuid, AddressingHeaders addressingHeaders, SOAPConstants constants, Constants RMConstants) throws Exception {
        CreateSequenceResponse response = new CreateSequenceResponse(RMConstants);
        Identifier id = new Identifier(RMConstants);
        id.setIdentifier(uuid);
        response.setIdentifier(id);
        if (expires != -1L) {
            Expires outexp = new Expires(RMConstants);
            outexp.setExpires(expires);
            response.setExpires(outexp);
        }
        if (acksTo != null) {
            AcksTo a2 = new AcksTo(RMConstants);
            a2.setAddress(acksTo);
            Accept a = new Accept(RMConstants);
            a.setAcksTo(a2);
            response.setAccept(a);
        }
        return ElementCreator.createCreateSequenceResponseEnvelope(response, addressingHeaders, constants, RMConstants);
    }

    public static org.apache.axis.message.SOAPEnvelope createCreateSequenceResponseEnvelope(CreateSequenceResponse response, AddressingHeaders addressingHeaders, SOAPConstants constants, Constants RMConstants) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(RMConstants.getCreateSequenceResponseAction(), null, constants, RMConstants);
        ElementCreator.reverseAddressesForResponseEnvelope(envelope, addressingHeaders);
        response.toSOAPEnvelope(envelope);
        return envelope;
    }

    public static org.apache.axis.message.SOAPEnvelope createTerminateSequenceResponseEnvelope(AddressingHeaders addressingHeaders, SOAPConstants constants, Constants RMConstants) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(null, null, constants, RMConstants);
        ElementCreator.reverseAddressesForResponseEnvelope(envelope, addressingHeaders);
        return envelope;
    }

    public static void reverseAddresses(org.apache.axis.message.SOAPEnvelope responseEnvelope, AddressingHeaders addressingHeaders, boolean considerFaultTo) throws Exception {
        AddressingHeaders outGoingAddressingHeaders = new AddressingHeaders((SOAPEnvelope)responseEnvelope, WSA_UNSPECIFIED_ACTOR_URI, false, false, true, WSA_EMPTY_REFERENCE_PROPERTIES);
        To incomingTo = addressingHeaders.getTo();
        URI outgoingFromAddressURI = new URI(incomingTo.toString());
        Address outgoingFromAddress = new Address(outgoingFromAddressURI);
        From outgoingFrom = new From((URI)outgoingFromAddress);
        outGoingAddressingHeaders.setFrom((EndpointReference)outgoingFrom);
        MessageID incomingMessageId = addressingHeaders.getMessageID();
        if (incomingMessageId != null) {
            outGoingAddressingHeaders.addRelatesTo(incomingMessageId.toString(), new QName(AddressingUtils.getAddressingNamespaceURI(), "RelatesTo"));
        }
        EndpointReference incomingFaultTo = addressingHeaders.getFaultTo();
        ReplyTo incomingReplyTo = (ReplyTo)addressingHeaders.getReplyTo();
        From incomingFrom = (From)addressingHeaders.getFrom();
        Object incomingEPR = considerFaultTo && incomingFaultTo != null ? incomingFaultTo : (incomingReplyTo != null ? incomingReplyTo : (incomingFrom != null ? incomingFrom : new EndpointReference(new Address(AddressingUtils.getAnonymousRoleURI()))));
        To to = new To(new URI(incomingEPR.getAddress().toString()));
        outGoingAddressingHeaders.setReferenceProperties(incomingEPR.getProperties());
        outGoingAddressingHeaders.setReferenceParameters(incomingEPR.getParameters());
        outGoingAddressingHeaders.setTo(to);
        outGoingAddressingHeaders.toEnvelope((SOAPEnvelope)responseEnvelope, null);
    }

    public static void reverseAddressesForFaultEnvelope(org.apache.axis.message.SOAPEnvelope responseEnvelope, AddressingHeaders addressingHeaders) throws Exception {
        ElementCreator.reverseAddresses(responseEnvelope, addressingHeaders, true);
    }

    public static void reverseAddressesForResponseEnvelope(org.apache.axis.message.SOAPEnvelope responseEnvelope, AddressingHeaders addressingHeaders) throws Exception {
        ElementCreator.reverseAddresses(responseEnvelope, addressingHeaders, false);
    }

    private static final String getNodeSuffix() {
        if (NODE_SUFFIX != null) {
            return NODE_SUFFIX;
        }
        if (!SessionConfig.IN_BROKER) {
            NODE_SUFFIX = "";
            return NODE_SUFFIX;
        }
        try {
            Class<?> c = Class.forName("com.sonicsw.ws.rm.common.RMManager");
            Class[] argTypes = new Class[]{};
            Method method = c.getMethod("getBrokerIDAsString", argTypes);
            Object[] argvalues = new Object[]{};
            String bscode = (String)method.invoke(null, argvalues);
            NODE_SUFFIX = "-" + bscode;
        }
        catch (Exception cnfe) {
            NODE_SUFFIX = "";
        }
        return NODE_SUFFIX;
    }

    public static String generateUUID() {
        return UUID_PREFIX + uuidGen.nextUUID() + ElementCreator.getNodeSuffix();
    }

    public static org.apache.axis.message.SOAPEnvelope createCreateSequence(String destinationURL, CreateSequence cs, SOAPConstants constants, Constants RMConstants) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelopeToSend = ElementCreator.createSimpleEnvelope(RMConstants.getCreateSequenceAction(), ElementCreator.generateUUID(), constants, RMConstants);
        To toForCreateSequence = new To(destinationURL);
        SOAPHeaderElement hr = toForCreateSequence.toSOAPHeaderElement((SOAPEnvelope)envelopeToSend, WSA_UNSPECIFIED_ACTOR_URI);
        hr.setMustUnderstand(false);
        cs.toSOAPEnvelope(envelopeToSend);
        return envelopeToSend;
    }

    public static org.apache.axis.message.SOAPEnvelope createCreateSequence(String destinationURL, SOAPConstants constants, Constants RMConstants) throws Exception {
        return ElementCreator.createCreateSequence(destinationURL, new CreateSequence(RMConstants), constants, RMConstants);
    }

    public static org.apache.axis.message.SOAPEnvelope createCreateSequence(String destinationURL, long expires, long offerExpires, String offerIdentifier, SOAPConstants constants, Constants RMConstants) throws Exception {
        CreateSequence cs = new CreateSequence(RMConstants);
        if (offerIdentifier != null) {
            Identifier id = new Identifier(RMConstants);
            id.setIdentifier(offerIdentifier);
            Offer offer = new Offer(RMConstants);
            offer.setIdentifier(id);
            if (offerExpires != -1L) {
                Expires exp = new Expires(RMConstants);
                exp.setExpires(offerExpires);
                offer.setExpires(exp);
            }
            cs.setOffer(offer);
        }
        if (expires != -1L) {
            Expires outexp = new Expires(RMConstants);
            outexp.setExpires(expires);
            cs.setExpires(outexp);
        }
        return ElementCreator.createCreateSequence(destinationURL, cs, constants, RMConstants);
    }

    public static org.apache.axis.message.SOAPEnvelope createTerminateSequence(String uuid, EndpointReference destinationURL, SOAPConstants constants, Constants RMConstants) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelopeToSend = ElementCreator.createSimpleEnvelope(RMConstants.getTerminateSequenceAction(), ElementCreator.generateUUID(), constants, RMConstants);
        Address anonymousAddress = new Address(AddressingUtils.getAnonymousRoleURI());
        To toForTerminateSequence = new To((URI)destinationURL.getAddress());
        SOAPHeaderElement hr = toForTerminateSequence.toSOAPHeaderElement((SOAPEnvelope)envelopeToSend, WSA_UNSPECIFIED_ACTOR_URI);
        hr.setMustUnderstand(false);
        TerminateSequence terminateSequence = new TerminateSequence(RMConstants);
        Identifier ID = new Identifier(RMConstants);
        ID.setIdentifier(uuid);
        terminateSequence.setIdentifier(ID);
        terminateSequence.toSOAPEnvelope(envelopeToSend);
        return envelopeToSend;
    }

    public static org.apache.axis.message.SOAPEnvelope createSimpleEnvelope(String action, String mid, SOAPConstants constants, Constants RMConstants) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelopToSend = new org.apache.axis.message.SOAPEnvelope(constants);
        ElementCreator.addNamespaceDeclarations(envelopToSend, RMConstants);
        if (action != null) {
            URI actionURI = new URI(action);
            Action tempAction = new Action(actionURI);
            tempAction.toSOAPHeaderElement((SOAPEnvelope)envelopToSend, WSA_UNSPECIFIED_ACTOR_URI);
        }
        if (mid != null) {
            MessageID messageId = new MessageID(new URI(mid));
            messageId.toSOAPHeaderElement((SOAPEnvelope)envelopToSend, WSA_UNSPECIFIED_ACTOR_URI);
        }
        return envelopToSend;
    }

    public static void addNamespaceDeclarations(org.apache.axis.message.SOAPEnvelope envelopToSend, Constants RMConstants) throws Exception {
        envelopToSend.addNamespaceDeclaration("wsrm", RMConstants.getNSURI());
    }

    public static org.apache.axis.message.SOAPEnvelope createAcknowledgementEnvelope(Constants RMConstants, SOAPConstants constants, SequenceAcknowledgement seqAck, From from, To to) throws Exception {
        org.apache.axis.message.SOAPEnvelope envelope = ElementCreator.createSimpleEnvelope(RMConstants.getSequenceAcknowledgementAction(), ElementCreator.generateUUID(), constants, RMConstants);
        AddressingHeaders outGoingAddressingHeaders = new AddressingHeaders((SOAPEnvelope)envelope, WSA_UNSPECIFIED_ACTOR_URI, false, false, true, WSA_EMPTY_REFERENCE_PROPERTIES);
        outGoingAddressingHeaders.setFrom((EndpointReference)from);
        outGoingAddressingHeaders.setTo(to);
        outGoingAddressingHeaders.setAction(RMConstants.getSequenceAcknowledgementAction());
        outGoingAddressingHeaders.toEnvelope((SOAPEnvelope)envelope, null);
        seqAck.toSOAPEnvelope(envelope);
        return envelope;
    }

    public static void insertAckRequestedElement(org.apache.axis.message.SOAPEnvelope se, String si, Constants RMConstants) throws Exception {
        Identifier id = new Identifier(RMConstants);
        id.setIdentifier(si);
        ElementCreator.insertAckRequestedElement(se, id, RMConstants);
    }

    public static void insertAckRequestedElement(org.apache.axis.message.SOAPEnvelope se, Identifier si, Constants RMConstants) throws Exception {
        ReliableHeaders rmAckReqHeader = new ReliableHeaders();
        AckRequested ackReq = new AckRequested(RMConstants);
        ackReq.setIdentifier(si);
        rmAckReqHeader.addAckRequest(ackReq);
        rmAckReqHeader.toSOAPEnvelope(se);
    }

    public static void insertSequenceElement(org.apache.axis.message.SOAPEnvelope se, String si, long nr, boolean lm, Constants RMConstants) {
        Identifier id = new Identifier(RMConstants);
        id.setIdentifier(si);
        MessageNumber mr = new MessageNumber(RMConstants);
        mr.setMessageNumber(nr);
        if (lm) {
            LastMessage lastMessage = new LastMessage(RMConstants);
            ElementCreator.insertSequenceElement(se, id, mr, lastMessage, RMConstants);
        } else {
            ElementCreator.insertSequenceElement(se, id, mr, null, RMConstants);
        }
    }

    public static void insertSequenceElement(org.apache.axis.message.SOAPEnvelope se, Identifier si, MessageNumber nr, LastMessage lm, Constants RMConstants) {
        try {
            ReliableHeaders hdrs = new ReliableHeaders();
            Sequence seq = new Sequence(RMConstants);
            seq.setIdentifier(si);
            seq.setMessageNumber(nr);
            if (lm != null) {
                seq.setLastMessage(lm);
            }
            hdrs.setSequence(seq);
            hdrs.toSOAPEnvelope(se);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void insertAddressingHeader(org.apache.axis.message.SOAPEnvelope soapEnv, From from, To to, ReplyTo replyTo) throws Exception {
        if (soapEnv != null) {
            if (from != null) {
                from.toSOAPHeaderElement((SOAPEnvelope)soapEnv, WSA_UNSPECIFIED_ACTOR_URI);
            }
            if (to != null) {
                SOAPHeaderElement hr = to.toSOAPHeaderElement((SOAPEnvelope)soapEnv, WSA_UNSPECIFIED_ACTOR_URI);
                hr.setMustUnderstand(false);
            }
            if (replyTo != null) {
                replyTo.toSOAPHeaderElement((SOAPEnvelope)soapEnv, WSA_UNSPECIFIED_ACTOR_URI);
            }
        }
    }
}

