/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import javax.jms.JMSException;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.util.Queue;

public class UnacknowledgedMessagesQueue
extends Queue {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message msg) {
        try {
            msg.setJMSRedelivered(true, true);
        }
        catch (JMSException e) {
            throw new InternalError();
        }
        UnacknowledgedMessagesQueue unacknowledgedMessagesQueue = this;
        synchronized (unacknowledgedMessagesQueue) {
            this.enqueue(msg);
        }
    }

    public synchronized boolean removeMessage(Message msg) {
        Message aMsg = null;
        if (!this.contains(msg)) {
            return false;
        }
        while (!msg.equals(aMsg = (Message)this.dequeue()) || aMsg.getConsumer() != msg.getConsumer()) {
        }
        return true;
    }

    public synchronized boolean removeMessage(Message msg, Vector msgs) {
        if (!this.contains(msg)) {
            return false;
        }
        Message aMsg = null;
        while (!msg.equals(aMsg = (Message)this.dequeue()) || aMsg.getConsumer() != msg.getConsumer()) {
            msgs.addElement(aMsg);
        }
        msgs.addElement(msg);
        return true;
    }

    public synchronized boolean removeSingleMessage(Message msg) {
        boolean found = false;
        for (Message next : this.removeAllMessages()) {
            if (!found && next.equals(msg) && next.getConsumer() == msg.getConsumer()) {
                found = true;
                continue;
            }
            this.enqueue(next);
        }
        return found;
    }

    public synchronized Message[] removeAllMessages() {
        int length = this.size();
        Message[] msgs = new Message[length];
        for (int i = 0; i < length; ++i) {
            msgs[i] = (Message)this.dequeue();
        }
        return msgs;
    }

    public synchronized void removeAllMessages(LinkedList ccMsgs, LinkedList nonCCMsgs) {
        int length = this.size();
        boolean ccCount = false;
        boolean lrCount = false;
        for (int i = 0; i < length; ++i) {
            Message m = (Message)this.dequeue();
            if (m.getConnectionConsumer() != null) {
                ccMsgs.add(m);
                continue;
            }
            nonCCMsgs.add(m);
        }
    }

    synchronized boolean removeAllMessages(Collection messages) {
        Message[] msgs = this.removeAllMessages();
        if (msgs.length == 0) {
            return false;
        }
        for (int i = 0; i < msgs.length; ++i) {
            messages.add(msgs[i]);
        }
        return true;
    }

    boolean contains(Message msg) {
        int objLoc = this.m_head;
        while (objLoc < this.m_array.length && objLoc != this.m_tail) {
            if (msg.equals(this.m_array[objLoc]) && msg.getConsumer() == ((Message)this.m_array[objLoc]).getConsumer()) {
                return true;
            }
            objLoc = this.resetData(objLoc);
        }
        return false;
    }

    boolean contains(MessageConsumer consumer) {
        int objLoc = this.m_head;
        while (objLoc < this.m_array.length && objLoc != this.m_tail) {
            if (consumer == ((Message)this.m_array[objLoc]).getConsumer()) {
                return true;
            }
            objLoc = this.resetData(objLoc);
        }
        return false;
    }

    private int resetData(int objLocParam) {
        int objLoc = objLocParam;
        if (++objLoc == this.m_array.length) {
            objLoc = 0;
        }
        return objLoc;
    }
}

