/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.zclient.ClientSecurityContext;

public class ConnectionSyncData {
    private byte m_flags;
    private int m_state;
    private long m_clientId;
    private int m_channel;
    private boolean m_deliveryStarted;
    private ClientSecurityContext m_csc;
    private short m_ackMode;

    public ConnectionSyncData() {
    }

    public ConnectionSyncData(byte flags, int channel, long clientId, int state, boolean deliveryStarted, ClientSecurityContext csc, short ackMode) {
        this.m_flags = flags;
        this.m_channel = channel;
        this.m_clientId = clientId;
        this.m_state = state;
        this.m_deliveryStarted = deliveryStarted;
        this.m_csc = csc;
        this.m_ackMode = ackMode;
    }

    public byte getFlags() {
        return this.m_flags;
    }

    public int getChannel() {
        return this.m_channel;
    }

    public long getClientId() {
        return this.m_clientId;
    }

    public ClientSecurityContext getClientSecurityContext() {
        return this.m_csc;
    }

    public int getState() {
        return this.m_state;
    }

    public boolean getDeliveryStarted() {
        return this.m_deliveryStarted;
    }

    public short getAckMode() {
        return this.m_ackMode;
    }

    public void setFlags(byte flags) {
        this.m_flags = flags;
    }

    public void setChannel(int channel) {
        this.m_channel = channel;
    }

    public void setClientId(long clientId) {
        this.m_clientId = clientId;
    }

    public void setClientSecurityContext(ClientSecurityContext csc) {
        this.m_csc = csc;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    public void setDeliveryStarted(boolean deliveryStarted) {
        this.m_deliveryStarted = deliveryStarted;
    }

    public void setAckMode(short ackMode) {
        this.m_ackMode = ackMode;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeByte(this.m_flags);
        out.writeLong(this.m_clientId);
        out.writeInt(this.m_channel);
        out.writeInt(this.m_state);
        out.writeBoolean(this.m_deliveryStarted);
        out.writeShort(this.m_ackMode);
        if (this.m_csc != null) {
            out.writeBoolean(true);
            this.m_csc.writeToStream(out, (short)-1);
        } else {
            out.writeBoolean(false);
        }
    }

    public static ConnectionSyncData deserialize(DataInput in) throws IOException {
        ConnectionSyncData req = new ConnectionSyncData();
        req.m_flags = in.readByte();
        req.m_clientId = in.readLong();
        req.m_channel = in.readInt();
        req.m_state = in.readInt();
        req.m_deliveryStarted = in.readBoolean();
        req.m_ackMode = in.readShort();
        if (in.readBoolean()) {
            req.m_csc = ClientSecurityContext.getClientSecurityContext(in, (short)-1);
        }
        return req;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Channel=" + this.m_channel);
        sb.append(",ClientId=" + this.m_clientId);
        sb.append(",Flags=" + this.m_flags);
        sb.append(",State=" + this.m_state);
        sb.append(",deliveryStarted=" + this.m_deliveryStarted);
        sb.append(",ackmode=" + this.m_ackMode);
        return sb.toString();
    }
}

