/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.JMSException;
import progress.message.client.EEnvelopeIsNotRequest;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ENonrepudiationFailed;
import progress.message.client.EPrivacyCompromised;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.zclient.ENoTrackingNum;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;

class NativeMessage
extends Message {
    static final int AF_NONE = 0;
    static final int AF_STRING = 1;
    static final int AF_FIXED = 2;
    static final int AF_VAR = 3;

    NativeMessage() {
        super((short)0);
    }

    NativeMessage(Envelope envelope) {
        super(envelope);
        this.m_zenvelope.setBodyType((short)0);
    }

    public void setSubject(ISubject subject) {
        this.m_zenvelope.getMessage().setSubject(subject);
    }

    public ISubject getSubject(ISubject subject) {
        return this.m_zenvelope.getSubject();
    }

    long getGuarTracking() {
        return this.m_zenvelope.getGuarTracking();
    }

    boolean isRequest() {
        return this.m_zenvelope.isRequest();
    }

    boolean isReply() {
        return this.m_zenvelope.isReply();
    }

    public ISubject getReplySubject() {
        return this.m_zenvelope.getReplySubject();
    }

    int getReplyTracking() {
        try {
            return this.m_zenvelope.getReplyTracking();
        }
        catch (ENoTrackingNum entn) {
            return -1;
        }
    }

    byte getReplyPriority() {
        return this.m_zenvelope.getLabel().getReplyPriority();
    }

    void setReplyPriority(byte priority) {
        this.m_zenvelope.getLabel().setReplyPriority(priority);
    }

    void setReply(Message req) throws JMSException {
        try {
            this.m_zenvelope.setReply(req.m_zenvelope);
        }
        catch (EEnvelopeIsNotRequest eeinr) {
            throw JMSExceptionUtil.createJMSException(eeinr);
        }
    }

    int getRouteLimit() {
        return this.m_zenvelope.getLabel().getRouteLimit();
    }

    void setRouteLimit(int route_limit) {
        this.m_zenvelope.getLabel().setRouteLimit(route_limit);
    }

    byte[] getBody() throws JMSException {
        try {
            return this.m_zenvelope.getMessage().getBody();
        }
        catch (EPrivacyCompromised epc) {
            throw JMSExceptionUtil.createJMSException(epc);
        }
        catch (ENonrepudiationFailed enf) {
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EIntegrityCompromised eic) {
            throw JMSExceptionUtil.createJMSException(eic);
        }
        catch (EGeneralException ege) {
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }

    void setBody(byte[] body) {
        this.m_zenvelope.getMessage().setBody(body);
    }
}

