/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.client.tunnel;

import com.sonicsw.net.http.HttpHelper;
import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.http.client.tunnel.SafeQueue;
import progress.message.net.http.client.tunnel.prAccessor;
import progress.message.util.URLUtil;
import progress.message.zclient.SessionConfig;
import sun.misc.BASE64Encoder;

public class HttpClientSocket
extends Socket
implements Runnable {
    public static final String NEW_CONNECTION_URI = "/SC/New";
    public static final String EXISTIN_CONNECTION_URI = "/SC/Exist";
    public static final String CLOSE_CONNECTION_URI = "/SC/Close";
    public static final String REQUEST_DATA_URI = "/SC/ReqData";
    public static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HTTP_HEADER_CONNECTION = "Connection";
    public static final String SONIC_HEADER_CONNECTION_ID = "ConnectionId";
    public static final String SONIC_HEADER_SEQUENCE_NUMBER = "SequenceNumber";
    public static final String SONIC_HEADER_PING_INTERVAL = "SonicPingInterval";
    private int HTTP_RETRY_ATTEMPTS = 3;
    private int HTTP_RETRY_SLEEP_TIME = 1000;
    private int HTTP_REQUEST_SIZE = 65536;
    private boolean HTTP_ALLOW_INTERACTION = true;
    private boolean HTTP_MAP_HOST_TO_IP = true;
    private boolean HTTP_DEBUG_READ = false;
    private boolean HTTP_DEBUG_SEND = false;
    private boolean HTTP_DEBUG_CONNECT = false;
    private boolean HTTP_DEBUG_THREAD = false;
    private boolean HTTP_DEBUG_CLOSE = false;
    private boolean HTTP_DEBUG_FAILURE = false;
    private Object m_props = null;
    private URL m_url = null;
    private URL m_pullURL = null;
    private URL m_pushURL = null;
    private URL m_closeURL = null;
    private HttpClientSocketInputStream in = null;
    private OutputStream out = null;
    private int connectionId = -1;
    private int idleTimeout = -1;
    private Thread requester = null;
    private volatile boolean socketClosing = false;
    public static final String PING_REQUEST_HDR = "SONIC_CLIENT_PING";
    private Thread pinger = null;
    private static Object connectSync = new Object();
    private long lastReqDataResponse = 0L;
    private Object responseTimeSync = new Object();
    private Hashtable m_DefaultHeaders = null;
    private Hashtable m_PingHeaders = null;
    private Hashtable m_PushHeaders = null;
    private Hashtable m_PullHeaders = null;
    protected IHttpProxyConfig m_httpProxyConfig;
    private String m_httpHost;
    private int m_httpPort;
    private String m_closedBy = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastResponseTime(long t) {
        Object object = this.responseTimeSync;
        synchronized (object) {
            this.lastReqDataResponse = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastResponseTime() {
        Object object = this.responseTimeSync;
        synchronized (object) {
            return this.lastReqDataResponse;
        }
    }

    protected void init() {
    }

    public HttpClientSocket() {
        this.callInit();
    }

    private void callInit() {
        this.init();
    }

    @Override
    public String toString() {
        return "HTTP connection Id = " + this.connectionId + ", socket closed ? " + this.socketClosing + " by " + this.m_closedBy;
    }

    public HttpClientSocket(String host, int port, Object props, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        this.initHttpClientSocket(host, port, props, pConfig);
    }

    private void initHttpClientSocket(String host, int port, Object props, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        String mapHostNameToIP;
        String allowUserInteraction;
        String debug_failure;
        String debug_thread;
        String debug_send;
        String debug_connect;
        String debug_read;
        String send_attempts;
        this.init();
        this.m_props = props;
        String req_size = this.getProperty("HTTP_REQUEST_SIZE");
        if (req_size != null) {
            this.HTTP_REQUEST_SIZE = Integer.parseInt(req_size);
        }
        if ((send_attempts = this.getProperty("HTTP_RETRY_ATTEMPTS")) != null) {
            this.HTTP_RETRY_ATTEMPTS = Integer.parseInt(send_attempts);
        }
        if ((debug_read = this.getProperty("HTTP_DEBUG_READ")) != null) {
            this.HTTP_DEBUG_READ = Boolean.valueOf(debug_read);
        }
        if ((debug_connect = this.getProperty("HTTP_DEBUG_CONNECT")) != null) {
            this.HTTP_DEBUG_CONNECT = Boolean.valueOf(debug_connect);
        }
        if ((debug_send = this.getProperty("HTTP_DEBUG_SEND")) != null) {
            this.HTTP_DEBUG_SEND = Boolean.valueOf(debug_send);
        }
        if ((debug_thread = this.getProperty("HTTP_DEBUG_THREAD")) != null) {
            this.HTTP_DEBUG_THREAD = Boolean.valueOf(debug_thread);
        }
        if ((debug_failure = this.getProperty("HTTP_DEBUG_FAILURE")) != null) {
            this.HTTP_DEBUG_FAILURE = Boolean.valueOf(debug_failure);
        }
        if ((allowUserInteraction = this.getProperty("HTTP_ALLOW_INTERACTION")) != null) {
            this.HTTP_ALLOW_INTERACTION = Boolean.valueOf(allowUserInteraction);
        }
        if ((mapHostNameToIP = this.getProperty("HTTP_MAP_HOST_TO_IP")) != null) {
            this.HTTP_MAP_HOST_TO_IP = Boolean.valueOf(mapHostNameToIP);
        }
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put(HTTP_HEADER_CONNECTION, this.getProperty("HTTP_CONNECTION_HEADER", "keep-alive"));
        headers.put("Content-type", this.getProperty("HTTP_CONTENT_TYPE_HEADER", "application/octet-stream"));
        int custom_hdrs = Integer.parseInt(this.getProperty("HTTP_CUSTOM_HEADER_COUNT", "0"));
        for (int i = 0; i < custom_hdrs; ++i) {
            String hdr_name = this.getProperty("HTTP_CUSTOM_HEADER_" + (i + 1));
            String hdr_value = this.getProperty("HTTP_CUSTOM_HEADER_VALUE_" + (i + 1));
            if (hdr_name == null || hdr_value == null) continue;
            headers.put(hdr_name, hdr_value);
        }
        if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_SEND || this.HTTP_DEBUG_CONNECT) {
            System.out.println("HTTP_DEBUG: Creating HttpClientSocket  Protocol is " + this.getProtocol());
        }
        this.m_httpProxyConfig = pConfig;
        if (this.HTTP_MAP_HOST_TO_IP) {
            String addr = ProgressInetAddress.getByName(host).getHostAddress(false);
            if (this.HTTP_DEBUG_CONNECT) {
                System.out.println("HTTP_DEBUG: Creating URL with host " + host + " mapped to " + addr);
            }
            this.populateUrlHostPort(addr, port);
        } else {
            if (this.HTTP_DEBUG_CONNECT) {
                System.out.println("HTTP_DEBUG: Creating URL with host " + host);
            }
            this.populateUrlHostPort(host, port);
        }
        this.m_DefaultHeaders = (Hashtable)headers.clone();
        this.connect(this.m_url, headers);
    }

    private void populateUrlHostPort(String host, int port) throws MalformedURLException {
        this.m_url = this.newURL(this.getProtocol(), host, port, NEW_CONNECTION_URI);
        this.m_url = this.processForProxy(this.m_url, this.getProtocol(), host, port, NEW_CONNECTION_URI);
        this.m_httpHost = host;
        this.m_httpPort = port;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return ProgressInetAddress.getByName(this.m_url.getHost()).getDelegateInetAddress();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    @Override
    public int getPort() {
        if (this.m_url == null) {
            return -1;
        }
        return this.m_url.getPort();
    }

    private void connect(URL url, Hashtable headers) throws IOException {
        if (this.m_url == null) {
            throw new IllegalStateException(prAccessor.getString("STR004"));
        }
        URLConnection connection = null;
        int retryCount = 0;
        headers.put(HTTP_HEADER_CONTENT_LENGTH, "1");
        while (true) {
            ++retryCount;
            try {
                connection = this.doHTTPConnection(this.m_url, headers);
                if (this.HTTP_DEBUG_CONNECT) {
                    System.out.println("HTTP_DEBUG_CONNECT: In connect(), connection is of type: " + connection.getClass());
                }
                this.forcePostMode(connection);
                InputStream in = connection.getInputStream();
                int responseCode = -1;
                responseCode = this.getResponseCode(connection);
                if (responseCode != 200) {
                    throw new IOException(prAccessor.getString("STR001"));
                }
                if (this.HTTP_DEBUG_CONNECT) {
                    int j = 0;
                    while (true) {
                        String header = connection.getHeaderField(j);
                        String key = connection.getHeaderFieldKey(j);
                        if (header == null && key == null) break;
                        System.out.println("HTTP_DEBUG_CONNECT: response headers were: " + key + ":" + header);
                        ++j;
                    }
                }
                this.connectionId = this.getConnectionId(connection);
                this.idleTimeout = this.getConnectionIdleTimeout(connection);
                this.doneInput(in);
                this.markConnectionAvailable(connection);
                if (this.HTTP_DEBUG_CONNECT) {
                    System.out.println("HTTP_DEBUG_CONNECT: In connect(), connection id = " + this.connectionId);
                }
                if (!this.HTTP_DEBUG_THREAD) break;
                String agent = connection.getHeaderField("AgentId");
                System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " received CONNECT response from agent " + agent + ", connection id = " + this.connectionId);
            }
            catch (IOException ioe) {
                this.disconnect(connection);
                if (retryCount != this.HTTP_RETRY_ATTEMPTS) continue;
                if (this.HTTP_DEBUG_FAILURE) {
                    System.out.println("HTTP_DEBUG: " + Thread.currentThread() + " exiting after " + retryCount + " attempts to connect to " + url + ".  Reason...");
                    ioe.printStackTrace();
                }
                if (this.HTTP_DEBUG_THREAD || this.HTTP_DEBUG_CONNECT) {
                    System.out.println("HTTP_DEBUG: " + Thread.currentThread() + " exiting ... failed to connect to the broker: " + ioe);
                    ioe.printStackTrace();
                }
                throw ioe;
                if (retryCount < this.HTTP_RETRY_ATTEMPTS) continue;
            }
            break;
        }
        this.m_pullURL = this.newURL(this.m_url, REQUEST_DATA_URI);
        this.m_pullURL = this.processForProxy(this.m_pullURL, this.getProtocol(), this.m_httpHost, this.m_httpPort, REQUEST_DATA_URI);
        this.m_pushURL = this.newURL(this.m_url, EXISTIN_CONNECTION_URI);
        this.m_pushURL = this.processForProxy(this.m_pushURL, this.getProtocol(), this.m_httpHost, this.m_httpPort, EXISTIN_CONNECTION_URI);
        this.m_closeURL = this.newURL(this.m_url, CLOSE_CONNECTION_URI);
        this.m_closeURL = this.processForProxy(this.m_closeURL, this.getProtocol(), this.m_httpHost, this.m_httpPort, CLOSE_CONNECTION_URI);
        this.out = new HttpSocketOutputStream(this.connectionId);
        this.in = new HttpClientSocketInputStream();
        this.requester = new Thread(this);
        this.requester.setName("HttpClientSocket$Requester" + this.connectionId);
        this.requester.setDaemon(true);
        this.requester.start();
        this.pinger = this.startPingThread();
        this.pinger.setName("HttpClientSocket$Pinger" + this.connectionId);
    }

    boolean isAlive() {
        return this.requester.isAlive();
    }

    @Override
    public void run() {
        int sequenceNumber = 0;
        int messageId = 0;
        URLConnection connection = null;
        if (this.HTTP_DEBUG_READ) {
            System.out.println("HTTP_DEBUG_READ: HttpClientSocket requester thread starting");
        }
        if (this.m_PullHeaders == null) {
            this.m_PullHeaders = (Hashtable)this.m_DefaultHeaders.clone();
            this.m_PullHeaders.put(SONIC_HEADER_CONNECTION_ID, String.valueOf(this.connectionId));
            this.m_PullHeaders.put(HTTP_HEADER_CONTENT_LENGTH, "1");
        }
        int retryCount = 0;
        while (this.m_url != null && !this.socketClosing) {
            this.m_PullHeaders.put(SONIC_HEADER_SEQUENCE_NUMBER, String.valueOf(++sequenceNumber));
            if (this.HTTP_DEBUG_THREAD) {
                System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " requesting data at " + System.currentTimeMillis() + ", sequence number " + sequenceNumber);
            }
            try {
                connection = this.doHTTPConnection(this.m_pullURL, this.m_PullHeaders);
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ: In run(), connection class is of type: " + connection.getClass());
                }
                this.forcePostMode(connection);
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " posting " + REQUEST_DATA_URI + " request");
                }
                InputStream connIS = connection.getInputStream();
                int resp = this.getResponseCode(connection);
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " response code to request POST was: " + resp);
                    int j = 1;
                    while (true) {
                        String header = connection.getHeaderField(j);
                        String key = connection.getHeaderFieldKey(j);
                        if (header == null || key == null) break;
                        System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " response headers were: " + key + ":" + header);
                        ++j;
                    }
                }
                if (resp == -1 || resp == 205) {
                    if (this.HTTP_DEBUG_THREAD) {
                        System.out.println("HTTP_DEBUG_THREAD:response code of " + resp + " received, retrying...");
                    }
                    this.clearUnneededDataFromStream(connIS, this.getContentLength(connection));
                    this.markConnectionAvailable(connection);
                    continue;
                }
                if (resp == 204) {
                    this.clearUnneededDataFromStream(connIS, this.getContentLength(connection));
                    this.markConnectionAvailable(connection);
                    this.setLastResponseTime(System.currentTimeMillis());
                    continue;
                }
                if (resp != 200) {
                    if ((this.HTTP_DEBUG_CLOSE || this.HTTP_DEBUG_FAILURE) && !this.socketClosing) {
                        System.out.println("HTTP_DEBUG: ConnId = " + this.connectionId + " closing, " + Thread.currentThread() + " exiting, response status = " + resp + ", sequence number = " + sequenceNumber);
                    }
                    throw new Exception("HttpClientSocket received response code of " + resp);
                }
                if (this.HTTP_DEBUG_THREAD) {
                    String agent = connection.getHeaderField("AgentId");
                    System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " received data at " + System.currentTimeMillis() + ", sequence number " + sequenceNumber + " from agent " + agent);
                }
                this.setLastResponseTime(System.currentTimeMillis());
                retryCount = 0;
                int contentLength = this.getContentLength(connection);
                int id = this.getSequenceNumber(connection);
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ : ConnId = " + this.connectionId + ", response contentLength = " + contentLength + ", message id = " + id);
                }
                if (id == messageId + 1) {
                    ++messageId;
                } else {
                    if (id <= messageId) {
                        if (contentLength != 0 && this.HTTP_DEBUG_CLOSE) {
                            System.out.println("HTTP_DEBUG_CLOSE : ConnId = " + this.connectionId + " Duplicate message detected, expected msg id  = " + messageId + ", received msg id = " + id + ", content length = " + contentLength + " - skip the message !");
                        }
                        this.clearUnneededDataFromStream(connIS, contentLength);
                        this.markConnectionAvailable(connection);
                        continue;
                    }
                    if (this.HTTP_DEBUG_CLOSE) {
                        System.out.println("HTTP_DEBUG_CLOSE : ConnId = " + this.connectionId + " Lost message detected, expected msg id  = " + messageId + ", received msg id = " + id + ", content length = " + contentLength + " - close connection !");
                    }
                }
                if (contentLength > 0) {
                    byte[] respBytes = new byte[contentLength];
                    int len = 0;
                    int off = 0;
                    int totalread = 0;
                    int totalremaining = contentLength;
                    while ((len = connIS.read(respBytes, off, respBytes.length - off)) >= 0) {
                        off += len;
                        totalread += len;
                        totalremaining -= len;
                        if (this.HTTP_DEBUG_READ) {
                            System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " read " + totalread + " of " + contentLength + " from response input stream");
                        }
                        if (totalremaining > 0) continue;
                    }
                    if (off > 0) {
                        byte[] tmp = new byte[off];
                        System.arraycopy(respBytes, 0, tmp, 0, off);
                        respBytes = tmp;
                        this.in.handleNewData(respBytes);
                    }
                } else if (contentLength < 0 && connIS.available() > 0) {
                    byte[] buf = new byte[Math.max(connIS.available(), 1024)];
                    int bytesRead = -1;
                    int total = 0;
                    while ((bytesRead = connIS.read(buf)) != -1) {
                        total += bytesRead;
                        if (this.HTTP_DEBUG_READ) {
                            System.out.println("HTTP_DEBUG_READ: conn id = " + this.connectionId + " seq id = " + sequenceNumber + " bytes read = " + bytesRead);
                        }
                        if (bytesRead <= 0) continue;
                        byte[] respBytes = new byte[bytesRead];
                        System.arraycopy(buf, 0, respBytes, 0, bytesRead);
                        this.in.handleNewData(respBytes);
                    }
                    if (this.HTTP_DEBUG_READ) {
                        System.out.println("HTTP_DEBUG_READ: conn id = " + this.connectionId + " seq id = " + sequenceNumber + " total bytes read = " + total);
                    }
                }
                this.clearUnneededDataFromStream(connIS, 0);
                this.markConnectionAvailable(connection);
            }
            catch (InterruptedException ex) {
                if (this.socketClosing) {
                    this.disconnect(connection);
                    return;
                }
                ex.printStackTrace();
            }
            catch (FileNotFoundException fnfe) {
                if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_FAILURE) {
                    System.out.println("HTTP_DEBUG: ConnId = " + this.connectionId + " Requester thread received Exception: " + fnfe.getMessage());
                    fnfe.printStackTrace(System.out);
                }
                this.closeInternal();
                this.disconnect(connection);
                return;
            }
            catch (EOFException eof) {
                if (this.socketClosing) {
                    this.disconnect(connection);
                    return;
                }
                if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_FAILURE) {
                    System.out.println("HTTP_DEBUG: ConnId = " + this.connectionId + " Requester thread received " + eof);
                }
                this.closeInternal();
                this.disconnect(connection);
                return;
            }
            catch (IOException ioe) {
                if (this.socketClosing) {
                    this.disconnect(connection);
                    return;
                }
                if (++retryCount <= this.HTTP_RETRY_ATTEMPTS) {
                    try {
                        Thread.sleep(this.HTTP_RETRY_SLEEP_TIME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.HTTP_DEBUG_READ) continue;
                    System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " recieved IOException trying to retrieve data from the broker , retryCount: " + retryCount + " (of " + this.HTTP_RETRY_ATTEMPTS + ")");
                    ioe.printStackTrace();
                    continue;
                }
                if (this.HTTP_DEBUG_CONNECT || this.HTTP_DEBUG_THREAD || this.HTTP_DEBUG_FAILURE) {
                    System.out.println("HTTP_DEBUG: " + Thread.currentThread().getName() + " exiting ... failed to retrieve data from the broker: " + ioe + " , retryCount: " + retryCount);
                    ioe.printStackTrace();
                }
                this.closeInternal();
                return;
            }
            catch (Exception e) {
                if (this.socketClosing) {
                    this.disconnect(connection);
                    return;
                }
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " Requester thread received Exception: " + e.getMessage());
                    e.printStackTrace(System.out);
                }
                this.closeInternal();
                this.disconnect(connection);
                return;
            }
            catch (Error err) {
                if (this.HTTP_DEBUG_READ) {
                    System.out.println("HTTP_DEBUG_READ: ConnId = " + this.connectionId + " Requester thread received Error: " + err.getClass());
                    err.printStackTrace();
                }
                this.closeInternal();
                this.disconnect(connection);
                throw err;
            }
        }
        if (!this.socketClosing && this.m_url != null && this.HTTP_DEBUG_FAILURE) {
            System.out.println("HTTP_DEBUG_FAILURE: ConnId = " + this.connectionId + " closing, " + Thread.currentThread() + " exiting for unknown reason.");
        }
        this.closeInternal();
        this.disconnect(connection);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.m_url == null) {
            return;
        }
        try {
            this.doClose();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            this.m_url = null;
        }
    }

    void closeInternal() {
        this.configClosedBy();
        this.in.closeInternal();
    }

    protected Hashtable getCloseHeader() {
        Hashtable headers = (Hashtable)this.m_DefaultHeaders.clone();
        headers.put(SONIC_HEADER_CONNECTION_ID, String.valueOf(this.connectionId));
        headers.put(HTTP_HEADER_CONNECTION, "close");
        headers.put(HTTP_HEADER_CONTENT_LENGTH, "1");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        this.configClosedBy();
        if (this.HTTP_DEBUG_CONNECT || this.HTTP_DEBUG_THREAD) {
            System.out.println("HTTP_DEBUG: " + Thread.currentThread() + " closing socket, connection id = " + this.connectionId);
        }
        this.socketClosing = true;
        try {
            this.pinger.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        URLConnection connection = null;
        try {
            connection = this.doHTTPConnection(this.m_closeURL, this.getCloseHeader());
            this.forcePostMode(connection);
            InputStream connIS = connection.getInputStream();
            int resp = this.getResponseCode(connection);
            this.doneInput(connIS);
            if (this.HTTP_DEBUG_THREAD) {
                String agent = connection.getHeaderField("AgentId");
                System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " received CLOSE response from agent " + agent + ", connection id = " + this.connectionId);
            }
            this.disconnect(connection);
        }
        catch (Exception exception) {
            this.disconnect(connection);
        }
        catch (Throwable throwable) {
            this.disconnect(connection);
            throw throwable;
        }
        try {
            this.requester.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.closeInternal();
        this.in.close();
        this.out.close();
    }

    private void configClosedBy() {
        if (this.m_closedBy == null) {
            this.m_closedBy = Thread.currentThread().getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URLConnection doHTTPConnection(URL url, Hashtable headers) throws IOException {
        if (url == null) {
            throw new IOException(prAccessor.getString("STR003"));
        }
        URLConnection connection = null;
        if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_SEND || this.HTTP_DEBUG_CONNECT) {
            System.out.println("HTTP_DEBUG: Opening " + url + " connection to host = " + url.getHost());
        }
        int retryCount = 0;
        Object object = connectSync;
        synchronized (object) {
            while (true) {
                ++retryCount;
                try {
                    connection = url.openConnection();
                    if (this.m_httpProxyConfig != null && this.m_httpProxyConfig.getHost() != null && this.m_httpProxyConfig.getHost().trim().length() > 0) {
                        String uid = this.m_httpProxyConfig.getUserName();
                        String psw = this.m_httpProxyConfig.getUserPassword();
                        if (uid != null && uid.trim().length() > 0) {
                            String password = uid + ":" + psw;
                            BASE64Encoder base64Encoder = new BASE64Encoder();
                            String encodedPassword = base64Encoder.encode(password.getBytes());
                            connection.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
                        }
                    }
                    if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_SEND || this.HTTP_DEBUG_CONNECT) {
                        System.out.println("HTTP_DEBUG: Creating a URL connection " + connection.getURL() + " of " + connection.getClass() + " , retry # " + retryCount);
                    }
                    if (headers != null) {
                        Enumeration hdr_enum = headers.keys();
                        while (hdr_enum.hasMoreElements()) {
                            String hdr = (String)hdr_enum.nextElement();
                            if (this.HTTP_DEBUG_READ || this.HTTP_DEBUG_SEND || this.HTTP_DEBUG_CONNECT) {
                                System.out.println("HTTP_DEBUG: Setting custom header:: " + hdr + ": " + (String)headers.get(hdr));
                            }
                            connection.setRequestProperty(hdr, (String)headers.get(hdr));
                        }
                    } else {
                        connection.setRequestProperty(SONIC_HEADER_CONNECTION_ID, String.valueOf(this.connectionId));
                    }
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setAllowUserInteraction(this.HTTP_ALLOW_INTERACTION);
                    connection.setUseCaches(false);
                }
                catch (IOException ex) {
                    if (retryCount != this.HTTP_RETRY_ATTEMPTS) continue;
                    throw ex;
                    if (retryCount < this.HTTP_RETRY_ATTEMPTS) continue;
                }
                break;
            }
        }
        return connection;
    }

    protected String getProtocol() {
        return "http";
    }

    protected URL newURL(String protocol, String host, int port, String file) throws MalformedURLException {
        return new URL(protocol, host, port, file);
    }

    protected URL newURL(URL url, String spec) throws MalformedURLException {
        return new URL(url, spec);
    }

    protected int getResponseCode(URLConnection connection) throws IOException {
        return ((HttpURLConnection)connection).getResponseCode();
    }

    protected int getContentLength(URLConnection connection) throws IOException {
        int len = connection.getContentLength();
        if (this.HTTP_DEBUG_READ) {
            System.out.println("HTTP_DEBUG_READ: " + connection.getURL() + " response length = " + len);
        }
        return len;
    }

    protected int getConnectionId(URLConnection connection) throws IOException {
        block4: {
            String cid = connection.getHeaderField(SONIC_HEADER_CONNECTION_ID);
            try {
                if (cid != null) {
                    int id = Integer.parseInt(cid);
                    if (this.HTTP_DEBUG_CONNECT) {
                        System.out.println("HTTP_DEBUG_CONNECT: conn id = " + id);
                    }
                    return id;
                }
            }
            catch (NumberFormatException nfe) {
                if (!this.HTTP_DEBUG_CONNECT) break block4;
                nfe.printStackTrace();
            }
        }
        throw new IOException(prAccessor.getString("STR001"));
    }

    protected int getConnectionIdleTimeout(URLConnection connection) throws IOException {
        block4: {
            String idle = connection.getHeaderField(SONIC_HEADER_PING_INTERVAL);
            try {
                if (idle != null) {
                    int idleTimeout = Integer.parseInt(idle);
                    if (this.HTTP_DEBUG_CONNECT) {
                        System.out.println("HTTP_DEBUG_CONNECT: connection idle timeout = " + idleTimeout);
                    }
                    return idleTimeout;
                }
            }
            catch (NumberFormatException nfe) {
                if (!this.HTTP_DEBUG_CONNECT) break block4;
                nfe.printStackTrace();
            }
        }
        throw new IOException(prAccessor.getString("STR001"));
    }

    private int getSequenceNumber(URLConnection connection) throws IOException {
        String sn = connection.getHeaderField(SONIC_HEADER_SEQUENCE_NUMBER);
        int id = -1;
        try {
            if (sn != null) {
                id = Integer.parseInt(sn);
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        return id;
    }

    protected void doneInput(InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
    }

    protected void doneOutput(OutputStream out) throws IOException {
        if (out != null) {
            out.close();
        }
    }

    protected void clearUnneededDataFromStream(InputStream connIS, int len) throws IOException {
        this.doneInput(connIS);
    }

    protected void markConnectionAvailable(URLConnection connection) {
    }

    protected void disconnect(URLConnection connection) {
        if (connection == null) {
            return;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        } else {
            try {
                InputStream connIS = connection.getInputStream();
                if (connIS != null) {
                    connIS.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getProperty(String key, String val) {
        String value = this.getProperty(key);
        return value == null ? val : value;
    }

    protected String getProperty(String key) {
        if (this.m_props == null) {
            return null;
        }
        if (this.m_props instanceof Hashtable) {
            return (String)((Hashtable)this.m_props).get(key);
        }
        if (this.m_props instanceof Applet) {
            return ((Applet)this.m_props).getParameter(key);
        }
        return null;
    }

    private Thread startPingThread() {
        Thread Pinger = null;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                long full_pinginterval = SessionConfig.HTTP_PING_TIMEOUT * 1000;
                if (HttpClientSocket.this.idleTimeout > 0) {
                    full_pinginterval = Math.min(full_pinginterval, (long)(HttpClientSocket.this.idleTimeout / 2));
                }
                if (HttpClientSocket.this.HTTP_DEBUG_CONNECT) {
                    System.out.println("HTTP_DEBUG_CONNECT: ping interval is " + full_pinginterval + "ms.");
                }
                String connID = String.valueOf(HttpClientSocket.this.connectionId);
                if (HttpClientSocket.this.m_PingHeaders == null) {
                    HttpClientSocket.this.m_PingHeaders = (Hashtable)HttpClientSocket.this.m_DefaultHeaders.clone();
                    HttpClientSocket.this.m_PingHeaders.put(HttpClientSocket.HTTP_HEADER_CONTENT_LENGTH, "1");
                    HttpClientSocket.this.m_PingHeaders.put(HttpClientSocket.PING_REQUEST_HDR, connID);
                }
                long pinginterval = full_pinginterval;
                int retryCount = 0;
                URLConnection connection = null;
                while (!HttpClientSocket.this.socketClosing) {
                    try {
                        Thread.sleep(pinginterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (HttpClientSocket.this.m_url == null || HttpClientSocket.this.socketClosing) {
                        HttpClientSocket.this.disconnect(connection);
                        break;
                    }
                    long currTime = System.currentTimeMillis();
                    long elapsedTime = currTime - HttpClientSocket.this.getLastResponseTime();
                    if (elapsedTime < full_pinginterval) {
                        pinginterval = full_pinginterval - elapsedTime;
                        continue;
                    }
                    pinginterval = full_pinginterval;
                    try {
                        connection = HttpClientSocket.this.doHTTPConnection(HttpClientSocket.this.m_url, HttpClientSocket.this.m_PingHeaders);
                        HttpClientSocket.this.forcePostMode(connection);
                        InputStream connIS = connection.getInputStream();
                        int resp = HttpClientSocket.this.getResponseCode(connection);
                        if (HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                            String agent = connection.getHeaderField("AgentId");
                            System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " ping response from agent " + agent + ", response status = " + resp + (resp == 200 ? "" : " , exiting ..."));
                        }
                        if (resp != 200) {
                            throw new IOException(Thread.currentThread() + " exiting, status = " + resp);
                        }
                        HttpClientSocket.this.clearUnneededDataFromStream(connIS, HttpClientSocket.this.getContentLength(connection));
                        HttpClientSocket.this.markConnectionAvailable(connection);
                        retryCount = 0;
                    }
                    catch (IOException ce) {
                        HttpClientSocket.this.disconnect(connection);
                        if (++retryCount <= HttpClientSocket.this.HTTP_RETRY_ATTEMPTS) {
                            pinginterval = 1000L;
                            continue;
                        }
                        if (HttpClientSocket.this.HTTP_DEBUG_CONNECT || HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                            System.out.println("HTTP_DEBUG_THREAD: 1 " + Thread.currentThread().getName() + " exiting ... failed to ping the broker: " + ce);
                        }
                        try {
                            HttpClientSocket.this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (HttpClientSocket.this.HTTP_DEBUG_CONNECT || HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                            System.out.println("HTTP_DEBUG_THREAD: 2 " + Thread.currentThread().getName() + " exiting ... failed to ping the broker: " + e);
                        }
                        try {
                            HttpClientSocket.this.disconnect(connection);
                            HttpClientSocket.this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
        };
        Pinger = new Thread(runner);
        Pinger.setDaemon(true);
        Pinger.start();
        return Pinger;
    }

    private void forcePostMode(URLConnection connection) throws IOException {
        OutputStream os = connection.getOutputStream();
        os.write(1);
        os.flush();
        this.doneOutput(os);
    }

    private URL processForProxy(URL originalUrl, String originalProtocol, String originalHost, int originalPort, String originalFile) throws MalformedURLException {
        if (!SessionConfig.IN_BROKER) {
            return originalUrl;
        }
        if (this.m_httpProxyConfig == null) {
            return originalUrl;
        }
        if (HttpHelper.isHttps((URL)originalUrl)) {
            return originalUrl;
        }
        if (this.m_httpProxyConfig.getHost() != null && this.m_httpProxyConfig.getHost().trim().length() > 0) {
            String proxyProtocol = this.m_httpProxyConfig.getProtocol();
            String proxyHost = this.m_httpProxyConfig.getHost();
            int proxyPort = this.m_httpProxyConfig.getPort();
            String urlProtocol = originalUrl.getProtocol();
            String urlFile = urlProtocol + "://" + URLUtil.wrapIPv6Address(originalHost) + ":" + originalPort + originalFile;
            originalUrl = new URL(proxyProtocol, proxyHost, proxyPort, urlFile);
        }
        return originalUrl;
    }

    class HttpClientSocketInputStream
    extends InputStream {
        private SafeQueue incomingData = new SafeQueue();
        private InputStream currentInputStream = null;

        HttpClientSocketInputStream() {
        }

        protected void handleNewData(byte[] in) throws IOException {
            if (HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                if (in == null) {
                    System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread() + " adding null to incoming queue.");
                } else if (in.length == 0) {
                    System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread() + " adding 0 bytes to incoming queue.");
                }
            }
            this.incomingData.add(in);
        }

        @Override
        public int read() throws IOException {
            byte[] temp = new byte[1];
            switch (this.read(temp, 0, 1)) {
                default: {
                    return -1;
                }
                case 1: 
            }
            return temp[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.getCurrentInputStream(true) == null) {
                return -1;
            }
            int result = this.currentInputStream.read(b, off, len);
            if (result <= 0) {
                this.currentInputStream.close();
                this.currentInputStream = null;
                return this.read(b, off, len);
            }
            if (this.currentInputStream.available() <= 0) {
                this.currentInputStream.close();
                this.currentInputStream = null;
            }
            return result;
        }

        private InputStream getCurrentInputStream(boolean bWait) throws IOException {
            if (this.currentInputStream != null) {
                return this.currentInputStream;
            }
            byte[] currentData = null;
            if (bWait) {
                if (!HttpClientSocket.this.isAlive()) {
                    currentData = (byte[])this.incomingData.removeNonBlocking();
                } else {
                    try {
                        currentData = (byte[])this.incomingData.remove();
                    }
                    catch (InterruptedException ie) {
                        currentData = null;
                    }
                }
                if (currentData == null || currentData.length <= 0) {
                    this.handleNewData(null);
                    return null;
                }
            } else {
                return null;
            }
            this.currentInputStream = new ByteArrayInputStream(currentData);
            return this.currentInputStream;
        }

        @Override
        public int available() throws IOException {
            InputStream in = this.getCurrentInputStream(false);
            if (in == null) {
                return -1;
            }
            return in.available();
        }

        @Override
        public void close() throws IOException {
            while (this.incomingData.removeNonBlocking() != null) {
            }
            this.handleNewData(null);
        }

        void closeInternal() {
            this.incomingData.add(null);
        }
    }

    class HttpSocketOutputStream
    extends OutputStream {
        private ByteArrayOutputStream out = null;
        private int sequenceNumber = 0;
        private int connectionID;
        private byte[] temp;
        private URLConnection m_connection = null;
        private OutputStream m_connOS = null;

        HttpSocketOutputStream(int _connectionID) {
            this.connectionID = _connectionID;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.temp == null) {
                this.temp = new byte[1];
            }
            this.temp[0] = (byte)b;
            this.write(this.temp, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (HttpClientSocket.this.m_url == null) {
                throw new IOException(prAccessor.getString("STR003"));
            }
            if (this.out == null) {
                this.out = new ByteArrayOutputStream(HttpClientSocket.this.HTTP_REQUEST_SIZE);
            }
            if (len > 0) {
                int t_len;
                for (int t_off = 0; t_off < len; t_off += t_len) {
                    t_len = Math.min(HttpClientSocket.this.HTTP_REQUEST_SIZE, len - t_off);
                    this.out.write(b, off + t_off, t_len);
                    if (this.out.size() <= HttpClientSocket.this.HTTP_REQUEST_SIZE) continue;
                    this.flush();
                }
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.out == null || this.out.size() <= 0) {
                return;
            }
            if (HttpClientSocket.this.m_url == null) {
                throw new IOException(prAccessor.getString("STR003"));
            }
            byte[] data = this.out.toByteArray();
            this.out.reset();
            int offset = 0;
            int send_attempt = 0;
            InputStream connIS = null;
            while (offset < data.length) {
                try {
                    int size = Math.min(HttpClientSocket.this.HTTP_REQUEST_SIZE, data.length - offset);
                    if (HttpClientSocket.this.m_PushHeaders == null) {
                        HttpClientSocket.this.m_PushHeaders = (Hashtable)HttpClientSocket.this.m_DefaultHeaders.clone();
                        HttpClientSocket.this.m_PushHeaders.put(HttpClientSocket.SONIC_HEADER_CONNECTION_ID, String.valueOf(HttpClientSocket.this.connectionId));
                    }
                    HttpClientSocket.this.m_PushHeaders.put(HttpClientSocket.SONIC_HEADER_SEQUENCE_NUMBER, String.valueOf(this.sequenceNumber));
                    HttpClientSocket.this.m_PushHeaders.put(HttpClientSocket.HTTP_HEADER_CONTENT_LENGTH, String.valueOf(size));
                    this.m_connection = HttpClientSocket.this.doHTTPConnection(HttpClientSocket.this.m_pushURL, HttpClientSocket.this.m_PushHeaders);
                    if (HttpClientSocket.this.HTTP_DEBUG_SEND) {
                        System.out.println("HTTP_DEBUG_SEND: ConnId = " + HttpClientSocket.this.connectionId + " posting " + HttpClientSocket.EXISTIN_CONNECTION_URI + " request");
                        System.out.println("HTTP_DEBUG_SEND: ConnectionId = " + String.valueOf(HttpClientSocket.this.connectionId));
                        System.out.println("HTTP_DEBUG_SEND: SequenceNumber = " + String.valueOf(this.sequenceNumber));
                        System.out.println("HTTP_DEBUG_SEND: Content-Length = " + String.valueOf(size));
                    }
                    this.m_connOS = this.m_connection.getOutputStream();
                    this.m_connOS.write(data, offset, size);
                    this.m_connOS.flush();
                    HttpClientSocket.this.doneOutput(this.m_connOS);
                    connIS = this.m_connection.getInputStream();
                    if (HttpClientSocket.this.HTTP_DEBUG_SEND) {
                        System.out.println("HTTP_DEBUG_SEND: ConnId = " + HttpClientSocket.this.connectionId + " " + HttpClientSocket.EXISTIN_CONNECTION_URI + " getting response code  ");
                    }
                    int resp = HttpClientSocket.this.getResponseCode(this.m_connection);
                    if (HttpClientSocket.this.HTTP_DEBUG_SEND) {
                        System.out.println("HTTP_DEBUG_SEND: ConnId = " + HttpClientSocket.this.connectionId + " " + HttpClientSocket.EXISTIN_CONNECTION_URI + " response code was " + resp);
                    }
                    if (HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                        String agent = this.m_connection.getHeaderField("AgentId");
                        System.out.println("HTTP_DEBUG_THREAD: " + Thread.currentThread().getName() + " received put response from agent " + agent + ", response status = " + resp);
                    }
                    if (resp == 204) {
                        HttpClientSocket.this.clearUnneededDataFromStream(connIS, HttpClientSocket.this.getContentLength(this.m_connection));
                        HttpClientSocket.this.markConnectionAvailable(this.m_connection);
                        continue;
                    }
                    if (resp != 200) {
                        throw new Exception("flush() received response code of " + resp);
                    }
                    HttpClientSocket.this.setLastResponseTime(System.currentTimeMillis());
                    offset += size;
                    if (HttpClientSocket.this.HTTP_DEBUG_SEND) {
                        int j = 1;
                        while (true) {
                            String header = this.m_connection.getHeaderField(j);
                            String key = this.m_connection.getHeaderFieldKey(j);
                            if (header == null || key == null) break;
                            System.out.println("HTTP_DEBUG_SEND: ConnId = " + HttpClientSocket.this.connectionId + " response headers were: " + key + ":" + header);
                            ++j;
                        }
                    }
                    ++this.sequenceNumber;
                    HttpClientSocket.this.clearUnneededDataFromStream(connIS, HttpClientSocket.this.getContentLength(this.m_connection));
                    HttpClientSocket.this.markConnectionAvailable(this.m_connection);
                }
                catch (Exception ex) {
                    if (HttpClientSocket.this.HTTP_DEBUG_SEND) {
                        System.out.println("HTTP_DEBUG_SEND: ConnId = " + HttpClientSocket.this.connectionId + " " + Thread.currentThread().getName() + " SEND ATTEMPT " + (send_attempt + 1) + " of " + HttpClientSocket.this.HTTP_RETRY_ATTEMPTS + "  FAILED: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    HttpClientSocket.this.disconnect(this.m_connection);
                    if (HttpClientSocket.this.m_url == null) {
                        return;
                    }
                    if (++send_attempt == HttpClientSocket.this.HTTP_RETRY_ATTEMPTS) {
                        if (HttpClientSocket.this.HTTP_DEBUG_THREAD) {
                            System.out.println("HTTP_DEBUG_THREAD: ConnId = " + HttpClientSocket.this.connectionId + " " + Thread.currentThread().getName() + " failed to send data : " + ex);
                        }
                        throw new IOException(ex.getMessage());
                    }
                    try {
                        this.wait(HttpClientSocket.this.HTTP_RETRY_SLEEP_TIME);
                    }
                    catch (Exception exception) {}
                }
                catch (Error err) {
                    HttpClientSocket.this.disconnect(this.m_connection);
                    throw err;
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (HttpClientSocket.this.m_url != null) {
                this.flush();
                HttpClientSocket.this.disconnect(this.m_connection);
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

