/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm.util;

import com.sonicsw.blackbird.evs.nio.nwlink.strm.EvsOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import progress.message.net.ISocket;
import progress.message.strm.IStreamSegment;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class BufferedStrmOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean DEBUG;
    private boolean DEBUG1;
    private DebugObject m_debugObj;
    private OutputStream m_bos;
    private int m_initialBufSize;
    private byte[] m_buf;
    private int m_count;
    private OutputStream m_baseOutputStream;
    private IStreamSegment m_streamSegment;
    private boolean m_isSegmented;

    public BufferedStrmOutputStream(OutputStream os) {
        this(os, 8192);
    }

    public BufferedStrmOutputStream(OutputStream os, int bufSize) {
        this.m_baseOutputStream = os;
        this.m_bos = new BufferedOutputStream(os, bufSize);
        this.m_initialBufSize = bufSize;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("BufferedStrmOutputStream ");
            this.DEBUG = this.m_debugObj.getDebug();
            boolean bl = this.DEBUG1 = (this.m_debugObj.debugFlags & 0x40) > 0;
        }
        if (this.DEBUG1) {
            this.debug("Created; bufsize= " + bufSize);
        }
    }

    public synchronized void convertToSegmentedStream(IStreamSegment seg) {
        if (this.DEBUG1) {
            this.debug("convertToSegmentedStream called;");
        }
        this.m_buf = new byte[this.m_initialBufSize];
        this.m_count = 0;
        this.m_streamSegment = seg;
        this.m_isSegmented = true;
    }

    public synchronized OutputStream convertToUnsegmentedStream(ISocket socket, int maxBufSize, int minBufSize, int initialBufSize) throws IOException {
        if (this.DEBUG1) {
            this.debug("convertToSegmentedStream called;");
        }
        if (this.m_isSegmented) {
            throw new EAssertFailure("Can't convert segmented stream to unsegmented");
        }
        if (this.m_baseOutputStream instanceof EvsOutputStream) {
            if (this.DEBUG1) {
                this.debug("Converting to buffered evs output stream");
            }
            this.m_bos.flush();
            this.m_baseOutputStream = this.m_bos = socket.getOutputStream(maxBufSize, minBufSize, initialBufSize);
            return this.m_bos;
        }
        return this;
    }

    public synchronized byte getStreamVersion() {
        if (this.m_isSegmented) {
            return this.m_streamSegment.getVersion();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (!this.m_isSegmented) {
            this.m_bos.close();
            return;
        }
        if (this.m_buf == null) {
            return;
        }
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_baseOutputStream.close();
        try {
            this.m_bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_buf = null;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.m_isSegmented) {
            this.m_bos.flush();
            return;
        }
        this.writeBuffer();
        this.m_baseOutputStream.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.m_isSegmented) {
            this.m_bos.write(b);
            return;
        }
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (!this.m_isSegmented) {
            this.m_bos.write(b, off, len);
            return;
        }
        if (len >= this.m_buf.length) {
            this.writeBuffer();
            this.writeToUnderlyingStream(b, off, len);
            return;
        }
        if (len > this.m_buf.length - this.m_count) {
            this.writeBuffer();
        }
        System.arraycopy(b, off, this.m_buf, this.m_count, len);
        this.m_count += len;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (!this.m_isSegmented) {
            this.m_bos.write(b);
            return;
        }
        if (this.m_count >= this.m_buf.length) {
            this.writeBuffer();
        }
        this.m_buf[this.m_count++] = (byte)(b & 0xFF);
    }

    private void writeBuffer() throws IOException {
        if (this.m_count > 0) {
            this.writeToUnderlyingStream(this.m_buf, 0, this.m_count);
            this.m_count = 0;
        }
    }

    private void writeToUnderlyingStream(byte[] b, int off, int len) throws IOException {
        this.writeToSegmentedStream(b, off, len);
    }

    private void writeToSegmentedStream(byte[] b, int off, int lenParam) throws IOException {
        int thisWrite;
        int maxWriteSize = Math.min(this.m_buf.length, 32768);
        for (int len = lenParam; len > 0; len -= thisWrite) {
            thisWrite = maxWriteSize < len ? maxWriteSize : len;
            this.m_streamSegment.writeSegment(this.m_baseOutputStream, b, off, thisWrite);
            off += thisWrite;
        }
    }

    private void debug(String s) {
        this.m_debugObj.debug(s);
    }
}

