/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IDirectSender;
import progress.message.zclient.xonce.IDRInboundAdapter;
import progress.message.zclient.xonce.IDROutboundAdapter;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IIDRInboundSupport;
import progress.message.zclient.xonce.IIDROutboundSupport;
import progress.message.zclient.xonce.IIDRTransport;
import progress.message.zclient.xonce.JobResolver;
import progress.message.zclient.xonce.MgramIDRTransport;
import progress.message.zclient.xonce.TransactedAckResolver;

public class ChannelDoubtResolver
extends DebugObject
implements IDoubtResolver,
IDoubtResolverCompletionListener {
    Vector m_dependents = new Vector();
    IDoubtResolverCompletionListener m_listener = null;
    IIDRTransport m_transport = null;
    IIDROutboundSupport m_outbound;
    IIDRInboundSupport m_inbound;
    IDoubtResolver m_jobResolver;
    IDoubtResolver m_txAckResolver;
    IDoubtResolver m_flowControlResolver;

    public ChannelDoubtResolver(Connection connection) {
        super("ChannelDoubtResolver");
        if (ChannelDoubtResolver.isJMSSenderCapable(connection.getApplicationId())) {
            this.m_outbound = new IDROutboundAdapter(connection.getConnectionInfo());
        }
        this.m_inbound = new IDRInboundAdapter(connection.getConnectionInfo());
        this.m_transport = new MgramIDRTransport(false, connection.getChannel(), connection.getApplicationId(), (IDirectSender)((Object)connection.getSender()), this.m_outbound, this.m_inbound);
        connection.setIDRTransport(this.m_transport);
        this.m_jobResolver = new JobResolver(connection);
        this.m_txAckResolver = new TransactedAckResolver(connection);
        this.m_inbound.setCompletionListener(this);
        this.m_inbound.setTransport(this.m_transport);
        this.m_dependents.add(this.m_inbound);
        if (this.m_outbound != null) {
            this.m_outbound.setCompletionListener(this);
            this.m_outbound.setTransport(this.m_transport);
            this.m_dependents.add(this.m_outbound);
        }
        this.m_jobResolver.setCompletionListener(this);
        this.m_txAckResolver.setCompletionListener(this);
    }

    @Override
    public void initiateResolution() throws EGeneralException, IOException {
        if (this.m_outbound != null) {
            this.m_outbound.initiateResolution();
        }
        this.m_inbound.initiateResolution();
        this.m_transport.initiateIDRProtocol();
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void failed(IDoubtResolver resolver, IOException ioe) {
        this.m_dependents.clear();
        if (this.m_listener != null) {
            this.m_listener.failed(this, ioe);
        }
    }

    @Override
    public void completed(IDoubtResolver resolver, int status) {
        block8: {
            try {
                if (resolver == this.m_inbound || resolver == this.m_outbound) {
                    this.m_dependents.remove(resolver);
                    if (this.m_dependents.isEmpty()) {
                        this.m_txAckResolver.initiateResolution();
                    }
                } else if (resolver != null && resolver == this.m_txAckResolver) {
                    this.m_jobResolver.initiateResolution();
                } else if (resolver != null && resolver == this.m_jobResolver && this.m_listener != null) {
                    this.m_listener.completed(this, status);
                }
            }
            catch (IOException e) {
                if (this.m_listener == null) break block8;
                this.m_listener.failed(this, e);
            }
        }
    }

    public static boolean isJMSSenderCapable(String appId) {
        if (appId.indexOf("$QR$") >= 0) {
            return false;
        }
        if (appId.indexOf("$QB$") >= 0) {
            return false;
        }
        if (appId.indexOf("$CONNECTION$") >= 0) {
            return false;
        }
        if (appId.indexOf("$CC$$TS$") >= 0) {
            return false;
        }
        return appId.indexOf("$NONDURABLE$") < 0;
    }
}

