/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.IElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;

public class AcknowledgementRange
implements IElement {
    private Constants RMConstants;
    private MessageElement ackRangeElement;
    private long minValue;
    private long maxValue;

    public AcknowledgementRange(Constants constants) {
        this.RMConstants = constants;
        this.ackRangeElement = new MessageElement(this.RMConstants.getNSURI(), "SequenceAcknowledgement");
    }

    public AcknowledgementRange(MessageElement element) {
        this.ackRangeElement = element;
        this.minValue = new Long(element.getAttribute("Lower").trim());
        this.maxValue = new Long(element.getAttribute("Upper").trim());
    }

    public void setMaxValue(long max) {
        this.maxValue = max;
    }

    public void setMinValue(long min) {
        this.minValue = min;
    }

    @Override
    public MessageElement getSoapElement() {
        this.ackRangeElement.setAttribute("Upper", new Long(this.maxValue).toString());
        this.ackRangeElement.setAttribute("Lower", new Long(this.minValue).toString());
        return this.ackRangeElement;
    }

    public MessageElement toSOAPEnvelope(MessageElement msgElement) throws SOAPException {
        SOAPElement ackRange = msgElement.addChildElement("AcknowledgementRange", "wsrm");
        ackRange.setAttribute("Upper", new Long(this.maxValue).toString());
        ackRange.setAttribute("Lower", new Long(this.minValue).toString());
        return msgElement;
    }

    @Override
    public void addChildElement(MessageElement element) {
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public String toString() {
        return new String(this.minValue + ".." + this.maxValue);
    }
}

