/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Session;
import progress.message.jimpl.Topic;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;

public class TemporaryTopic
extends Topic
implements javax.jms.TemporaryTopic {
    private Connection m_tConnection;
    private boolean m_deleted = false;

    public TemporaryTopic(Session session) throws JMSException {
        super(TemporaryTopic.generateTemporaryTopicName(session), true);
        this.m_tConnection = session.m_jconnection;
        this.m_tConnection.addTemporaryTopic(this.getTopicName(), this);
        this.m_routingNodeName = session.getJconnection().getRoutingNodeName();
    }

    @Override
    public void delete() throws JMSException {
        if (this.m_tConnection != null) {
            this.m_tConnection.removeTemporaryTopic(this.getTopicName());
        }
        this.m_tConnection = null;
        this.m_deleted = true;
    }

    @Override
    public String getFullName() {
        if (this.m_routingNodeName != null) {
            return this.m_routingNodeName + "::" + this.getSubject().getJMSName();
        }
        return this.getSubject().getJMSName();
    }

    private static String generateTemporaryTopicName(Session session) {
        String prefix = SessionConfig.getDirectedSubjectPrefix("TemporaryTopics") + '.' + session.m_jconnection.m_zconnection.getEffectiveUid() + '.' + session.m_zconnection.getApplicationId();
        String name = prefix + '.' + ProgressSecureRandom.theSecureRandom().nextInt();
        return name;
    }

    static boolean topicExists(String name, Connection tConnection) {
        TemporaryTopic obj = null;
        obj = tConnection.getTemporaryTopic(name);
        return obj != null;
    }

    @Override
    public final boolean isDeleted() {
        return this.m_deleted;
    }

    @Override
    public void validateForSend(Message message) throws JMSException {
        super.validateForSend(message);
        if (this.isDeleted()) {
            throw new InvalidDestinationException(prAccessor.getString("TOP_PUB_DELETED_TEMPORARY_TOPIC"));
        }
    }

    @Override
    public final void validateForConsume(Connection connection) throws JMSException {
        if (this.isDeleted()) {
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("TOP_PUB_DELETED_TEMPORARY_TOPIC"), null);
        }
        super.validateForConsume(connection);
    }
}

