/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm.v1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;
import progress.message.client.EChecksumValidationFailed;
import progress.message.strm.IStreamSegment;
import progress.message.strm.StrmCommon;
import progress.message.strm.util.CRC16;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.DebugObject;

public class StreamSegment
extends DebugObject
implements IStreamSegment {
    public static byte VERSION = 1;
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int VERSION_OFFSET = 4;
    private static final int DATA_LEN_OFFSET = 5;
    private static final int SEGMENT_FLAGS_OFFSET = 9;
    private static final int HEADER_LEN = 10;
    private byte m_segmentFlags;
    private byte m_streamFlags;
    private int m_crcType;
    private Checksum m_crc;
    private int m_nextSegmentLength;
    private boolean m_hasUnreadData;
    private byte[] m_header = new byte[10];
    private byte[] m_trailer;
    private boolean DEBUG1;

    @Override
    public byte getVersion() {
        return VERSION;
    }

    public StreamSegment(byte streamflags) {
        super("StreamSegment ");
        this.m_streamFlags = streamflags;
        this.m_crcType = StrmCommon.getCRCType(this.m_streamFlags);
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.m_crcType == 1) {
            if (this.DEBUG1) {
                this.debug("Using CRC16");
            }
            this.m_trailer = new byte[2];
            this.m_crc = new CRC16();
        }
        if (this.DEBUG1) {
            this.debug("crcType = " + this.m_crcType);
        }
        ArrayUtil.writeInt(this.m_header, 0, -1156514067);
        this.m_header[4] = VERSION;
        this.m_header[9] = 0;
    }

    public int getCRCType() {
        return this.m_crcType;
    }

    @Override
    public int getNextSegmentLength(InputStream is) throws IOException, EOFException {
        if (this.m_nextSegmentLength == -1) {
            throw new EOFException();
        }
        if (this.m_hasUnreadData) {
            return this.m_nextSegmentLength;
        }
        this.readHeader(is);
        return this.m_nextSegmentLength;
    }

    @Override
    public int readSegment(InputStream is, byte[] buf, int off, int len) throws IOException, EOFException, EChecksumValidationFailed {
        if (this.m_nextSegmentLength == -1) {
            throw new EOFException();
        }
        if (!this.m_hasUnreadData) {
            this.readHeader(is);
        }
        int bytesRead = 0;
        try {
            if (this.m_nextSegmentLength > 0) {
                if (len < this.m_nextSegmentLength) {
                    throw new IOException("StreamSegment: Buffer too small for segment; segment size= " + this.m_nextSegmentLength + " bufSize= " + len);
                }
                StreamUtil.readBytes(is, buf, off, this.m_nextSegmentLength);
                bytesRead = this.m_nextSegmentLength;
            }
            if (this.m_crc != null) {
                this.m_crc.update(buf, off, bytesRead);
                long calculatedCRC = this.m_crc.getValue();
                long crcInStream = this.readTrailer(is);
                if (calculatedCRC != crcInStream) {
                    if (this.DEBUG1) {
                        this.debug("********CRC mismatch crcInStream= " + crcInStream + " calculatedCRC= " + calculatedCRC);
                    }
                    throw new EChecksumValidationFailed();
                }
            }
            this.m_hasUnreadData = false;
            this.m_nextSegmentLength = 0;
        }
        catch (EOFException ex) {
            this.m_nextSegmentLength = -1;
            this.m_hasUnreadData = false;
            throw ex;
        }
        return bytesRead;
    }

    @Override
    public void writeSegment(OutputStream os, byte[] buf, int off, int len) throws IOException {
        Object crc = null;
        if (this.m_crc != null) {
            this.m_crc.reset();
        }
        this.writeHeader(os, len);
        os.write(buf, off, len);
        if (this.m_crc != null) {
            this.m_crc.update(buf, off, len);
        }
        this.writeTrailer(os);
    }

    private void readHeader(InputStream is) throws IOException, EOFException, EChecksumValidationFailed {
        try {
            int magicNumber;
            StreamUtil.readBytes(is, this.m_header, 0, 10);
            if (this.m_crc != null) {
                this.m_crc.reset();
                this.m_crc.update(this.m_header, 0, 10);
            }
            if ((magicNumber = ArrayUtil.readInt(this.m_header, 0)) != -1156514067) {
                if (this.DEBUG1) {
                    this.debug("Stream validation failure -- Read invalid id");
                }
                throw new EChecksumValidationFailed("Stream validation failure -- Read invalid id");
            }
            byte version = this.m_header[4];
            if (version != VERSION) {
                if (this.DEBUG1) {
                    this.debug("Stream validation failure -- Incorrect Version");
                }
                throw new EChecksumValidationFailed("Stream validation failure -- Incorrect stream version");
            }
            int datalen = ArrayUtil.readInt(this.m_header, 5);
            if (datalen > 32768 || datalen < 0) {
                if (this.DEBUG1) {
                    this.debug("Stream validation failure -- Invalid data length= " + datalen);
                }
                throw new EChecksumValidationFailed("Stream validation failure -- Invalid data length= " + datalen);
            }
            this.m_nextSegmentLength = datalen;
            this.m_segmentFlags = this.m_header[9];
            this.m_hasUnreadData = true;
        }
        catch (EOFException ex) {
            if (this.DEBUG) {
                this.debug("readHeader got EOF; ");
            }
            this.m_nextSegmentLength = -1;
            this.m_hasUnreadData = false;
            throw ex;
        }
    }

    private void writeHeader(OutputStream os, int len) throws IOException {
        ArrayUtil.writeInt(this.m_header, 5, len);
        os.write(this.m_header, 0, 10);
        if (this.m_crc != null) {
            this.m_crc.update(this.m_header, 0, 10);
        }
    }

    private void writeTrailer(OutputStream os) throws IOException {
        switch (this.m_crcType) {
            case 1: {
                int checksum = (int)this.m_crc.getValue();
                this.m_trailer[0] = (byte)(0xFF & checksum >> 8);
                this.m_trailer[1] = (byte)(0xFF & checksum);
                os.write(this.m_trailer, 0, 2);
                break;
            }
        }
    }

    private long readTrailer(InputStream is) throws IOException {
        long crc = 0L;
        switch (this.m_crcType) {
            case 1: {
                StreamUtil.readBytes(is, this.m_trailer, 0, 2);
                byte byte1 = this.m_trailer[0];
                byte byte2 = this.m_trailer[1];
                crc = (byte1 & 0xFF) << 8 | byte2 & 0xFF;
                break;
            }
        }
        return crc;
    }
}

