/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EGeneralException;
import progress.message.client.ENotImplemented;
import progress.message.client.EParameterIsNull;
import progress.message.client.EUnusableConnection;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.Job;
import progress.message.zclient.MessageHandler;

public class Solicitation
extends Job {
    private Connection m_connection;
    private Envelope m_request;
    private MessageHandler m_handler;
    private String m_id;
    private IJobResolver m_resolver = null;
    private int m_tracking;

    Solicitation(Connection connection, Envelope request, MessageHandler mh) {
        this(connection, request, mh, null);
    }

    Solicitation(Connection connection, Envelope request, MessageHandler mh, IJobResolver resolver) {
        this.debugName("Solicitation");
        this.m_resolver = resolver;
        this.m_connection = connection;
        this.m_request = request;
        this.m_handler = mh;
        this.m_status = 1;
    }

    @Override
    public void resolve() {
        if (this.m_resolver != null) {
            this.m_resolver.resolveJob(this);
            if (this.DEBUG) {
                this.debug("Resolving Solicitation: " + this);
            }
        } else if (this.DEBUG) {
            this.debug("Not resolving Solicitation: " + this);
        }
    }

    @Override
    public void start() {
        throw new ENotImplemented("Solicitation.start()");
    }

    @Override
    public void suspend() {
        throw new ENotImplemented("Solicitation.stop()");
    }

    @Override
    public synchronized void cancel() {
        this.m_connection.removeJob((long)this.m_tracking & 0xFFFFFFFFL);
        this.setStatus(0);
    }

    public void assignMessageHandler(MessageHandler newMh) throws EParameterIsNull, EUnusableConnection, EGeneralException {
        this.m_connection.addMessageHandler(newMh);
        this.m_handler = newMh;
    }

    public String getSolicitId() {
        return this.m_id;
    }

    void newReply(Envelope env) {
        this.m_handler.newMessage(env);
    }

    void setTracking(int tracking) {
        this.m_tracking = tracking;
        this.m_id = Integer.toString(tracking);
    }

    public int getTracking() {
        return this.m_tracking;
    }

    @Override
    protected String getDiagnosticThreadInfo() {
        return "Solicitation: tracking " + this.m_tracking + ", conn " + (this.m_connection != null ? this.m_connection.getApplicationId() : "<unknown>");
    }
}

