/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.net.http.HttpConstants;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.Message;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;

public class SoapVerifier {
    SOAPMessage m_soapMessage = null;
    SOAPConstants m_soapConstanst = null;

    public SoapVerifier(InputStream is, String contentType) throws Exception {
        try {
            MimeHeaders headers = new MimeHeaders();
            headers.setHeader("Content-Type", contentType);
            SOAPMessage sm = MessageFactory.newInstance().createMessage(headers, is);
            SOAPEnvelope soapEnvelope = (SOAPEnvelope)sm.getSOAPPart().getEnvelope();
            this.m_soapMessage = sm;
            this.m_soapConstanst = soapEnvelope.getSOAPConstants();
        }
        catch (Exception e) {
            String errMessage = this.processsErrMsg(e.getMessage());
            HttpConstants.DEBUG((String)("InputStream contains invalid SOAP, reason: " + errMessage), (int)0);
            throw new Exception(errMessage);
        }
    }

    public int getSoapMessageLength() {
        Message axisMsg = (Message)this.m_soapMessage;
        try {
            long msgLength = axisMsg.getContentLength();
            return (int)msgLength;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.m_soapMessage;
    }

    public SOAPConstants getSoapConstants() {
        return this.m_soapConstanst;
    }

    private String processsErrMsg(String errMsg) {
        String hostString = "UnknownHostException:";
        int index = errMsg.indexOf(hostString);
        if (index < 0) {
            return errMsg;
        }
        return errMsg.substring(0, index + hostString.length() - 1);
    }
}

