/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.impl;

import com.sonicsw.blackbird.evs.EEvsEOFException;
import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkResult;
import com.sonicsw.blackbird.http.IHTTPRequest;
import com.sonicsw.blackbird.http.IHTTPResponse;
import com.sonicsw.blackbird.http.impl.HTTPConnection;
import com.sonicsw.blackbird.http.impl.HTTPMessage;
import com.sonicsw.blackbird.http.impl.HTTPRequest;
import com.sonicsw.blackbird.http.impl.prAccessor;
import progress.message.resources.prMessageFormat;

public class HTTPResponse
extends HTTPMessage
implements IHTTPResponse {
    private short m_statusCode = (short)-1;
    private String m_reasonPhrase;
    private HTTPRequest m_request = null;
    private int m_statusCodeClass = -1;
    private static final String UNSPECIFIED_SERVER_ERROR = "Error Unspecified";

    public HTTPResponse(HTTPConnection connection, int transportMode) {
        super(connection, transportMode);
        this.m_version = "HTTP/1.1";
        if (transportMode == 0) {
            this.m_statusCode = (short)500;
            this.m_reasonPhrase = UNSPECIFIED_SERVER_ERROR;
        }
    }

    @Override
    protected final void writeStartLine(EvsNetworkLinkResult result) throws EEvsIOException {
        this.writeLine("HTTP/1.1 " + this.m_statusCode + " " + this.m_reasonPhrase, result);
    }

    @Override
    protected final boolean readStartLine(EvsNetworkLinkResult result) throws EEvsEOFException, EEvsIOException {
        String statusLine = this.readLine(result);
        if (statusLine == null) {
            if (DEBUG) {
                System.out.println("Unable to read response status line.");
            }
            return false;
        }
        int SP = statusLine.indexOf(32);
        if (SP == -1) {
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Malformed HTTP Response status line: Missing status code! {0}"), new Object[]{statusLine}));
        }
        try {
            this.setHTTPVersion(statusLine.substring(0, SP));
        }
        catch (IllegalArgumentException iae) {
            throw new EEvsIOException(iae.getMessage(), (Exception)iae);
        }
        statusLine = statusLine.substring(SP).trim();
        SP = statusLine.indexOf(32);
        if (SP == -1) {
            throw new EEvsIOException(prAccessor.getString("Malformed HTTP Response status line: Missing reason string!"));
        }
        try {
            this.m_statusCode = Short.parseShort(statusLine.substring(0, SP));
            this.setStatusCode(this.m_statusCode);
        }
        catch (NumberFormatException ex) {
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Malformed HTTP Response status code: {0}"), new Object[]{statusLine.substring(0, SP)}), (Exception)ex);
        }
        catch (IllegalArgumentException iae) {
            throw new EEvsIOException(prMessageFormat.format(prAccessor.getString("Malformed HTTP Response status code: {0}"), new Object[]{statusLine}), (Exception)iae);
        }
        this.m_reasonPhrase = statusLine.substring(SP).trim();
        return true;
    }

    @Override
    public final short getStatusCode() {
        return this.m_statusCode;
    }

    @Override
    public final int getStatusCodeClass() {
        return this.m_statusCodeClass;
    }

    private final void setStatusCodeClass(short statusCode) throws IllegalArgumentException {
        switch (this.m_statusCode / 100) {
            case 1: {
                this.m_statusCodeClass = 1;
                return;
            }
            case 2: {
                this.m_statusCodeClass = 2;
                return;
            }
            case 3: {
                this.m_statusCodeClass = 3;
                return;
            }
            case 4: {
                this.m_statusCodeClass = 4;
                return;
            }
            case 5: {
                this.m_statusCodeClass = 5;
                return;
            }
        }
        this.m_statusCodeClass = 6;
    }

    @Override
    public final void setStatusCode(short statusCode) {
        this.setStatusCodeClass(statusCode);
        this.m_statusCode = statusCode;
    }

    @Override
    public final String getReasonPhrase() {
        return this.m_reasonPhrase;
    }

    @Override
    public final void setReasonPhrase(String reasonPhrase) {
        this.m_reasonPhrase = reasonPhrase;
    }

    public final void setHTTPRequest(HTTPRequest request) {
        this.m_request = request;
        if (request.getResponse() != this) {
            request.setHTTPResponse(this);
        }
    }

    @Override
    public final IHTTPRequest getHTTPRequest() {
        return this.m_request;
    }

    @Override
    public final String toString() {
        return this.debugString() + (this.m_request != null ? "Corresponding request: " + this.m_request.debugString() : "No corresponding request.");
    }

    final String debugString() {
        return "HTTP Response: " + this.m_version + " " + this.m_statusCode + " " + this.m_reasonPhrase + "\n" + super.toString();
    }
}

