/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.WriterUtil;
import java.lang.reflect.Method;

public class IBMHeapDump
implements IDiagnosticsConstants {
    private static String DESCRIPTION;
    private static boolean m_heapDumpSupported;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static Class Dump_CLASS;
    private static Method HeapDump_METHOD;

    static String describe() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("This JVM generates an IBM JVM heap dump in a text format.").append(NEWLINE);
        tmp.append(DESCRIPTION);
        return tmp.toString();
    }

    static boolean heapDumpSupported() {
        return m_heapDumpSupported;
    }

    static void dumpHeap(StringBuffer buffer) {
        try {
            HeapDump_METHOD.invoke(null, EMPTY_OBJECT_ARRAY);
            buffer.append("Heap dump file was generated. ");
            buffer.append(DESCRIPTION);
        }
        catch (Throwable t) {
            buffer.append("jvm.heap").append(" failed to generate a heap dump for the IBM JVM:");
            buffer.append(NEWLINE).append(WriterUtil.getExceptionAsString(t));
        }
    }

    static {
        m_heapDumpSupported = true;
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        StringBuffer tmp = new StringBuffer();
        tmp.append("The name of the dump file is written to the container log (if running in the MF container) and/or to ").append(NEWLINE);
        tmp.append("the standard output.").append(NEWLINE);
        tmp.append("The 'Using HeapDump' section of the http://download.boulder.ibm.com/ibmdl/pub/software/dw/jdk/diagnosis/diag142.pdf").append(NEWLINE);
        tmp.append("document details the interpretation and use of the heap dump file.");
        DESCRIPTION = tmp.toString();
        try {
            Dump_CLASS = Class.forName("com.ibm.jvm.Dump");
            HeapDump_METHOD = Dump_CLASS.getMethod("HeapDump", EMPTY_CLASS_ARRAY);
        }
        catch (Throwable e) {
            m_heapDumpSupported = false;
        }
    }
}

