/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.Serializable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.Referenceable;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.Destination;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.MessageProducer;
import progress.message.jimpl.TemporaryQueue;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

public class Queue
extends progress.message.jclient.Queue
implements javax.jms.Queue,
Referenceable,
Serializable,
Destination {
    protected String m_routingNodeName = null;
    protected String m_queueName = null;
    private transient ISubject m_subject = null;

    public Queue(String queueName) throws JMSException {
        this(queueName, false);
    }

    Queue(String routing, ISubject subject) {
        this.m_routingNodeName = routing;
        this.m_subject = subject;
        this.m_queueName = routing == null ? subject.getJMSName() : routing + "::" + subject.getJMSName();
        super.setNameOnly(this.m_queueName);
    }

    public Queue(String queueName, boolean isInternalName) throws InvalidDestinationException {
        this.setQueueNameInternal(queueName, !isInternalName && !DestUtil.isTemporaryQueue(DestUtil.getDestinationName(queueName)) && !DestUtil.getDestinationName(queueName).startsWith("SonicMQ.routingQueue$"));
    }

    @Override
    public void setName(String name) throws JMSException {
        this.setQueueNameInternal(name, true);
    }

    @Override
    public void setQueueName(String name) throws JMSException {
        this.setQueueNameInternal(name, true);
    }

    private final void setQueueNameInternal(String queueName, boolean validate) throws InvalidDestinationException {
        this.m_routingNodeName = DestUtil.getRoutingName(queueName);
        String queueOnly = DestUtil.getDestinationName(queueName);
        if (validate) {
            DestUtil.validateRoutingName(this.m_routingNodeName);
            DestUtil.validateQueueName(queueOnly);
        }
        this.m_subject = new Subject("$Q." + queueOnly);
        this.m_queueName = queueName;
        super.setNameOnly(queueName);
    }

    @Override
    public String getFullName() {
        return this.m_queueName;
    }

    @Override
    public String getDestinationName() throws JMSException {
        return this.getQueueName();
    }

    @Override
    public String getQueueName() throws JMSException {
        return this.m_queueName;
    }

    String getRoutingNodeName() throws JMSException {
        return this.m_routingNodeName;
    }

    @Override
    public String toString() {
        return this.m_queueName;
    }

    void resetName(String name) {
        try {
            this.setQueueNameInternal(name, false);
        }
        catch (InvalidDestinationException invalidDestinationException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasGroup() {
        return false;
    }

    @Override
    public String getGroupName() {
        return null;
    }

    @Override
    public boolean hasRouting() {
        return this.m_routingNodeName != null;
    }

    @Override
    public String getRouting() {
        return this.m_routingNodeName;
    }

    @Override
    public final boolean isTemporary() {
        return this.m_subject.isTemporary();
    }

    @Override
    public boolean isDeleted() throws JMSException {
        return false;
    }

    @Override
    public boolean isQueue() throws JMSException {
        return true;
    }

    @Override
    public boolean isTopic() throws JMSException {
        return false;
    }

    @Override
    public boolean isMultiDestination() throws JMSException {
        return false;
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    public int hashCode() {
        int hc = this.m_subject.hashCode();
        if (this.m_routingNodeName != null) {
            hc += this.m_routingNodeName.hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Queue q = (Queue)obj;
        if (this.m_routingNodeName != q.m_routingNodeName) {
            if (this.m_routingNodeName == null) {
                return false;
            }
            if (!this.m_routingNodeName.equals(q.m_routingNodeName)) {
                return false;
            }
        }
        return this.m_subject.equals(q.m_subject);
    }

    @Override
    public void validateForSend(Message message) throws JMSException {
        if (message != null && MessageProducer.isAmbiguousURLDestination(this.m_subject.getJMSName(), message)) {
            throw new InvalidDestinationException(prAccessor.getString("AMBIGUOUS_URL_DESTINATION"));
        }
    }

    @Override
    public void validateForConsume(Connection connection) throws JMSException {
        if (this.isTemporary() && !TemporaryQueue.queueExists(this.getDestinationName(), connection)) {
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("TEMPORARY_QUEUE_INVALID_ACCESS"), null);
        }
    }
}

