/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Properties;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.SocketConnectHelper;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.prAccessor;
import progress.message.zclient.SessionConfig;

public abstract class ProgressSocketFactory {
    private static Object s_mutex = new Object();
    private static boolean m_nioAvailable = true;
    public static final int TCP = 0;
    public static final int SSL = 1;
    public static final int HTTP = 2;
    public static final int HTTPS = 3;
    public static final int MQTT = 4;
    public static final int MQTTS = 5;
    private static ProgressSocketFactory[] s_socketFactoryList;

    public static int getType(String socketType) throws ESocketConfigException {
        if ("tcp".equalsIgnoreCase(socketType)) {
            return 0;
        }
        if ("ssl".equalsIgnoreCase(socketType)) {
            return 1;
        }
        if ("ssl.iaik".equalsIgnoreCase(socketType)) {
            return 1;
        }
        if ("http".equalsIgnoreCase(socketType)) {
            return 2;
        }
        if ("https".equalsIgnoreCase(socketType)) {
            return 3;
        }
        if ("mqtt".equalsIgnoreCase(socketType)) {
            return 4;
        }
        if ("mqtts".equalsIgnoreCase(socketType)) {
            return 5;
        }
        throw new ESocketConfigException(prAccessor.getString("STR006") + socketType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressSocketFactory getFactory(int socketType) throws ESocketConfigException {
        if (s_socketFactoryList[socketType] == null) {
            Object object = s_mutex;
            synchronized (object) {
                if (s_socketFactoryList[socketType] == null) {
                    ProgressSocketFactory.s_socketFactoryList[socketType] = ProgressSocketFactory.getFactoryImpl(socketType);
                }
            }
        }
        return s_socketFactoryList[socketType];
    }

    private static ProgressSocketFactory getFactoryImpl(int socketType) throws ESocketConfigException {
        String className = "progress.message.net.";
        ProgressSocketFactory factoryImpl = null;
        switch (socketType) {
            case 0: {
                if (SessionConfig.USE_EVS_IO) {
                    className = className + "tcp.evs.ProgressEvsTcpSocketFactory";
                    break;
                }
                if (!m_nioAvailable || SessionConfig.DISABLE_NIO) {
                    className = className + "tcp.ProgressTcpSocketFactory";
                    break;
                }
                className = className + "tcp.channel.ProgressTcpChannelFactory";
                break;
            }
            case 1: {
                className = className + "ssl.ProgressSslSocketFactory";
                break;
            }
            case 2: {
                if (SessionConfig.USE_EVS_HTTP) {
                    className = className + "http.evs.ProgressEvsHTTPSocketFactory";
                    break;
                }
                className = className + "http.ProgressHttpSocketFactory";
                break;
            }
            case 3: {
                className = className + "https.ProgressHttpsSocketFactory";
                break;
            }
            case 4: {
                className = className + "mqtt.ProgressMqttSocketFactory";
                break;
            }
            case 5: {
                className = className + "mqtt.ProgressMqttsSocketFactory";
                break;
            }
            default: {
                throw new ESocketConfigException(prAccessor.getString("STR007") + socketType);
            }
        }
        try {
            Class<?> socketFactoryClass = Class.forName(className);
            factoryImpl = (ProgressSocketFactory)socketFactoryClass.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ESocketConfigException(prAccessor.getString("STR008") + e);
        }
        return factoryImpl;
    }

    public ProgressSocket createProgressSocket(Principal principal, String host, int port, Object properties, IHttpProxyConfig pConfig, long timeout) throws IOException {
        ProgressSocket socket = null;
        if (timeout == 0L) {
            socket = this.createProgressSocket(principal, host, port, properties, pConfig);
        } else {
            SocketConnectHelper sch = new SocketConnectHelper(this, principal, host, port, properties, pConfig, timeout);
            socket = sch.openSocket();
        }
        ProgressInetAddress.showCreatedSocketDiagnostic("ProgressSocketFactory", socket);
        return socket;
    }

    public abstract ProgressSocket createProgressSocket(Principal var1, String var2, int var3, Object var4, IHttpProxyConfig var5) throws IOException;

    public ProgressServerSocket createProgressServerSocket(Principal principal, int port, int backlog, InetAddress bindAddr, Properties properties) {
        ProgressServerSocket ssocket = null;
        try {
            ssocket = this.createProgressServerSocket(principal, port, backlog, bindAddr == null ? null : new ProgressInetAddress(bindAddr), properties);
        }
        catch (IOException e) {
            SessionConfig.logMessage(prAccessor.getString("STR008"), e, SessionConfig.SEVERE);
        }
        return ssocket;
    }

    public abstract ProgressServerSocket createProgressServerSocket(Principal var1, int var2, int var3, ProgressInetAddress var4, Properties var5) throws IOException;

    static {
        try {
            Class.forName("java.nio.channels.SocketChannel");
            Class.forName("progress.message.net.tcp.channel.ProgressTcpChannelFactory");
        }
        catch (Throwable thrown) {
            m_nioAvailable = false;
        }
        s_socketFactoryList = new ProgressSocketFactory[6];
    }
}

