/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.AcknowledgementRange;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.IElement;
import com.sonicsw.ws.rm.protocol.Identifier;
import com.sonicsw.ws.rm.protocol.Nack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;

public class SequenceAcknowledgement
extends MessageElement
implements IElement {
    private Constants RMConstants;
    private MessageElement seqAck;
    private List ackRanges;
    private List nackList;
    private Identifier identifier;

    public SequenceAcknowledgement(Constants constants) {
        this.RMConstants = constants;
        this.ackRanges = new LinkedList();
        this.nackList = new LinkedList();
        this.seqAck = new MessageElement(this.RMConstants.getNSURI(), "SequenceAcknowledgement");
    }

    public SequenceAcknowledgement(SOAPHeaderElement headerElement) {
        this.seqAck = headerElement;
        this.ackRanges = new LinkedList();
        this.nackList = new LinkedList();
        Iterator iterator = headerElement.getChildElements();
        String ns = headerElement.getNamespaceURI("wsrm");
        this.RMConstants = ns != null && ns.equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm") ? Constants.MAR2004_CONSTANTS : Constants.FEB2005_CONSTANTS;
        while (iterator.hasNext()) {
            MessageElement childElement = (MessageElement)iterator.next();
            if (childElement.getName().equals("Identifier")) {
                this.identifier = new Identifier(childElement);
            }
            if (childElement.getName().equals("AcknowledgementRange")) {
                AcknowledgementRange ackRange = new AcknowledgementRange(childElement);
                this.ackRanges.add(ackRange);
            }
            if (!childElement.getName().equals("Nack")) continue;
            Nack nack = new Nack(childElement);
            this.nackList.add(nack);
        }
    }

    public SequenceAcknowledgement() {
    }

    @Override
    public MessageElement getSoapElement() throws SOAPException {
        this.seqAck.detachAllChildren();
        for (MessageElement element : this.ackRanges) {
            this.seqAck.addChildElement((SOAPElement)element);
        }
        for (MessageElement element : this.nackList) {
            this.seqAck.addChildElement((SOAPElement)element);
        }
        this.seqAck.addChildElement((SOAPElement)this.identifier.getSoapElement());
        return this.seqAck;
    }

    public SOAPEnvelope toSOAPEnvelope(SOAPEnvelope envelope) throws SOAPException {
        SOAPEnvelope env = envelope;
        if (env.getHeader() == null) {
            env.addHeader();
        }
        Name name = env.createName("SequenceAcknowledgement", "wsrm", this.RMConstants.getNSURI());
        SOAPHeaderElement headerElement = (SOAPHeaderElement)env.getHeader().addHeaderElement(name);
        headerElement.setActor(null);
        headerElement.setMustUnderstand(false);
        if (this.identifier != null) {
            this.identifier.toSOAPEnvelope((MessageElement)headerElement);
        }
        for (AcknowledgementRange ackRange : this.ackRanges) {
            ackRange.toSOAPEnvelope((MessageElement)headerElement);
        }
        for (Nack nack : this.nackList) {
            nack.toSOAPEnvelope((MessageElement)headerElement);
        }
        if (this.nackList.size() == 0 && this.ackRanges.isEmpty()) {
            Nack dummyNack = new Nack(this.RMConstants);
            dummyNack.setNotAckNum(1L);
            dummyNack.toSOAPEnvelope((MessageElement)headerElement);
        }
        return env;
    }

    @Override
    public void addChildElement(MessageElement element) throws SOAPException {
        this.seqAck.addChildElement((SOAPElement)element);
    }

    public List getAckRanges() {
        return this.ackRanges;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List getNackList() {
        return this.nackList;
    }

    public AcknowledgementRange addAckRanges(AcknowledgementRange ackRange) {
        this.ackRanges.add(ackRange);
        return ackRange;
    }

    public Nack addNackRanges(Nack nack) {
        this.nackList.add(nack);
        return nack;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setAckRanges(List list) {
        this.ackRanges = list;
    }

    public String toString() {
        StringBuffer sb1 = new StringBuffer();
        Iterator iterator = this.ackRanges.iterator();
        while (iterator.hasNext()) {
            this.appendSeparatorAndData(iterator, sb1);
        }
        StringBuffer sb2 = new StringBuffer();
        iterator = this.nackList.iterator();
        while (iterator.hasNext()) {
            this.appendSeparatorAndData(iterator, sb2);
        }
        return "Acks=" + sb1.toString() + " Nacks=" + sb2.toString();
    }

    private void appendSeparatorAndData(Iterator iterator, StringBuffer sb2) {
        AcknowledgementRange ackRange = (AcknowledgementRange)iterator.next();
        if (sb2.length() > 0) {
            sb2.append(",");
        }
        sb2.append(ackRange);
    }
}

