/*
 * Decompiled with CFR 0.152.
 */
package progress.message.api.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class BaseObjectFactoryByClassName<E> {
    private Class<E> defaultImplementationClass;
    private Constructor<E> constructor;

    public Class<E> getDefaultImplementationClass() {
        if (this.defaultImplementationClass == null) {
            try {
                this.defaultImplementationClass = Class.forName(this.getDefaultImplementationClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.defaultImplementationClass;
    }

    public abstract String getDefaultImplementationClassName();

    public E createInstance() {
        if (this.constructor == null) {
            try {
                this.constructor = this.getDefaultImplementationClass().getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

