/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import progress.message.client.EUnsupportedMgramException;
import progress.message.client.prAccessor;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.v26.MgramCreator;
import progress.message.resources.prMessageFormat;
import progress.message.util.AutoVec;
import progress.message.xa.XidImpl;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.ISubject;

public class MgramFactory {
    private MgramCreator m_mgramCreator = new MgramCreator();

    private MgramFactory() {
    }

    public static MgramFactory getMgramFactory() {
        return MgramFactoryLazyHolder.FACTORY_SINGLETON;
    }

    public static IMgramConverter getMgramConverter(int version) throws EUnsupportedMgramException {
        if (version == 26) {
            return new MgramCreator();
        }
        IMgramConverter converter = null;
        try {
            Class<?> converterClass = Class.forName("progress.message.msg.v26.MgramConverter" + version);
            converter = (IMgramConverter)converterClass.newInstance();
        }
        catch (Exception e) {
            String msgFmt = prAccessor.getString("UNSUPPORTED_MGRAM");
            Object[] mObj = new String[]{"" + version};
            String msg = prMessageFormat.format(msgFmt, mObj);
            throw new EUnsupportedMgramException(msg);
        }
        return converter;
    }

    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.m_mgramCreator.createMgram(is);
    }

    public IMgram createMgram(boolean initialize) {
        return this.m_mgramCreator.createMgram(initialize);
    }

    public IMgram createMgram(byte[] data) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return this.m_mgramCreator.createMgram(data);
    }

    public IMgram buildAck(long tracking, short err, int channel) {
        return MgramCreator.buildAck(tracking, -1L, err, channel);
    }

    public IMgram buildAck(long msgTracking, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        return MgramCreator.buildAck(msgTracking, -1L, err, guaranteed, ackTracking, txn, tid, channel);
    }

    public IMgram buildWindowAck(long receiptTracking, long storageTracking, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        return MgramCreator.buildWindowAck(receiptTracking, storageTracking, err, guaranteed, ackTracking, txn, tid, channel);
    }

    public IMgram buildAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        return MgramCreator.buildAck(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, channel);
    }

    public IMgram buildQAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        return MgramCreator.buildQAck(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, channel);
    }

    public IMgram buildSplitDeliveryAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel, short subjectTracking) {
        return MgramCreator.buildSplitDeliveryAck(msgTracking, clientID, err, guaranteed, ackTracking, txn, tid, channel, subjectTracking);
    }

    public IMgram buildAckList() {
        MgramFactory mgramFactory = this;
        return mgramFactory.m_mgramCreator.buildAckList();
    }

    public IMgram buildQueueGetRequestMgram(boolean secure, int channel, short receiveType, int prefetchCount, ISubject subject, boolean remoteGet) {
        return MgramCreator.buildQueueGetRequestMgram(secure, channel, receiveType, prefetchCount, subject, remoteGet);
    }

    public IMgram buildQueueOpenRemoteReceiverMgram(boolean secure, int channel, ISubject subject, String msgSelector) {
        return MgramCreator.buildQueueOpenRemoteReceiverMgram(secure, channel, subject, msgSelector);
    }

    public IMgram buildQueueCloseRemoteReceiverMgram(boolean secure, int channel, ISubject subject, String msgSelector) {
        return MgramCreator.buildQueueCloseRemoteReceiverMgram(secure, channel, subject, msgSelector);
    }

    public IMgram buildPingRequest(byte[] payload, int channel) {
        return MgramCreator.buildPingRequest(payload, channel);
    }

    public IMgram buildPingReply(IMgram m) {
        return MgramCreator.buildPingReply(m);
    }

    public IMgram buildDisconnectRequest(int channel, boolean forceDisconnect) {
        return MgramCreator.buildDisconnectRequest(channel, forceDisconnect);
    }

    public IMgram buildDiagnosticOpMgram(short diagOp, int channel) {
        return MgramCreator.buildDiagnosticOpMgram(diagOp, channel);
    }

    public IMgram buildFlowControlMgram(byte minPriority, int channel) {
        return MgramCreator.buildFlowControlMgram(minPriority, channel);
    }

    public IMgram buildVersionMgram(int channel, byte version) {
        return MgramCreator.buildVersionMgram(channel, version);
    }

    public IMgram buildVersionMgram(int channel, byte version, byte sessionVersion) {
        return MgramCreator.buildVersionMgram(channel, version, sessionVersion);
    }

    public IMgram buildVersionMgram(int channel) {
        return this.buildVersionMgram(channel, (byte)26);
    }

    public IMgram buildVersionMgram(int channel, byte version, byte sessionVersion, byte streamVersion, byte streamFlags) {
        return MgramCreator.buildVersionMgram(channel, version, sessionVersion, streamVersion, streamFlags);
    }

    public IMgram buildConnectMgram(byte[] payload, int channel) {
        return MgramCreator.buildConnectMgram(payload, channel);
    }

    public IMgram buildErrorMgram(int errcode, int errinfo, IMgram m, int channel) {
        return MgramCreator.buildErrorMgram(errcode, errinfo, m, channel);
    }

    public IMgram buildBeginTxnRequest(boolean xo, int tracking, long clientId, int channel) {
        return MgramCreator.buildBeginTxnRequest(xo, tracking, clientId, channel);
    }

    public IMgram buildAbortTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildAbortTxnRequest(xo, chained, tid, tracking, clientId, channel);
    }

    public IMgram buildTxnRequest(boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildTxnRequest(chained, tid, tracking, clientId, channel);
    }

    public IMgram buildCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        return MgramCreator.buildCommitTxnRequest(xo, chained, tid, tracking, clientId, channel);
    }

    public IMgram buildNoDupCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan) {
        return MgramCreator.buildNoDupCommitTxnRequest(xo, chained, tid, tracking, clientId, channel, transactionId, lifespan);
    }

    public IMgram buildNoDupChannelCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan, int channelStatus, String channelID) {
        return MgramCreator.buildNoDupChannelCommitTxnRequest(xo, chained, tid, tracking, clientId, channel, transactionId, lifespan, channelStatus, channelID);
    }

    public IMgram buildNoDupChannelDeleteTxnRequest(boolean xo, int tracking, long clientId, int channel, String transactionId, String channelID) {
        return this.m_mgramCreator.buildNoDupChannelDeleteTxnRequest(xo, tracking, clientId, channel, transactionId, channelID);
    }

    public IMgram buildNoDupChannelUpdateTxnRequest(boolean xo, int tracking, long clientId, int channel, String transactionId, long lifespan, int channelStatus, String channelID) {
        return this.m_mgramCreator.buildNoDupChannelUpdateTxnRequest(xo, tracking, clientId, channel, transactionId, lifespan, channelStatus, channelID);
    }

    public IMgram buildTxnReply(short status, int nextTid, int tracking, int channel) {
        return MgramCreator.buildTxnReply(status, nextTid, tracking, channel);
    }

    public IMgram buildTxnActiveReply(long ttl, int nextTid, int tracking, int channel) {
        return MgramCreator.buildTxnActiveReply(ttl, nextTid, tracking, channel);
    }

    public IMgram buildExtendedTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, XidImpl xid, int op) {
        return this.m_mgramCreator.buildExtendedTxnRequest(xo, chained, tid, tracking, clientId, channel, xid, op);
    }

    public IMgram buildTxnBatchMgram(IMgram firstMgram, int tid) {
        return MgramCreator.buildTxnBatchMgram(firstMgram, tid);
    }

    public IMgram buildBatchMgram(IMgram firstMgram) {
        return MgramCreator.buildBatchMgram(firstMgram);
    }

    public IMgram buildDisconnectReply(int channel, boolean reject) {
        return MgramCreator.buildDisconnectReply(channel, reject);
    }

    public IMgram buildGRConvertMgram(long code, long clientid, int channel, long token) {
        return MgramCreator.buildGRConvertMgram(code, clientid, channel, token);
    }

    public IMgram buildIBConvertMgram(long token, int channel) {
        return MgramCreator.buildIBConvertMgram(token, channel);
    }

    public IMgram buildFailoverStatusNotification(int state, String[] localURLs, String[] standbyURLs) {
        return this.m_mgramCreator.buildFailoverStatusNotification(state, localURLs, standbyURLs);
    }

    public List buildIDRMgramList(boolean isRequest, boolean needsResponseOnLast, boolean senderHasDoubt, List dnrPubSub, List dnrPTP, List ugaPubSub, List ugaPTP, List preq, List prep) {
        return MgramCreator.buildIDRMgramList(isRequest, needsResponseOnLast, senderHasDoubt, dnrPubSub, dnrPTP, ugaPubSub, ugaPTP, preq, prep);
    }

    public IMgram buildIDRAckMgram() {
        MgramFactory mgramFactory = this;
        return mgramFactory.m_mgramCreator.buildIDRAckMgram();
    }

    public IMgram buildConnectionSyncMgram(AutoVec av) {
        return MgramCreator.buildConnectionSyncMgram(av);
    }

    public IMgram buildFirstMessageNotification(long clientID) {
        return MgramCreator.buildFirstMessageNotification(clientID);
    }

    public IMgram buildDeliveryFinished(long clientID) {
        return MgramCreator.buildDeliveryFinished(clientID);
    }

    public IMgram buildSingleTargetMessage(long clientID, IMgram msg) {
        return MgramCreator.buildSingleTargetMessage(clientID, msg);
    }

    public IMgram buildRejectionAckOp(IMgram m, short errorCode, String errorMsg, int channel) {
        return MgramCreator.buildRejectionAck(m, errorCode, errorMsg, channel);
    }

    public IMgram buildLBSTargetMessage(IMgram m, boolean withLookup) {
        return MgramCreator.buildLBSTargetMessage(m, withLookup);
    }

    public IMgram buildLBSTargetMessage(IMgram m, int type, byte[] body, int bodyLength) {
        return MgramCreator.buildLBSTargetMessage(m, type, body, bodyLength);
    }

    public IMgram buildLastMessageNotification(long clientID) {
        return MgramCreator.buildLastMessageNotification(clientID);
    }

    public IMgram buildTxnEOFMarker() {
        MgramFactory mgramFactory = this;
        return mgramFactory.m_mgramCreator.buildTxnEOFMarker();
    }

    public IMgram buildTxnSavePointMarker() {
        MgramFactory mgramFactory = this;
        return mgramFactory.m_mgramCreator.buildTxnSavePointMarker();
    }

    public IMgram buildRemoteRestorePhasesDoneMgram(long clientID) {
        return MgramCreator.buildRemoteRestorePhasesDoneMgram(clientID);
    }

    public IMgram buildGuarFormatMgram(IMgram mgram) {
        return MgramCreator.buildGuarFormatMgram(mgram);
    }

    public IMgram buildResumeMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        return MgramCreator.buildResumeMgram(channel, utfDestination, utfLength, routing);
    }

    public IMgram buildBlockMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        return MgramCreator.buildBlockMgram(channel, utfDestination, utfLength, routing);
    }

    public final IMgram buildPTPFlowControlMgram(int channel, String routing, ISubject subject, boolean isPubSub, byte subType) {
        return MgramCreator.buildPTPFlowControlMgram(channel, routing, subject, isPubSub, subType);
    }

    public IMgram buildNack(long tracking, int channel) {
        return MgramCreator.buildNack(tracking, channel);
    }

    public IMgram buildRouteRequest(int channel, int requestType, long requestTime, int infoCount, byte[] routeInfo) {
        return MgramCreator.buildRouteRequest(channel, requestType, requestTime, infoCount, routeInfo);
    }

    public IMgram buildStateEventMgram(IStateEvent event, boolean tteTTLConvert) {
        return MgramCreator.buildStateEventMgram(event, tteTTLConvert);
    }

    public IMgram buildDatabaseMgram(ISaverOp op) {
        return MgramCreator.buildDatabaseMgram(op);
    }

    public IMgram buildReplicatedMgram(IMgram replicatedMgram, boolean tteTTLConvert) {
        return MgramCreator.buildReplicatedMgram(replicatedMgram, tteTTLConvert);
    }

    public IMgram buildOperationMgram(int operationType) {
        return MgramCreator.buildOperationMgram(operationType);
    }

    public ISidebandData buildSidebandData() {
        MgramFactory mgramFactory = this;
        return mgramFactory.m_mgramCreator.buildSidebandData();
    }

    private static class MgramFactoryLazyHolder {
        private static MgramFactory FACTORY_SINGLETON = new MgramFactory();

        private MgramFactoryLazyHolder() {
        }
    }
}

