/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.SecureDynamicHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public final class DefaultDynamicHeader
extends DynamicHeader {
    static final int s_dhMemSize = MemoryUtil.estimateBaseSize(DefaultDynamicHeader.class);
    private int m_messageLen = 0;
    private static final int DEFAULT_DYNAMIC_HEADER_LEN = 4;
    private Subject m_subject = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            if (this.m_subject != null) {
                log.println("Subject: " + this.m_subject.debugString());
            }
            log.println("Message Length: " + this.getMessageLength());
        }
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        return new DefaultDynamicHeader(this, m);
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        return new DefaultDynamicHeader(this, m);
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        return new DefaultDynamicHeader(this, m);
    }

    @Override
    public void protect() {
    }

    public DefaultDynamicHeader(Mgram m) {
        super(m);
    }

    private DefaultDynamicHeader(DefaultDynamicHeader dh, Mgram m) {
        super(dh, m);
        this.m_messageLen = dh.m_messageLen;
        this.m_subject = dh.m_subject;
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is, IMessageProtection mp, ClientSecurityContext ctx) throws IOException {
        if (this.m_mgram.getSubjectFormat() == 4) {
            this.m_subject = new Subject();
            this.m_subject.initFromStream(is);
        }
        this.m_messageLen = StreamUtil.readInt(is);
        this.m_mgram.setStatus(2);
    }

    @Override
    public int getMessageLength() {
        int length;
        if (this.m_mgram == null || this.m_mgram.getStatus() < 3) {
            return this.m_messageLen;
        }
        this.m_messageLen = length = this.m_mgram.getPayloadLength();
        return this.m_messageLen;
    }

    @Override
    public byte[] toByteArray() {
        if (this.m_subject == null) {
            byte[] result = new byte[4];
            if (this.m_mgram != null) {
                ArrayUtil.writeInt(result, 0, this.m_mgram.getPayloadLength());
            } else {
                ArrayUtil.writeInt(result, 0, this.m_messageLen);
            }
            return result;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4 + this.m_subject.getSerializedLength());
        try {
            this.writeToStream(baos, null);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            SessionConfig.logMessage("Error writing message.", ex, SessionConfig.SEVERE);
            throw new EAssertFailure(ex.getMessage());
        }
    }

    @Override
    int length() {
        return 4 + (this.m_subject != null ? this.m_subject.getSerializedLength() : 0);
    }

    @Override
    public void setMessageLength(int length) {
        this.m_messageLen = length;
    }

    public static void setMessageLength(int length, byte[] buffer) {
        ArrayUtil.writeInt(buffer, 0, length);
    }

    @Override
    int memoryLength() {
        return s_dhMemSize + (this.m_subject != null ? this.m_subject.memoryLength() : 0);
    }

    @Override
    void writeToStream(OutputStream os, MgramDeliveryContext ctx) throws IOException {
        if (this.m_mgram.getSubjectFormat() == 4) {
            if (ctx == null) {
                this.m_subject.writeToStream(os);
            } else {
                ISubjectFilter filter = ctx.subjectFilter;
                ISubject s = this.m_subject;
                if (filter != null) {
                    s = filter.filter(s);
                }
                s.writeToStream(os);
            }
        }
        StreamUtil.writeInt(this.getMessageLength(), os);
    }

    @Override
    void writeToStream(OutputStream os, IMessageProtection m_mp, MgramDeliveryContext ctx) throws IOException {
        this.writeToStream(os, ctx);
    }

    @Override
    void syncDynamicHeader() {
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        SecureDynamicHeader sdh = new SecureDynamicHeader(mp, this);
        return sdh;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this;
    }

    @Override
    public void setSubject(ISubject s) {
        this.m_subject = (Subject)s;
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }
}

