/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.client.EIntegrityCompromised;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.Mgram;
import progress.message.util.ArrayUtil;
import progress.message.util.EnhancedByteArrayOutputStream;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISubject;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

final class SecureDynamicHeader
extends DynamicHeader {
    private byte m_securityAttributeByte = SecurityLogic.getQueryAttribs();
    private int m_messageLenPad = 0;
    private IMessageProtection m_mp = null;
    private int m_dbSize;
    private byte[] m_messageKey = null;
    private byte[] m_digest = null;
    private byte[] m_db = null;
    private DynamicHeader m_dynamicHeader = null;
    private static final boolean DEBUG = false;
    private boolean m_dbDirty = true;
    static final int s_dhMemSize = MemoryUtil.estimateBaseSize(SecureDynamicHeader.class);
    private static int s_dynamicHeaderOverhead;
    private boolean m_isProtected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            this.printMgramSecurityInfo();
            this.m_dynamicHeader.dump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMgramSecurityInfo() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Security Attributes: ");
            if (this.m_mgram.isSecure()) {
                SecurityLogic.debugPrintPrivate(this.m_securityAttributeByte);
            } else {
                log.println("NONE");
            }
        }
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        if (!this.m_dbDirty && this.m_db != null) {
            sdh.m_db = new byte[this.m_dbSize];
            System.arraycopy(this.m_db, 0, sdh.m_db, 0, this.m_dbSize);
        }
        if (this.m_messageKey != null) {
            sdh.m_messageKey = new byte[this.m_messageKey.length];
            System.arraycopy(this.m_messageKey, 0, sdh.m_messageKey, 0, this.m_messageKey.length);
        }
        if (this.m_digest != null) {
            sdh.m_digest = new byte[this.m_digest.length];
            System.arraycopy(this.m_digest, 0, sdh.m_digest, 0, this.m_digest.length);
        }
        return sdh;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.clone(m);
        return sdh;
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.m_isProtected = true;
        SecureDynamicHeader sdh = (SecureDynamicHeader)super.clone(m);
        sdh.m_dynamicHeader = (DynamicHeader)this.m_dynamicHeader.protectedClone(m);
        return sdh;
    }

    @Override
    public void protect() {
        this.m_isProtected = true;
    }

    public void unprotectDynamicHeader() {
        if (this.m_isProtected) {
            if (!this.m_dbDirty && this.m_db != null) {
                byte[] db = new byte[this.m_dbSize];
                System.arraycopy(this.m_db, 0, db, 0, this.m_dbSize);
                this.m_db = db;
            } else {
                this.m_db = null;
            }
            if (this.m_messageKey != null) {
                byte[] messageKey = new byte[this.m_messageKey.length];
                System.arraycopy(this.m_messageKey, 0, messageKey, 0, messageKey.length);
                this.m_messageKey = messageKey;
            }
            if (this.m_digest != null) {
                byte[] digest = new byte[this.m_digest.length];
                System.arraycopy(this.m_digest, 0, digest, 0, this.m_digest.length);
                this.m_digest = digest;
            }
            this.m_isProtected = false;
        }
    }

    SecureDynamicHeader(IMessageProtection mp, DynamicHeader dn) {
        super(dn.m_mgram);
        this.m_mp = mp;
        this.m_dynamicHeader = dn;
        this.m_dbDirty = true;
    }

    SecureDynamicHeader(Mgram m, IMessageProtection mp) throws IOException {
        super(m);
        this.m_dynamicHeader = new DefaultDynamicHeader(m);
        this.m_mp = mp;
    }

    private SecureDynamicHeader() throws IOException {
        super(null);
        this.m_dynamicHeader = new DefaultDynamicHeader(null);
    }

    public void setMessageProtection(IMessageProtection mp) {
        this.m_mp = mp;
    }

    @Override
    public int getMessageLength() {
        return this.m_dynamicHeader.getMessageLength();
    }

    @Override
    public int getMessagePad() {
        return this.m_messageLenPad;
    }

    @Override
    IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    @Override
    public byte getSecurity() {
        return this.m_securityAttributeByte;
    }

    @Override
    public byte[] getMessageKey() {
        return this.m_messageKey;
    }

    @Override
    public byte[] getDigest() {
        return this.m_digest;
    }

    @Override
    public void setMessageDigest(byte[] digest) {
        this.unprotectDynamicHeader();
        this.m_digest = digest;
        this.m_dbDirty = true;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(null);
    }

    @Override
    byte[] toByteArray(IMessageProtection mp) {
        this.sync();
        byte[] result = new byte[this.m_dbSize];
        System.arraycopy(this.m_db, 0, result, 0, this.m_dbSize);
        int messageLength = this.m_dynamicHeader.getMessageLength();
        ArrayUtil.writeInt(result, this.m_dbSize - 4, messageLength);
        return result;
    }

    @Override
    int length() {
        this.sync();
        return this.m_dbSize;
    }

    @Override
    int memoryLength() {
        return s_dhMemSize + this.length();
    }

    @Override
    void saveMemory() {
        this.m_db = null;
        this.m_dbDirty = true;
        this.m_dbSize = 0;
    }

    @Override
    void setSecurityAttributeByte(byte value) {
        if (this.m_securityAttributeByte != value) {
            this.m_securityAttributeByte = value;
            this.m_dbDirty = true;
        }
    }

    @Override
    public void setMessageKey(byte[] messageKey) {
        this.unprotectDynamicHeader();
        this.m_messageKey = messageKey;
        this.m_dbDirty = true;
    }

    @Override
    void setMessagePad(int pad) {
        this.m_messageLenPad = pad;
    }

    @Override
    void syncDynamicHeader() {
        if (this.m_dbDirty) {
            this.syncInternalData();
        }
    }

    private void syncInternalData() {
        int dhLength = this.m_dynamicHeader.length();
        EnhancedByteArrayOutputStream bos = new EnhancedByteArrayOutputStream(s_dynamicHeaderOverhead + dhLength);
        Object result = null;
        try {
            this.writeToStream(bos, this.m_mp, null);
            bos.flush();
            this.m_dbDirty = false;
            this.m_db = bos.getBuffer();
            this.m_dbSize = bos.getBufferSize();
            int overhead = this.m_dbSize - dhLength;
            if (overhead > s_dynamicHeaderOverhead) {
                s_dynamicHeaderOverhead = overhead * 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    void writeToStream(OutputStream os, MgramDeliveryContext ctx) throws IOException {
        this.writeToStream(os, null, ctx);
    }

    @Override
    void writeToStream(OutputStream os, IMessageProtection mp, MgramDeliveryContext ctx) throws IOException {
        this.writeToStream(os, mp, null, null, ctx);
    }

    @Override
    public void writeToStream(OutputStream os, IMessageProtection mp, byte[] encyptedMessageKey, byte[] digest, MgramDeliveryContext ctx) throws IOException {
        boolean needsSubjectFiltration = false;
        boolean needsWireProtection = false;
        if (ctx != null) {
            needsWireProtection = this.needsWireProtection();
            boolean bl = needsSubjectFiltration = ctx.subjectFilter != null;
        }
        if (this.m_dbDirty || encyptedMessageKey != null || digest != null || needsWireProtection || needsSubjectFiltration) {
            if (needsWireProtection) {
                os.write(this.m_securityAttributeByte | 0x40);
            } else {
                os.write(this.m_securityAttributeByte);
            }
            if (encyptedMessageKey != null) {
                StreamUtil.writeShort((short)encyptedMessageKey.length, os);
                os.write(encyptedMessageKey);
            } else if (this.m_messageKey != null) {
                StreamUtil.writeShort((short)this.m_messageKey.length, os);
                os.write(this.m_messageKey);
            } else {
                if (this.m_mp == null) {
                    try {
                        this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (ClassCastException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                }
                StreamUtil.writeShort((short)this.m_mp.getSecretKeyLength(), os);
                byte[] dummyMKey = new byte[this.m_mp.getSecretKeyLength()];
                os.write(dummyMKey);
            }
            if (digest != null) {
                StreamUtil.writeShort((short)digest.length, os);
                os.write(digest);
            } else if (this.m_digest != null) {
                StreamUtil.writeShort((short)this.m_digest.length, os);
                os.write(this.m_digest);
            } else {
                StreamUtil.writeShort((short)0, os);
            }
            if (needsWireProtection) {
                EnhancedByteArrayOutputStream baos = new EnhancedByteArrayOutputStream(this.m_dynamicHeader.length());
                this.m_dynamicHeader.writeToStream(baos, ctx);
                byte[] dhBuffer = baos.getBuffer();
                int dhLength = baos.getBufferSize();
                if (SecurityLogic.isMKeyEncryption(this.m_securityAttributeByte) || SecurityLogic.isSKeyEncryption(this.m_securityAttributeByte)) {
                    byte[] encrypted = new byte[mp.getOutputSize(dhLength)];
                    System.arraycopy(dhBuffer, 0, encrypted, 0, dhLength);
                    mp.encryptWithSessionKey(encrypted, 0, encrypted.length, encrypted, 0);
                    dhBuffer = encrypted;
                    dhLength = encrypted.length;
                }
                if (SecurityLogic.isMKeyDigest(this.m_securityAttributeByte) || SecurityLogic.isSKeyDigest(this.m_securityAttributeByte)) {
                    byte[] key = ctx.csc.getDigestKey();
                    byte[] dhDigest = new byte[mp.getHashSize()];
                    mp.mac(key, 0, key.length, dhBuffer, 0, dhLength, dhDigest, 0, dhDigest.length);
                    os.write(dhDigest);
                }
                StreamUtil.writeInt(dhLength, os);
                os.write(dhBuffer, 0, dhLength);
            } else {
                this.m_dynamicHeader.writeToStream(os, ctx);
            }
        } else {
            int messageLength = this.m_dynamicHeader.getMessageLength();
            os.write(this.m_db, 0, this.m_dbSize - 4);
            StreamUtil.writeInt(messageLength, os);
            return;
        }
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is, IMessageProtection mp, ClientSecurityContext csc) throws IOException {
        short messageKeyLen;
        boolean wireProtected;
        this.m_securityAttributeByte = StreamUtil.readByte(is);
        boolean bl = wireProtected = (this.m_securityAttributeByte & 0x40) > 0;
        if (wireProtected) {
            this.m_securityAttributeByte = (byte)(this.m_securityAttributeByte & 0xFFFFFFBF);
        }
        if ((messageKeyLen = StreamUtil.readShort(is)) > 0) {
            this.m_messageKey = new byte[messageKeyLen];
            StreamUtil.readBytes(is, this.m_messageKey, 0, messageKeyLen);
        } else {
            this.m_messageKey = null;
        }
        short digestLen = StreamUtil.readShort(is);
        if (digestLen > 0) {
            this.m_digest = new byte[digestLen];
            StreamUtil.readBytes(is, this.m_digest, 0, digestLen);
        } else {
            this.m_digest = null;
        }
        if (wireProtected) {
            byte[] key;
            if (csc == null || mp == null) {
                throw new EIntegrityCompromised("Unexpected Secure Dynamic Header");
            }
            byte[] dhDigest = null;
            if (SecurityLogic.isMKeyDigest(this.m_securityAttributeByte) || SecurityLogic.isSKeyDigest(this.m_securityAttributeByte)) {
                byte[] key2 = csc.getDigestKey();
                dhDigest = new byte[mp.getHashSize()];
                StreamUtil.readBytes(is, dhDigest, 0, dhDigest.length);
            }
            int dhLength = StreamUtil.readInt(is);
            if (SessionConfig.MAX_MSG_SIZE > 0 && dhLength > SessionConfig.MAX_MSG_SIZE) {
                throw new EIntegrityCompromised();
            }
            byte[] dhBuffer = new byte[dhLength];
            StreamUtil.readBytes(is, dhBuffer, 0, dhBuffer.length);
            if (dhDigest != null && !mp.verifyMac(key = csc.getDigestKey(), 0, key.length, dhBuffer, 0, dhLength, dhDigest, 0, dhDigest.length)) {
                throw new EIntegrityCompromised();
            }
            if (SecurityLogic.isMKeyEncryption(this.m_securityAttributeByte) || SecurityLogic.isSKeyEncryption(this.m_securityAttributeByte)) {
                mp.decryptWithSessionKey(dhBuffer, 0, dhLength, dhBuffer, 0);
            }
            this.m_dynamicHeader.initDynamicHeaderFromStream(new ByteArrayInputStream(dhBuffer), mp, csc);
        } else {
            this.m_dynamicHeader.initDynamicHeaderFromStream(is, mp, csc);
        }
        if (this.m_mp != null) {
            int cipherTextSize = this.m_mp.getOutputSize(this.m_dynamicHeader.getMessageLength());
            this.m_messageLenPad = cipherTextSize - this.m_dynamicHeader.getMessageLength();
        }
        this.m_mgram.setStatus(2);
    }

    @Override
    boolean isDirty() {
        return this.m_dbDirty || this.m_dynamicHeader.isDirty();
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        return this;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this.m_dynamicHeader;
    }

    @Override
    public void setSubject(ISubject s) {
        this.m_dynamicHeader.setSubject(s);
        this.m_dbDirty = true;
    }

    @Override
    public ISubject getSubject() {
        return this.m_dynamicHeader.getSubject();
    }

    private boolean needsWireProtection() {
        if (this.getSubject() != null) {
            return !SecurityLogic.isNoProtection(this.m_securityAttributeByte);
        }
        return false;
    }
}

