/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETimeout;
import progress.message.msg.IMgram;
import progress.message.zclient.EConnectionClosing;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMgramEnqueuedToSendListener;
import progress.message.zclient.Job;
import progress.message.zclient.Publication;
import progress.message.zclient.SessionConfig;

public class Request
extends Job
implements IMgramEnqueuedToSendListener {
    private Envelope m_reply;
    private IMgram m_replyMgram;
    private IMgram m_requestMgram;
    private IJobResolver m_resolver;
    private Envelope m_request;
    private Publication m_guarPub;
    private boolean m_pendingResponse;
    private boolean m_xonce;

    Request() {
        this(null, null);
    }

    Request(Envelope request, IJobResolver resolver) {
        this.m_resolver = resolver;
        this.m_request = request;
        if (this.m_request != null) {
            this.m_requestMgram = this.m_request.getMgram();
        }
        this.m_status = 3;
        this.debugName("Request");
    }

    @Override
    public synchronized void resolve() {
        if (this.m_resolver != null) {
            this.m_resolver.resolveJob(this);
            if (this.DEBUG) {
                this.debug("Resolving Request: " + this + "(" + this.hashCode() + ")");
            }
        } else if (this.DEBUG) {
            this.debug("Not resolving Request: " + this);
        }
    }

    public Envelope getRequest() {
        return this.m_request;
    }

    Envelope getReply() {
        return this.m_reply;
    }

    IMgram getReplyMgram() {
        return this.m_replyMgram;
    }

    void setRequestMgram(IMgram req) {
        this.m_requestMgram = req;
    }

    IMgram getRequestMgram() {
        return this.m_requestMgram;
    }

    void setGuarPub(Publication guarPub) {
        this.m_guarPub = guarPub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReply(Envelope rep) {
        Job job;
        if (this.DEBUG) {
            this.debug("setReply: " + this + "(" + this.hashCode() + ")");
        }
        if (this.m_guarPub != null) {
            job = this.m_guarPub;
            synchronized (job) {
                if (this.m_guarPub.isRunning()) {
                    this.m_guarPub.setStatus(0);
                }
            }
        }
        job = this;
        synchronized (job) {
            this.m_status = 0;
            this.m_reply = rep;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReplyMgram(IMgram rep) {
        Job job;
        if (this.DEBUG) {
            this.debug("setReplyMgram: " + this + "(" + this.hashCode() + ")");
        }
        if (this.m_guarPub != null) {
            job = this.m_guarPub;
            synchronized (job) {
                if (this.m_guarPub.isRunning()) {
                    this.m_guarPub.setStatus(0);
                }
            }
        }
        job = this;
        synchronized (job) {
            this.m_status = 0;
            this.m_replyMgram = rep;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void join() throws EInterrupted, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        super.join();
        switch (this.m_status) {
            case 0: {
                return;
            }
            case -39: {
                throw new EConnectionNotResumable();
            }
            case -5: {
                throw new ENotConnected();
            }
            case -17: {
                throw new EConnectionClosing();
            }
            case -3: {
                throw new EIntegrityCompromised();
            }
        }
        throw new ENetworkFailure(155, SessionConfig.UNKNOWN_REQ_CODE + ": " + this.m_status);
    }

    @Override
    public void join(int seconds) throws EInterrupted, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        this.joinMillis(seconds * 1000);
    }

    @Override
    synchronized void joinMillis(long millis) throws EInterrupted, ETimeout, ENetworkFailure, ESecurityPolicyViolation, EGeneralException {
        super.joinMillis(millis);
        switch (this.m_status) {
            case 0: {
                return;
            }
            case -39: {
                throw new EConnectionNotResumable();
            }
            case -5: {
                throw new ENotConnected();
            }
            case -17: {
                throw new EConnectionClosing();
            }
            case -3: {
                throw new EIntegrityCompromised();
            }
        }
        throw new ENetworkFailure(155, SessionConfig.UNKNOWN_REQ_CODE + ": " + this.m_status);
    }

    @Override
    public void start() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void enqueuedToSend(IMgram m) {
        this.setStatus(1);
    }

    public void setPendingResponse(boolean pendingResponse) {
        this.m_pendingResponse = pendingResponse;
    }

    public boolean getPendingResponse() {
        return this.m_pendingResponse;
    }

    public void setXonce(boolean xo) {
        this.m_xonce = xo;
    }

    public boolean getXonce() {
        return this.m_xonce;
    }

    @Override
    protected String getDiagnosticThreadInfo() {
        long rtracking = -1L;
        long gtracking = -1L;
        String subject = "<unknown>";
        try {
            rtracking = this.m_requestMgram.getReplySubject().getSubjectTracking() & 0xFFFFFFFFL;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gtracking = this.m_requestMgram.getGuarenteedTrackingNum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            subject = this.m_requestMgram.getSubject().getSubjectString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Request: subject " + subject + ", request " + rtracking + ", guar " + gtracking;
    }
}

