/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.client.prAccessor;
import progress.message.jclient.RejectionListener;
import progress.message.jimpl.Connection;
import progress.message.jimpl.IRejectedMsgHolder;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class RejectionProcessor
extends DebugObject
implements Runnable {
    private RejectionListener m_listener = null;
    private String m_name = "RejectionProcessor (UNCONNECTED)";
    private Thread m_thread;
    private boolean m_running = false;
    private boolean m_shutdown = false;
    private boolean m_processing = false;
    private final LinkedList m_queue = new LinkedList();
    private static final long IDLE_TIMEOUT = 120000L;

    public RejectionProcessor(Connection conn) {
        super("RejectionProcessor");
    }

    public final void onConnected(Connection c) {
        this.m_name = "RejectionProcessor for " + c.getConnectID();
    }

    public final synchronized void setRejectionListener(RejectionListener listener) {
        this.m_listener = listener;
    }

    public final boolean hasRejectionListener() {
        return this.m_listener != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Thread thread = null;
        boolean interrupted = false;
        RejectionProcessor rejectionProcessor = this;
        synchronized (rejectionProcessor) {
            this.m_shutdown = true;
            thread = this.m_thread;
            this.notifyAll();
            while (this.m_processing || this.m_running) {
                if (this.DEBUG) {
                    this.debug(this.m_name + " Waiting for rejection processing to complete (" + this.m_processing + "/" + this.m_running);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (this.DEBUG) {
                        this.debug(this.m_name + " Interrupted waiting for rejection processing to complete");
                    }
                    interrupted = true;
                }
            }
            this.m_queue.clear();
        }
        if (thread != null) {
            if (this.DEBUG) {
                this.debug(this.m_name + " Joining rejection processor thread...");
            }
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            if (this.DEBUG) {
                this.debug(this.m_name + " joined rejection processor thread...");
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public final void handleRejection(JMSException jmse, Message m, boolean sync) {
        this.handleRejection(new RejectionElem(jmse, m), sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleRejection(IRejectedMsgHolder rejection, boolean sync) {
        RejectionProcessor rejectionProcessor = this;
        synchronized (rejectionProcessor) {
            if (this.m_listener == null || this.m_shutdown) {
                return;
            }
            if (!sync && !this.m_running) {
                if (this.DEBUG) {
                    this.debug(this.m_name + "starting thread.");
                }
                this.m_thread = new Thread((Runnable)this, this.m_name);
                this.m_thread.start();
                this.m_running = true;
            }
            this.m_queue.add(rejection);
            this.notifyAll();
        }
        if (sync) {
            this.processRejections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            RejectionProcessor rejectionProcessor = this;
            synchronized (rejectionProcessor) {
                long idleTimeout = System.currentTimeMillis() + 120000L;
                while (this.m_queue.isEmpty() && !this.m_shutdown) {
                    long timeToWait = idleTimeout - System.currentTimeMillis();
                    if (timeToWait <= 0L) {
                        if (this.DEBUG) {
                            this.debug(this.m_name + " idle timeout reached ... exiting");
                        }
                        this.m_running = false;
                        this.notifyAll();
                        return;
                    }
                    try {
                        this.wait(timeToWait);
                    }
                    catch (InterruptedException e) {
                        if (!this.DEBUG) continue;
                        this.debug(this.m_name + " interrupted ... ignoring");
                    }
                }
            }
            this.processRejections();
            rejectionProcessor = this;
            synchronized (rejectionProcessor) {
                if (this.m_shutdown) {
                    if (this.DEBUG) {
                        this.debug(this.m_name + " shutdown ... exiting");
                    }
                    this.m_running = false;
                    this.notifyAll();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void processRejections() {
        boolean interrupted = false;
        RejectionProcessor rejectionProcessor = this;
        // MONITORENTER : rejectionProcessor
        while (this.m_processing) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.m_processing = true;
        // MONITOREXIT : rejectionProcessor
        while (true) {
            RejectionProcessor rejectionProcessor2;
            RejectionListener listener;
            IRejectedMsgHolder rmh;
            block27: {
                rmh = null;
                listener = null;
                RejectionProcessor rejectionProcessor3 = this;
                // MONITORENTER : rejectionProcessor3
                if (!this.m_queue.isEmpty()) break block27;
                // MONITOREXIT : rejectionProcessor3
                rejectionProcessor2 = this;
                // MONITORENTER : rejectionProcessor2
                this.m_processing = false;
                this.notifyAll();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                // MONITOREXIT : rejectionProcessor2
                return;
            }
            if (this.m_listener == null) {
                this.m_queue.clear();
                // MONITOREXIT : rejectionProcessor3
                rejectionProcessor2 = this;
                // MONITORENTER : rejectionProcessor2
                this.m_processing = false;
                this.notifyAll();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                // MONITOREXIT : rejectionProcessor2
                return;
            }
            listener = this.m_listener;
            rmh = (IRejectedMsgHolder)this.m_queue.removeFirst();
            // MONITOREXIT : rejectionProcessor3
            if (this.DEBUG) {
                this.debug(this.m_name + " Processing rejected message: " + rmh);
            }
            boolean bl = interrupted = interrupted || Thread.interrupted();
            while (rmh.hasRejections()) {
                Message m = rmh.getMessage();
                JMSException jmse = rmh.getException();
                try {
                    listener.onRejectedMessage(m, jmse);
                }
                catch (Throwable thrown) {
                    SessionConfig.logMessage(prAccessor.getString("REJECTION_LISTENER_EXCEPTION"), thrown, SessionConfig.WARNING);
                }
                Thread.interrupted();
                rmh.rejectionProcessed();
            }
            if (!this.DEBUG) continue;
            this.debug(this.m_name + " Completed processing rejected message: " + rmh);
            continue;
            break;
        }
        catch (Throwable throwable) {
            RejectionProcessor rejectionProcessor4 = this;
            // MONITORENTER : rejectionProcessor4
            this.m_processing = false;
            this.notifyAll();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            // MONITOREXIT : rejectionProcessor4
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForRejectionProcessing() {
        boolean interrupted = false;
        RejectionProcessor rejectionProcessor = this;
        synchronized (rejectionProcessor) {
            while (!(this.m_queue.isEmpty() && !this.m_processing || this.m_shutdown)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private final class RejectionElem
    implements IRejectedMsgHolder {
        JMSException m_jmse;
        Message m_msg;
        boolean m_processed = false;

        RejectionElem(JMSException jmse, Message m) {
            this.m_jmse = jmse;
            this.m_msg = m;
        }

        public String toString() {
            return "Rejected Message: " + this.m_msg + " -- " + this.m_jmse;
        }

        @Override
        public boolean hasRejections() {
            return !this.m_processed;
        }

        @Override
        public JMSException getException() {
            if (!this.m_processed) {
                return this.m_jmse;
            }
            return null;
        }

        @Override
        public Message getMessage() {
            if (!this.m_processed) {
                return this.m_msg;
            }
            return null;
        }

        @Override
        public void rejectionProcessed() {
            this.m_processed = true;
        }
    }
}

