/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInterrupted;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETimeout;
import progress.message.client.ETransactionFailure;
import progress.message.client.ETransactionRollbackByBroker;
import progress.message.msg.IMgram;
import progress.message.zclient.EConnectionClosing;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.Job;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

final class SynchronousAck
extends Job {
    IMgram m_ack;
    IJobResolver m_resolver;

    SynchronousAck(IMgram ack, IJobResolver resolver) {
        this.debugName("SynchronousAck");
        this.m_ack = ack;
        this.m_resolver = resolver;
        this.m_status = 1;
    }

    @Override
    public void resolve() {
        if (this.m_resolver != null) {
            if (this.DEBUG) {
                this.debug("Resolving job: " + this);
            }
            this.m_resolver.resolveJob(this);
        }
    }

    public IMgram getAck() {
        return this.m_ack;
    }

    @Override
    public synchronized void join() throws EInterrupted, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        super.join();
        this.checkStatus();
    }

    @Override
    public void join(int seconds) throws ETimeout, EInterrupted, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        this.joinMillis(seconds * 1000);
    }

    @Override
    public synchronized void joinMillis(long millis) throws ETimeout, EInterrupted, ENetworkFailure, ESecurityPolicyViolation, ETransactionFailure, EGeneralException {
        super.joinMillis(millis);
        this.checkStatus();
    }

    private void checkStatus() throws ENotConnected, EIntegrityCompromised, ENetworkFailure, ETransactionFailure, EConnectionNotResumable {
        switch (this.m_status) {
            case 0: {
                return;
            }
            case -5: {
                throw new ENotConnected();
            }
            case -17: {
                throw new EConnectionClosing();
            }
            case -3: {
                throw new EIntegrityCompromised();
            }
            case -11: {
                throw new ETransactionRollbackByBroker("");
            }
            case -12: {
                throw new ETransactionFailure(168, SessionConfig.ERRMSG_TXN_ACC_VIOL);
            }
            case -13: {
                throw new ETransactionFailure(169, SessionConfig.ERRMSG_TXN_SEQ_ERR);
            }
            case -39: {
                throw new EConnectionNotResumable(prAccessor.getString("CONNECTION_UNRESUMABLE"), null);
            }
        }
        throw new ENetworkFailure(166, SessionConfig.UNKNOWN_CODE + ": " + this.m_status);
    }

    @Override
    public void start() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void cancel() {
    }

    @Override
    protected String getDiagnosticThreadInfo() {
        String info = "SynchronousAck: tracking ";
        try {
            info = info + Long.toString(this.m_ack.getAckHandle().getTrackingNumber());
        }
        catch (Throwable t) {
            info = info + "<unknown>";
        }
        return info;
    }
}

