/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.ResourceAllocationException;
import javax.jms.ResourceAllocationRuntimeException;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionInProgressRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;

public final class JMSExceptionUtils {
    private JMSExceptionUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static JMSRuntimeException convertToRuntimeException(JMSException exception) {
        if (exception instanceof IllegalStateException) {
            return new IllegalStateRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof InvalidClientIDException) {
            return new InvalidClientIDRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof InvalidDestinationException) {
            return new InvalidDestinationRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof InvalidSelectorException) {
            return new InvalidSelectorRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof JMSSecurityException) {
            return new JMSSecurityRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof MessageFormatException) {
            return new MessageFormatRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof MessageNotWriteableException) {
            return new MessageNotWriteableRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof ResourceAllocationException) {
            return new ResourceAllocationRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof TransactionInProgressException) {
            return new TransactionInProgressRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        if (exception instanceof TransactionRolledBackException) {
            return new TransactionRolledBackRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
        }
        return new JMSRuntimeException(exception.getMessage(), exception.getErrorCode(), exception);
    }
}

