/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.threads;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.threads.LockDetail;
import com.sonicsw.sdf.threads.ThreadCPUStats;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class ThreadDump {
    private static final boolean DEBUG;
    private static final long PERIOD_DIVIDE = 1000L;
    static Class<?> LockInfo_CLASS;
    static Class<?> MonitorInfo_CLASS;
    static Method dumpAllThreads_METHOD;
    static Method findDeadlockedThreads_METHOD;
    static Method getLockInfo_METHOD;
    static Method getLockedMonitors_METHOD;
    static Method getLockedSynchronizers_METHOD;
    static Method getLockClassName_METHOD;
    static Method getLockIdentityHashCode_METHOD;
    static Method getLockedStackDepth_METHOD;
    private static boolean s_lockInfoSupported;
    private static final LockDetail[] EMPTY_LOCK_ARRAY;
    private static ThreadGroup s_rootThreadGroup;
    private static final ThreadMXBean s_threadMXBean;
    private static final String INDENT = "    ";
    private static final DecimalFormat s_cpuPercentFormat;
    private static final Float CPU_USAGE_DISPLAY_THRESHOLD;
    private static long s_savedTime;
    private static ThreadCPUStats s_savedCpuStats;
    static final long SAVED_CPU_STATS_TIMEOUT_MINS = 15L;
    private long m_startTime = System.currentTimeMillis();
    private long m_endTime;
    private long m_prevTime;
    private Map<Long, ThreadInfo> m_mgmtThreads;
    private Map<Long, Thread> m_runtimeThreads;
    private long[] m_deadlockedThreads;
    private ThreadCPUStats m_cpuStats = null;
    private boolean m_cpuUsageAvailable = false;

    private ThreadDump() {
        ThreadInfo[] mgmtThreadArray = this.getThreadsFromMgmt();
        Thread[] runtimeThreadArray = this.getThreadsFromRuntime();
        this.m_deadlockedThreads = this.getDeadlockedThreads();
        this.m_endTime = System.currentTimeMillis();
        if (s_threadMXBean.isThreadCpuTimeSupported() && s_threadMXBean.isThreadCpuTimeEnabled()) {
            this.m_cpuStats = new ThreadCPUStats(mgmtThreadArray.length);
            for (ThreadInfo ti : mgmtThreadArray) {
                long tid;
                long cpuTime;
                if (ti == null || (cpuTime = s_threadMXBean.getThreadCpuTime(tid = ti.getThreadId())) < 0L) continue;
                this.m_cpuStats.addStat(tid, cpuTime);
            }
        }
        this.m_mgmtThreads = new LinkedHashMap<Long, ThreadInfo>(mgmtThreadArray.length);
        for (ThreadInfo ti : mgmtThreadArray) {
            if (ti == null) continue;
            this.m_mgmtThreads.put(ti.getThreadId(), ti);
        }
        this.m_runtimeThreads = new HashMap<Long, Thread>(runtimeThreadArray.length);
        for (Thread t : runtimeThreadArray) {
            if (t == null) continue;
            this.m_runtimeThreads.put(t.getId(), t);
        }
    }

    public static synchronized ThreadDump createThreadDump() {
        ThreadDump dump = new ThreadDump();
        if (dump.m_startTime - s_savedTime > 900000L) {
            s_savedCpuStats = null;
        }
        if (dump.m_cpuStats != null && s_savedCpuStats != null) {
            for (long tid : dump.m_mgmtThreads.keySet()) {
                ThreadCPUStats.StatEntry oldStat = s_savedCpuStats.getStat(tid);
                ThreadCPUStats.StatEntry newStat = dump.m_cpuStats.getStat(tid);
                if (oldStat == null || newStat == null) continue;
                newStat.computeUsageInLastPeriod(oldStat);
            }
            dump.m_cpuUsageAvailable = true;
        }
        dump.m_prevTime = s_savedTime;
        s_savedTime = dump.m_startTime;
        s_savedCpuStats = dump.m_cpuStats;
        return dump;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getElapsedTime() {
        return this.m_endTime - this.m_startTime;
    }

    public long getPreviousThreadDumpTime() {
        return this.m_prevTime;
    }

    public int getThreadCount() {
        return this.m_mgmtThreads.size();
    }

    public int getDeadlockedThreadCount() {
        return this.m_deadlockedThreads == null ? 0 : this.m_deadlockedThreads.length;
    }

    public void showThreads(IStateWriter writer) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        for (ThreadInfo ti : this.m_mgmtThreads.values()) {
            this.printThreadInfo(writer, ti);
            writer.writeln();
        }
    }

    public void showDeadlockedThreads(IStateWriter writer) throws IOException {
        if (this.m_deadlockedThreads == null) {
            return;
        }
        for (long tid : this.m_deadlockedThreads) {
            ThreadInfo ti = this.m_mgmtThreads.get(tid);
            if (ti != null) {
                writer.writeln("\"" + ti.getThreadName() + "\" (tid=0x" + Long.toHexString(tid) + ")");
                writer.writeln("    waiting for " + ti.getLockName());
                writer.writeln("    which is held by \"" + ti.getLockOwnerName() + "\" (tid=0x" + Long.toHexString(ti.getLockOwnerId()) + ")");
                continue;
            }
            writer.writeln("Thread tid=0x" + Long.toHexString(tid) + " - no details available");
        }
    }

    public void showCpuUsage(IStateWriter writer, int maxEntries) throws IOException {
        if (!this.m_cpuUsageAvailable || this.m_cpuStats == null) {
            writer.writeln("<CPU usage not available>");
            return;
        }
        LinkedList<ThreadCPUStats.StatEntry> stats = new LinkedList<ThreadCPUStats.StatEntry>();
        for (ThreadCPUStats.StatEntry statEntry : this.m_cpuStats.getAllStats()) {
            if (!(statEntry.getPercentInLastPeriod() >= CPU_USAGE_DISPLAY_THRESHOLD.floatValue())) continue;
            stats.add(statEntry);
        }
        Collections.sort(stats, Collections.reverseOrder());
        if (stats.isEmpty()) {
            writer.writeln("<no threads reporting significant CPU usage>");
        } else {
            int numThreadsToDisplay = stats.size() > maxEntries ? maxEntries : stats.size();
            for (int i = 0; i < numThreadsToDisplay; ++i) {
                ThreadCPUStats.StatEntry stat = (ThreadCPUStats.StatEntry)stats.get(i);
                ThreadInfo ti = this.m_mgmtThreads.get(stat.getThreadId());
                StringBuilder sb = new StringBuilder();
                sb.append('\"').append(ti.getThreadName()).append('\"');
                sb.append(" tid=0x").append(Long.toHexString(ti.getThreadId()));
                sb.append(" cpu=").append(stat.getUsageInLastPeriod() / 1000000L);
                sb.append("(").append(s_cpuPercentFormat.format(stat.getPercentInLastPeriod())).append("%)");
                writer.writeln(sb.toString());
            }
        }
    }

    public boolean isCpuUsageAvailable() {
        return this.m_cpuUsageAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCpuUsageEnabled() {
        Class<ThreadDump> clazz = ThreadDump.class;
        synchronized (ThreadDump.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s_savedCpuStats != null;
        }
    }

    public static boolean isLockInfoSupported() {
        return s_lockInfoSupported;
    }

    private ThreadInfo[] getThreadsFromMgmt() {
        ThreadInfo[] result = null;
        if (dumpAllThreads_METHOD != null) {
            try {
                result = (ThreadInfo[])dumpAllThreads_METHOD.invoke((Object)s_threadMXBean, true, true);
            }
            catch (Exception e) {
                System.err.println("Failed to get lock info' for thread dump:");
                e.printStackTrace();
            }
        }
        if (result == null) {
            long[] tids = s_threadMXBean.getAllThreadIds();
            result = s_threadMXBean.getThreadInfo(tids, Integer.MAX_VALUE);
        }
        return result;
    }

    private Thread[] getThreadsFromRuntime() {
        Thread[] threads;
        int resultSize;
        int arraySize = s_threadMXBean.getThreadCount();
        while ((resultSize = s_rootThreadGroup.enumerate(threads = new Thread[arraySize = (int)((double)arraySize * 1.5)], true)) >= arraySize) {
        }
        return threads;
    }

    private long[] getDeadlockedThreads() {
        if (findDeadlockedThreads_METHOD != null) {
            try {
                return (long[])findDeadlockedThreads_METHOD.invoke((Object)s_threadMXBean, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Failed to get deadlocks with synchronizers:");
                e.printStackTrace();
            }
        }
        return s_threadMXBean.findMonitorDeadlockedThreads();
    }

    private void printThreadInfo(IStateWriter writer, ThreadInfo ti) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        LockDetail[] synchronizers;
        this.printThreadTitle(writer, ti);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        String blockedByName = null;
        LockDetail[] monitors = EMPTY_LOCK_ARRAY;
        if (s_lockInfoSupported) {
            LockDetail blockedBy = this.getBlockedByLock(ti);
            blockedByName = blockedBy == null ? null : blockedBy.toString();
            monitors = this.getLockedMonitors(ti);
        } else {
            blockedByName = ti.getLockName();
        }
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            writer.writeln("    at " + ste.toString());
            if (blockedByName != null && i == 0) {
                if (ti.getThreadState() == Thread.State.BLOCKED) {
                    writer.write("      - waiting to lock " + blockedByName);
                } else {
                    writer.write("      - waiting on " + blockedByName);
                }
                if (ti.getLockOwnerName() != null) {
                    writer.writeln(" [owned by \"" + ti.getLockOwnerName() + "\" tid=0x" + Long.toHexString(ti.getLockOwnerId()) + "]");
                } else {
                    writer.writeln();
                }
            }
            LockDetail[] lockDetailArray = monitors;
            int n = lockDetailArray.length;
            for (int j = 0; j < n; ++j) {
                LockDetail monitor = lockDetailArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                writer.writeln("      - locked " + monitor);
            }
        }
        if (s_lockInfoSupported && (synchronizers = this.getLockedSynchronizers(ti)).length > 0) {
            writer.writeln("    Locked synchronizers (" + synchronizers.length + ")");
            for (LockDetail synchronizer : synchronizers) {
                writer.writeln("      - " + synchronizer);
            }
        }
    }

    private void printThreadTitle(IStateWriter writer, ThreadInfo ti) throws IOException {
        Thread t = this.m_runtimeThreads.get(ti.getThreadId());
        StringBuilder sb = new StringBuilder();
        sb.append('\"').append(ti.getThreadName()).append('\"');
        if (t != null) {
            if (t.isDaemon()) {
                sb.append(" daemon");
            }
            sb.append(" prio=").append(t.getPriority());
        } else {
            sb.append(" <daemon/prio unavailable>");
        }
        sb.append(" tid=0x").append(Long.toHexString(ti.getThreadId()));
        if (this.m_cpuUsageAvailable) {
            ThreadCPUStats.StatEntry stat = this.m_cpuStats.getStat(ti.getThreadId());
            if (stat != null && stat.getUsageInLastPeriod() >= 0L) {
                sb.append(" cpu=").append(stat.getUsageInLastPeriod() / 1000000L);
                sb.append("(").append(s_cpuPercentFormat.format(stat.getPercentInLastPeriod())).append("%)");
            } else {
                sb.append(" cpu=n/a");
            }
        }
        sb.append(" state=").append((Object)ti.getThreadState());
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        writer.writeln(sb.toString());
    }

    private LockDetail getBlockedByLock(ThreadInfo ti) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object lock = getLockInfo_METHOD.invoke((Object)ti, new Object[0]);
        if (lock == null) {
            return null;
        }
        return new LockDetail(lock);
    }

    private LockDetail[] getLockedMonitors(ThreadInfo ti) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.createLockDetails(getLockedMonitors_METHOD, ti);
    }

    private LockDetail[] getLockedSynchronizers(ThreadInfo ti) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.createLockDetails(getLockedSynchronizers_METHOD, ti);
    }

    private LockDetail[] createLockDetails(Method getLockedSynchronizers_METHOD, ThreadInfo ti) throws IllegalAccessException, InvocationTargetException {
        Object[] locks = (Object[])getLockedSynchronizers_METHOD.invoke((Object)ti, new Object[0]);
        LockDetail[] result = new LockDetail[locks.length];
        for (int i = 0; i < locks.length; ++i) {
            result[i] = new LockDetail(locks[i]);
        }
        return result;
    }

    void writeThreadDump(IStateWriter writer) throws IOException, InvocationTargetException, IllegalAccessException {
        writer.writeln("Java Thread Dump (thread details collected in " + this.getElapsedTime() + "ms)");
        this.showThreads(writer);
        writer.writeln("" + this.getThreadCount() + " threads");
        writer.writeln();
        if (this.getDeadlockedThreadCount() == 0) {
            writer.writeln("No deadlocks found");
        } else {
            writer.writeln("Found " + this.getDeadlockedThreadCount() + " deadlocked threads...");
            this.showDeadlockedThreads(writer);
        }
        if (this.isCpuUsageEnabled()) {
            if (this.isCpuUsageAvailable()) {
                long period = (this.getStartTime() - this.getPreviousThreadDumpTime()) / 1000L;
                writer.writeln(IDiagnosticsConstants.NEWLINE + "Threads with highest CPU usage over last " + period + " seconds");
                this.showCpuUsage(writer, 10);
            } else {
                writer.writeln(IDiagnosticsConstants.NEWLINE + "Take another thread dump within " + 15L + " minutes to see CPU usage information.");
            }
        }
    }

    static {
        block3: {
            DEBUG = Boolean.getBoolean("Sonic.sdf.ThreadDumpDebug");
            LockInfo_CLASS = null;
            MonitorInfo_CLASS = null;
            dumpAllThreads_METHOD = null;
            findDeadlockedThreads_METHOD = null;
            getLockInfo_METHOD = null;
            getLockedMonitors_METHOD = null;
            getLockedSynchronizers_METHOD = null;
            getLockClassName_METHOD = null;
            getLockIdentityHashCode_METHOD = null;
            getLockedStackDepth_METHOD = null;
            s_lockInfoSupported = true;
            EMPTY_LOCK_ARRAY = new LockDetail[0];
            s_rootThreadGroup = null;
            s_threadMXBean = ManagementFactory.getThreadMXBean();
            s_cpuPercentFormat = new DecimalFormat("###0.00");
            CPU_USAGE_DISPLAY_THRESHOLD = Float.valueOf(0.01f);
            s_rootThreadGroup = Thread.currentThread().getThreadGroup();
            ThreadGroup parent = s_rootThreadGroup.getParent();
            while (parent != null) {
                s_rootThreadGroup = parent;
                parent = s_rootThreadGroup.getParent();
            }
            try {
                LockInfo_CLASS = Class.forName("java.lang.management.LockInfo");
                MonitorInfo_CLASS = Class.forName("java.lang.management.MonitorInfo");
                dumpAllThreads_METHOD = ThreadMXBean.class.getMethod("dumpAllThreads", Boolean.TYPE, Boolean.TYPE);
                findDeadlockedThreads_METHOD = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                getLockInfo_METHOD = ThreadInfo.class.getMethod("getLockInfo", new Class[0]);
                getLockedMonitors_METHOD = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                getLockedSynchronizers_METHOD = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                getLockClassName_METHOD = LockInfo_CLASS.getMethod("getClassName", new Class[0]);
                getLockIdentityHashCode_METHOD = LockInfo_CLASS.getMethod("getIdentityHashCode", new Class[0]);
                getLockedStackDepth_METHOD = MonitorInfo_CLASS.getMethod("getLockedStackDepth", new Class[0]);
            }
            catch (Throwable t) {
                s_lockInfoSupported = false;
                if (!DEBUG) break block3;
                System.err.println("SDF thread dump: Lock info support disabled due to:");
                t.printStackTrace();
            }
        }
        s_savedTime = -1L;
        s_savedCpuStats = null;
    }
}

