/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Session;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;

public class TemporaryQueue
extends Queue
implements javax.jms.TemporaryQueue {
    private Connection m_connection;
    private boolean m_isGlobal;
    private transient boolean m_deleted = false;

    public TemporaryQueue(Session qSession, boolean isGlobal, String uniqueId) throws JMSException {
        this(qSession, uniqueId, -1, isGlobal);
    }

    public TemporaryQueue(Session qSession, String uniqueId, int maxSize, boolean isGlobal) throws JMSException {
        super(TemporaryQueue.generateTemporaryQueueName(qSession, uniqueId), true);
        this.setupTempQueue(null, qSession, maxSize, isGlobal);
    }

    public TemporaryQueue(String name, Session qSession, boolean isGlobal) throws JMSException {
        super(name, true);
        this.setupTempQueue(name, qSession, -1, isGlobal);
    }

    public TemporaryQueue(String name, Session qSession, int maxSize, boolean isGlobal) throws JMSException {
        super(name, true);
        this.setupTempQueue(name, qSession, maxSize, isGlobal);
    }

    private void setupTempQueue(String qNameParam, Session qSession, int maxSize, boolean isGlobal) throws JMSException {
        String qName = qNameParam;
        this.m_connection = qSession.m_jconnection;
        this.m_isGlobal = isGlobal;
        try {
            qName = this.getQueueName();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (TemporaryQueue.queueExists(qName, this.m_connection)) {
            throw JMSExceptionUtil.createJMSException("QUEUE_NAME_ALREADY_EXISTS", null);
        }
        if (this.m_isGlobal) {
            this.m_routingNodeName = qSession.getJconnection().getRoutingNodeName();
        }
        this.m_connection.addTemporaryQueue(qName, this, maxSize);
    }

    @Override
    public String getFullName() {
        if (this.isGlobal()) {
            return this.m_routingNodeName + "::" + this.m_queueName;
        }
        return this.m_queueName;
    }

    public boolean isGlobal() {
        return this.m_isGlobal;
    }

    @Override
    public void delete() throws JMSException {
        block3: {
            if (this.m_connection != null) {
                try {
                    this.m_connection.removeTemporaryQueue(this.getQueueName());
                }
                catch (JMSException e) {
                    if (this.m_connection.isFaultTolerant()) break block3;
                    throw e;
                }
            }
        }
        this.m_connection = null;
        this.m_deleted = true;
    }

    static String generateTemporaryQueueName(Session qSession, String uniqueId) throws InvalidDestinationException {
        if (null != uniqueId) {
            DestUtil.validateQueueName(uniqueId);
        }
        String subject = SessionConfig.getDirectedSubject(qSession.m_jconnection.m_zconnection.getEffectiveUid(), qSession.m_zconnection.getApplicationId(), "*", "*", "TemporaryQueues");
        String name = subject + "." + ProgressSecureRandom.theSecureRandom().nextInt();
        if (null != uniqueId) {
            name = name + uniqueId;
        }
        return name;
    }

    static boolean queueExists(String name, Connection connection) {
        TemporaryQueue obj = null;
        obj = connection.getTemporaryQueue(name);
        return obj != null;
    }

    @Override
    public final boolean isDeleted() {
        return this.m_deleted;
    }

    @Override
    public void validateForSend(Message message) throws JMSException {
        this.checkIsDeleted();
        super.validateForSend(message);
    }

    @Override
    public void validateForConsume(Connection connection) throws JMSException {
        this.checkIsDeleted();
        super.validateForConsume(connection);
    }

    private void checkIsDeleted() throws InvalidDestinationException {
        if (this.isDeleted()) {
            throw new InvalidDestinationException(prAccessor.getString("DELETED_TEMPORARY_QUEUE"));
        }
    }
}

