/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import progress.message.util.MemoryUtil;

public class PriorityQueue {
    protected int m_numPriorities;
    protected PriorityQueueToken[] m_queueEnd;
    protected int m_highestNonEmptyPriority = -1;
    protected int m_totalEnqueued = 0;
    protected int[] m_elementsEnqueued;
    protected PriorityQueueElement m_cursor;
    protected int m_cursorPriority = -1;
    protected boolean m_cancelled = false;
    private static final int s_PriorityQueueElementSize = MemoryUtil.estimateBaseSize(PriorityQueueElement.class);

    public PriorityQueue(int numPriorities) {
        this.m_numPriorities = numPriorities;
        this.m_queueEnd = new PriorityQueueToken[this.m_numPriorities + 1];
        for (int i = 0; i <= this.m_numPriorities; ++i) {
            this.m_queueEnd[i] = new PriorityQueueToken();
            if (i <= 0) continue;
            this.m_queueEnd[i - 1].m_prev = this.m_queueEnd[i];
            this.m_queueEnd[i].m_next = this.m_queueEnd[i - 1];
        }
        this.m_elementsEnqueued = new int[this.m_numPriorities];
    }

    public synchronized void enqueuePriorityPush(Object obj, int prio, int pushPrio, boolean implementsContains) {
        this.enqueue(obj, prio, implementsContains);
        for (int p = pushPrio - 1; p >= prio; --p) {
            PriorityQueueElement elem = null;
            while (this.m_elementsEnqueued[p] > 0) {
                elem = this.dequeueElem(p);
                if (elem == this.m_cursor) {
                    this.m_cursor = null;
                }
                this.enqueue(elem.m_payload, pushPrio, elem.m_implementsContains);
            }
        }
    }

    public synchronized void enqueue(Object obj, int prio) {
        this.enqueue(obj, prio, false);
    }

    public synchronized void enqueue(Object obj, int prio, boolean implementsContains) {
        PriorityQueueElement elem = new PriorityQueueElement(obj, prio, implementsContains);
        PriorityQueueToken end = this.m_queueEnd[prio];
        PriorityQueueElement e = end.m_prev;
        e.m_next = elem;
        elem.m_prev = e;
        end.m_prev = elem;
        elem.m_next = end;
        ++this.m_totalEnqueued;
        int n = prio;
        this.m_elementsEnqueued[n] = this.m_elementsEnqueued[n] + 1;
        if (prio > this.m_highestNonEmptyPriority) {
            this.m_highestNonEmptyPriority = prio;
        }
        this.notifyAll();
    }

    public synchronized Object dequeue() {
        if (this.m_highestNonEmptyPriority < 0) {
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    public synchronized PriorityQueueElement dequeueElem() {
        if (this.m_highestNonEmptyPriority < 0) {
            return null;
        }
        return this.dequeueElem(this.m_highestNonEmptyPriority);
    }

    public synchronized void cancel() {
        this.m_cancelled = true;
        this.notifyAll();
    }

    public synchronized Object peek() {
        if (this.m_highestNonEmptyPriority < 0) {
            return null;
        }
        return this.peek(this.m_highestNonEmptyPriority);
    }

    public synchronized Object peek(int prio) {
        if (this.m_elementsEnqueued[prio] == 0) {
            return null;
        }
        PriorityQueueToken startToken = this.m_queueEnd[prio + 1];
        PriorityQueueElement current = startToken.m_next;
        return current.m_payload;
    }

    public synchronized Object dequeue(int prio) {
        PriorityQueueElement elem = this.dequeueElem(prio);
        if (elem != null) {
            return elem.m_payload;
        }
        return null;
    }

    public final synchronized PriorityQueueElement dequeueElem(int prio) {
        if (this.m_elementsEnqueued[prio] == 0) {
            return null;
        }
        PriorityQueueToken startToken = this.m_queueEnd[prio + 1];
        PriorityQueueElement current = startToken.m_next;
        if (current == this.m_cursor) {
            this.m_cursor = null;
        }
        PriorityQueueElement e = current.m_next;
        e.m_prev = startToken;
        startToken.m_next = e;
        --this.m_totalEnqueued;
        int n = prio;
        this.m_elementsEnqueued[n] = this.m_elementsEnqueued[n] - 1;
        if (prio == this.m_highestNonEmptyPriority) {
            while (this.m_highestNonEmptyPriority != -1 && this.m_elementsEnqueued[this.m_highestNonEmptyPriority] == 0) {
                --this.m_highestNonEmptyPriority;
            }
        }
        current.m_next = null;
        current.m_prev = null;
        this.notifyAll();
        return current;
    }

    public synchronized Object dequeueWait() throws InterruptedException {
        while (this.m_totalEnqueued == 0 && !this.m_cancelled) {
            this.wait();
        }
        if (this.m_cancelled) {
            return null;
        }
        return this.dequeue();
    }

    public synchronized Object dequeueWait(int prio) throws InterruptedException {
        while (this.m_elementsEnqueued[prio] == 0 && !this.m_cancelled) {
            this.wait();
        }
        if (this.m_cancelled) {
            return null;
        }
        return this.dequeue(prio);
    }

    public synchronized Object dequeueAtOrAbove(int minPriority) {
        if (this.m_highestNonEmptyPriority < minPriority) {
            return null;
        }
        return this.dequeue();
    }

    public synchronized Object dequeueAtOrAboveWait(int minPriority) throws InterruptedException {
        while (this.m_highestNonEmptyPriority < minPriority && !this.m_cancelled) {
            this.wait();
        }
        if (this.m_cancelled) {
            return null;
        }
        return this.dequeue();
    }

    public synchronized int getEnqueuedAtOrAbove(int prio) {
        int count = 0;
        for (int i = prio; i <= this.m_highestNonEmptyPriority; ++i) {
            count += this.m_elementsEnqueued[i];
        }
        return count;
    }

    public synchronized boolean hasEnqueuedAtOrAbove(int prio) {
        return this.m_highestNonEmptyPriority >= prio;
    }

    public synchronized int getEnqueued() {
        return this.m_totalEnqueued;
    }

    public synchronized boolean isEmpty() {
        return this.m_totalEnqueued == 0;
    }

    public synchronized int getEnqueuedBelow(int prio) {
        int count = 0;
        for (int i = 0; i < prio; ++i) {
            count += this.m_elementsEnqueued[i];
        }
        return count;
    }

    public final int getNumPriorities() {
        return this.m_numPriorities;
    }

    public synchronized int getMaxNonEmptyPriorityBelow(int prio) {
        if (prio == 0) {
            return -1;
        }
        for (int i = prio - 1; i >= 0; --i) {
            if (this.m_elementsEnqueued[i] <= 0) continue;
            return i;
        }
        return -1;
    }

    public static int getPriorityQueueElementSize() {
        return s_PriorityQueueElementSize;
    }

    public static class PriorityQueueToken
    extends PriorityQueueElement {
        public PriorityQueueToken() {
            super(null, -1);
        }
    }

    public static class PriorityQueueElement {
        public int m_prio = -1;
        public PriorityQueueElement m_next = null;
        public PriorityQueueElement m_prev = null;
        public Object m_payload = null;
        public boolean m_implementsContains;

        public PriorityQueueElement(Object payload, int prio) {
            this(payload, prio, false);
        }

        public PriorityQueueElement(Object payload, int prio, boolean implementsContains) {
            this.m_payload = payload;
            this.m_prio = prio;
            this.m_implementsContains = implementsContains;
        }

        public int getPriority() {
            return this.m_prio;
        }

        public Object getPayload() {
            return this.m_payload;
        }
    }
}

