/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import com.sonicsw.security.pcs.AbstractCipherSuite;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.EInvalidCipherSuiteException;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.security.pcs.SonicCipherSuite;
import com.sonicsw.util.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import progress.message.client.EInauthenticBroker;
import progress.message.client.EInauthenticClient;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.security.cert.X509Certificate;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.ExtendedClientData;
import progress.message.zclient.IDES;
import progress.message.zclient.ISHA;
import progress.message.zclient.IUser;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

class ConnectHandshaker
extends DebugObject {
    protected static final boolean DEBUG_NONCE = false;
    protected static final boolean DEBUG_CR_DECRYPT = false;
    protected static final boolean DEBUG_CR_ENCRYPT = false;
    protected static final String SHA_CLASS = "progress.message.crypto.SHA";
    protected static final String DES_CLASS = "progress.message.crypto.DES";
    protected static final int HASH_LENGTH = 20;
    protected static final int PADDED_HASH_LENGTH = 20 + ConnectHandshaker.computePad(20);
    protected static final byte CLIENT_HELLO_SUBTYPE = 1;
    protected static final byte BROKER_HELLO_SUBTYPE = 2;
    protected static final byte CLIENT_ID_SUBTYPE = 3;
    protected static final byte CHALLENGE_1_SUBTYPE = 4;
    protected static final byte CHALLENGE_2_SUBTYPE = 5;
    protected static final byte RESPONSE_SUBTYPE = 6;
    protected static final byte SUCCESS_SUBTYPE = 7;
    protected static final byte SEC_DISABLED_SUBTYPE = 8;
    protected static final byte BROKER_REDIRECTED_SUBTYPE = 9;
    protected static final byte REQUEST_PASSWORD_SUBTYPE = 10;
    protected static final byte PASSWORD_PAYLOAD_SUBTYPE = 11;
    protected static final byte RESPONSE_XPASSWORD_SUBTYPE = 12;
    protected static final byte PASSWORD_PAYLOAD_ERROR_SUBTYPE = 13;
    protected static final int CLIENT_HELLO_STATE = 0;
    protected static final int CLIENT_ID_STATE = 1;
    protected static final int CHALLENGE_1_STATE = 2;
    protected static final int CHALLENGE_2_STATE = 3;
    protected static final int RESPONSE_STATE = 4;
    protected static final int DONE_STATE = 5;
    protected static final int REQUESTING_PASSWORD_STATE = 6;
    protected static final int SENDING_PASSWORD_STATE = 7;
    protected static final int ERROR_STATE = 8;
    protected static long s_tmpAppIdCnt;
    protected BaseConnection m_connection;
    protected boolean m_client;
    protected boolean m_active;
    protected boolean m_securityEnabled;
    protected Sender m_sender;
    protected byte m_incomingClientVer;
    protected ProgressPasswordUser m_user;
    protected String m_uid;
    protected String m_appid;
    protected int m_keyBits;
    protected IUser m_iuser;
    protected X509Certificate m_peerCert;
    protected X509Certificate[] m_peerCertChain;
    protected Object m_cert;
    protected boolean m_loadBalancingRequested = false;
    protected boolean m_faultToleranceRequested = false;
    protected boolean m_resumedJMSConnection = false;
    protected String m_clientData = null;
    protected ClientConnectParms m_clientParameters = null;
    protected ExtendedClientData m_extendedClientData = null;
    protected BrokerConnectParms m_brokerParameters = null;
    protected String m_newBrokerURL = null;
    protected int m_state = 0;
    protected byte[] m_activeNonce;
    protected byte[] m_passiveNonce;
    protected byte[] m_masterSecret;
    protected byte[] m_pwKey;
    protected byte[] m_certBytes;
    protected byte[] m_challenge2Data;
    protected byte[] m_responseData;
    protected boolean m_authenticated = false;
    protected byte[] m_transformedPassword;
    protected IPluggableCipherSuite m_brokerCipherSuite;
    protected IPluggableCipherSuite m_clientCipherSuite;

    ConnectHandshaker(BaseConnection con) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ConnectHandshaker " + con : null);
        this.m_connection = con;
        this.m_peerCert = this.m_connection.getSocket().getPeerCertificate();
        this.m_peerCertChain = this.m_connection.getSocket().getPeerCertificateChain();
        if (this.DEBUG && this.m_peerCert != null) {
            this.debug("Peer Subject Name is : " + this.m_peerCert.getSubjectDN());
        }
    }

    public final boolean isDone() {
        return this.m_state == 5;
    }

    protected void handleConnectMgram(IMgram m) throws EInauthenticClient, EInauthenticBroker, EUnexpectedMgram, EMgramFormatError, EInvalidCipherSuiteException {
        switch (this.m_state) {
            case 0: {
                if (ConnectHandshaker.compareSubtype(m, 9)) {
                    this.m_newBrokerURL = this.decodeBrokerRedirectedMgram(m);
                    this.m_state = 5;
                    break;
                }
            }
            case 2: {
                if (this.m_transformedPassword != null) {
                    this.m_user = new ProgressPasswordUser(this.m_uid, this.m_transformedPassword);
                }
                if (ConnectHandshaker.compareSubtype(m, 8)) {
                    if (this.m_cert == null) {
                        this.m_state = 5;
                        break;
                    }
                    throw new EInauthenticBroker();
                }
                ConnectHandshaker.verifySubtype(m, 4);
                this.m_state = 4;
                this.m_sender.send(this.buildChallenge2(m));
                break;
            }
            case 3: {
                ConnectHandshaker.verifySubtype(m, 5);
                this.m_sender.send(this.buildResponse(m));
                this.m_state = 5;
                break;
            }
            case 4: {
                ConnectHandshaker.verifySubtype(m, 6);
                this.verifyResponse(m);
                this.m_state = 5;
                break;
            }
            default: {
                throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR007"), new Object[]{Integer.toString(this.m_state)}));
            }
        }
    }

    private String decodeBrokerRedirectedMgram(IMgram m) throws EMgramFormatError {
        if (m.getBodyLength() <= 1) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(m.getRawBody(), 1, m.getBodyLength() - 1);
            DataInputStream dis = new DataInputStream(bis);
            return dis.readUTF();
        }
        catch (Exception e) {
            throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR008"), new Object[]{e.toString()}));
        }
    }

    protected static final boolean compareSubtype(IMgram m, int subtype) {
        try {
            return m.getRawBody()[0] == subtype;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    protected static void verifySubtype(IMgram m, int subtype) throws EUnexpectedMgram, EMgramFormatError {
        try {
            if (m.getRawBody()[0] != subtype) {
                throw new EUnexpectedMgram(m);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR009"));
        }
    }

    protected final IMgram buildChallenge1() throws EInauthenticClient {
        this.m_passiveNonce = new byte[16];
        ProgressSecureRandom.theSecureRandom().nextBytes(this.m_passiveNonce);
        if (this.DEBUG) {
            this.debug("built passive nonce: " + this.m_passiveNonce);
        }
        byte[] payload = new byte[17];
        payload[0] = 4;
        this.DESEncrypt(this.m_passiveNonce, 0, payload, 1, 16);
        return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
    }

    private IMgram buildChallenge2(IMgram challenge1) throws EMgramFormatError, EInauthenticClient {
        try {
            this.m_passiveNonce = new byte[16];
            byte[] src = challenge1.getRawBody();
            this.DESDecrypt(src, 1, this.m_passiveNonce, 0, 16);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR011"));
        }
        this.m_activeNonce = new byte[16];
        ProgressSecureRandom.theSecureRandom().nextBytes(this.m_activeNonce);
        this.serializeSSLCertificate();
        this.m_challenge2Data = new byte[16 + PADDED_HASH_LENGTH];
        System.arraycopy(this.m_activeNonce, 0, this.m_challenge2Data, 0, 16);
        ISHA sha = this.initSha();
        byte[] hash = sha.digest();
        System.arraycopy(hash, 0, this.m_challenge2Data, 16, hash.length);
        if (this.DEBUG) {
            this.debug("built challenge 2 data: " + Hex.toString(this.m_challenge2Data));
        }
        byte[] payload = new byte[this.m_challenge2Data.length + 1];
        payload[0] = 5;
        this.DESEncrypt(this.m_challenge2Data, 0, payload, 1, this.m_challenge2Data.length);
        return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
    }

    private IMgram buildResponse(IMgram challenge2) throws EInauthenticClient, EInauthenticBroker, EMgramFormatError, EInvalidCipherSuiteException {
        if (this.m_user == null) {
            throw new EInauthenticClient();
        }
        try {
            this.m_challenge2Data = new byte[challenge2.getBodyLength() - 1];
            if (this.m_challenge2Data.length % 8 != 0) {
                throw new EMgramFormatError(prAccessor.getString("STR013"));
            }
            byte[] src = challenge2.getRawBody();
            this.DESDecrypt(src, 1, this.m_challenge2Data, 0, this.m_challenge2Data.length);
            if (this.DEBUG) {
                this.debug("received challenge 2 data: " + Hex.toString(this.m_challenge2Data));
            }
            this.m_activeNonce = new byte[16];
            System.arraycopy(this.m_challenge2Data, 0, this.m_activeNonce, 0, 16);
            this.serializeSSLCertificate();
            ISHA sha = this.initSha();
            byte[] hash = sha.digest();
            if (!this.arrayCompare(this.m_challenge2Data, 16, hash, 0, hash.length)) {
                throw new EInauthenticClient();
            }
            if (this.m_brokerCipherSuite == null) {
                throw new EInvalidCipherSuiteException("Unable to find broker side Cipher Suite");
            }
            this.m_masterSecret = new byte[48];
            ProgressSecureRandom.theSecureRandom().nextBytes(this.m_masterSecret);
            byte[] cipherSuiteInfoInBytes = null;
            if (this.m_brokerCipherSuite.isSonicCipherSuite()) {
                this.m_responseData = new byte[48 + PADDED_HASH_LENGTH];
            } else {
                try {
                    CipherSuiteInfo cipherInfo = this.m_brokerCipherSuite.getCipherSuiteInfo();
                    byte[] byteData = null;
                    byteData = this.m_incomingClientVer < 32 ? cipherInfo.writeBytesWithoutKeySize() : cipherInfo.writeBytes();
                    int size = byteData.length + ConnectHandshaker.computePad(byteData.length);
                    cipherSuiteInfoInBytes = new byte[size];
                    System.arraycopy(byteData, 0, cipherSuiteInfoInBytes, 0, byteData.length);
                }
                catch (IOException ex) {
                    SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                    throw new EInvalidCipherSuiteException("Unable to get Broker side cipher information");
                }
                this.m_responseData = new byte[48 + PADDED_HASH_LENGTH + cipherSuiteInfoInBytes.length];
            }
            System.arraycopy(this.m_masterSecret, 0, this.m_responseData, 0, 48);
            hash = this.createHash(sha);
            System.arraycopy(hash, 0, this.m_responseData, 48, hash.length);
            if (this.m_responseData.length > 48 + PADDED_HASH_LENGTH) {
                if (cipherSuiteInfoInBytes == null) {
                    throw new NullPointerException("'cipherSuiteInfoInBytes' in " + this.getClass().getName() + ".buildResponse(final IMgram challenge2) cannot be null!");
                }
                int destPos = 48 + PADDED_HASH_LENGTH;
                System.arraycopy(cipherSuiteInfoInBytes, 0, this.m_responseData, destPos, cipherSuiteInfoInBytes.length);
            }
            byte[] payload = new byte[this.m_responseData.length + 1];
            payload[0] = 6;
            this.DESEncrypt(this.m_responseData, 0, payload, 1, this.m_responseData.length);
            return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR013"));
        }
    }

    private ISHA initSha() {
        ISHA sha = (ISHA)this.newInstance(SHA_CLASS);
        sha.add(this.m_passiveNonce);
        sha.add(this.m_activeNonce);
        sha.add(this.m_certBytes);
        return sha;
    }

    private void traceCertBytes() {
        Debug.trace("Certs bytes: " + this.m_certBytes + ", size: " + this.m_certBytes.length);
        if (this.m_certBytes != null) {
            Debug.trace(Hex.toString(this.m_certBytes));
        }
    }

    private void serializeSSLCertificate() {
        try {
            this.serializeCert();
        }
        catch (IOException e) {
            SessionConfig.logMessage(prMessageFormat.format(prAccessor.getString("STR012"), new Object[]{this.m_cert.toString(), e.toString()}), SessionConfig.getLevelWarning());
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            this.m_certBytes = new byte[0];
        }
    }

    protected final byte[] getHash(int length) {
        byte[] hash = new byte[length];
        for (int i = 0; i < length; ++i) {
            hash[i] = (byte)i;
        }
        return hash;
    }

    private void verifyResponse(IMgram response) throws EInauthenticClient, EInauthenticBroker, EMgramFormatError, EInvalidCipherSuiteException {
        if (this.m_user == null) {
            throw new EInauthenticClient();
        }
        try {
            this.m_responseData = new byte[response.getBodyLength() - 1];
            if (this.m_responseData.length % 8 != 0) {
                throw new EMgramFormatError(prAccessor.getString("STR016"));
            }
            byte[] src = response.getRawBody();
            this.DESDecrypt(src, 1, this.m_responseData, 0, this.m_responseData.length);
            this.m_masterSecret = new byte[48];
            System.arraycopy(this.m_responseData, 0, this.m_masterSecret, 0, 48);
            ISHA sha = (ISHA)this.newInstance(SHA_CLASS);
            byte[] hash = null;
            hash = this.m_uid.equals("AUTHENTICATED") ? this.getHash(20) : this.createHash(sha);
            if (!this.arrayCompare(hash, 0, this.m_responseData, 48, hash.length)) {
                throw new EInauthenticBroker();
            }
            CipherSuiteInfo cipherInfo = null;
            try {
                if (this.m_responseData.length > 48 + PADDED_HASH_LENGTH) {
                    cipherInfo = new CipherSuiteInfo();
                    int srcPos = 48 + PADDED_HASH_LENGTH;
                    int length = this.m_responseData.length - srcPos;
                    byte[] rawData = new byte[length];
                    int destPos = 0;
                    System.arraycopy(this.m_responseData, srcPos, rawData, destPos, length);
                    cipherInfo.readBytes(rawData);
                }
                if (cipherInfo == null) {
                    this.m_clientCipherSuite = SonicCipherSuite.getInstance();
                } else {
                    String[] cipherDetails = null;
                    String[] digestDetails = null;
                    cipherDetails = cipherInfo.getTransformation(0);
                    if (cipherDetails == null || cipherDetails.length < 3 || cipherDetails[2] == null || cipherDetails[2].trim().length() == 0) {
                        throw new EInvalidCipherSuiteException("Invalid cipher transformation. Default not found");
                    }
                    String[] cipherAndKeySize = AbstractCipherSuite.getTransformationAndKeySize(cipherDetails[2]);
                    if (cipherAndKeySize == null || cipherAndKeySize.length == 0 || cipherAndKeySize[0] == null) {
                        throw new EInvalidCipherSuiteException("Invalid transformation " + cipherDetails[2]);
                    }
                    String transformation = cipherAndKeySize[0];
                    String s = cipherAndKeySize[1];
                    int keySize = 0;
                    if (s != null) {
                        keySize = Integer.parseInt(s);
                    }
                    if ((digestDetails = cipherInfo.getDigest(0)) == null || digestDetails.length < 3 || digestDetails[2] == null || digestDetails[2].trim().length() == 0) {
                        throw new EInvalidCipherSuiteException("Invalid digest. Default not found");
                    }
                    this.m_clientCipherSuite = AbstractCipherSuite.getCipherSuiteInstance(cipherDetails[0], cipherDetails[1], transformation, keySize, digestDetails[0], digestDetails[1], digestDetails[2]);
                }
            }
            catch (IOException ex) {
                SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                throw new EInvalidCipherSuiteException("Unable to read cipher suite information received. " + ex.getMessage());
            }
            catch (IndexOutOfBoundsException ex) {
                SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                throw new EInvalidCipherSuiteException("Unable to read cipher suite information received. " + ex.getMessage());
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new EMgramFormatError(prAccessor.getString("STR016") + " " + e.getMessage());
        }
        catch (EInvalidCipherSuiteException ex) {
            throw ex;
        }
    }

    private byte[] createHash(ISHA sha) {
        sha.add(this.m_activeNonce);
        sha.add(this.m_masterSecret);
        return sha.digest();
    }

    protected final IMgram buildSecDisabledMgram() {
        byte[] payload = new byte[]{8};
        return MgramFactory.getMgramFactory().buildConnectMgram(payload, 0);
    }

    protected boolean arrayCompare(byte[] a1, int off1, byte[] a2, int off2, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                if (a1[i + off1] == a2[i + off2]) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private void serializeCert() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.m_cert);
        this.m_certBytes = bos.toByteArray();
    }

    protected final void DESEncrypt(byte[] src, int srcOffset, byte[] dest, int destOffset, int length) throws EInauthenticClient {
        IDES des = this.validateUserCopyAndGetIDES();
        des.init(1, this.m_pwKey);
        this.debugKey(false);
        des.doFinal(src, srcOffset, length, dest, destOffset);
    }

    private void DESDecrypt(byte[] src, int srcOffset, byte[] dest, int destOffset, int length) throws EInauthenticClient {
        IDES des = this.validateUserCopyAndGetIDES();
        des.init(2, this.m_pwKey);
        this.debugKey(false);
        des.doFinal(src, srcOffset, length, dest, destOffset);
    }

    private void debugKey(boolean DEBUG_CR_DECRYPT) {
    }

    private IDES validateUserCopyAndGetIDES() throws EInauthenticClient {
        if (this.m_user == null) {
            throw new EInauthenticClient();
        }
        System.arraycopy(this.m_user.getTestPattern(), 6, this.m_pwKey, 0, 8);
        IDES des = (IDES)this.newInstance(DES_CLASS);
        return des;
    }

    protected static final int computePad(int dataSize) {
        int pad = 0;
        int invpad = dataSize % 8;
        if (invpad > 0) {
            pad = 8 - invpad;
        }
        return pad;
    }

    protected Object newInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            throw new EAssertFailure(e.toString());
        }
    }

    protected final String resolveState(int state) {
        return "";
    }
}

