/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import progress.message.util.AutoVec;
import progress.message.zclient.Connection;
import progress.message.zclient.ConnectionContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SocketDropHandler;

public class DefaultDropHandler
extends SocketDropHandler {
    private boolean _enteredOnce = false;
    private Connection _con;

    public DefaultDropHandler(Connection con) {
        super("DefaultDropHandler");
        this._con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void socketDropped(int errcode, int errinfo, ConnectionContext sockContext) {
        DebugObject debugObject = this;
        synchronized (debugObject) {
            if (this._enteredOnce) {
                return;
            }
            this._enteredOnce = true;
        }
        debugObject = this._con;
        synchronized (debugObject) {
            Connection c;
            int statcode;
            AutoVec cloned = this._con.cloneBrethren();
            Enumeration enu = cloned.elements();
            int n = statcode = errinfo == -3 ? errinfo : errcode;
            while (enu.hasMoreElements()) {
                c = (Connection)enu.nextElement();
                if (c == null) continue;
                c.setConnectionDropped();
                c.setUnconnected();
                c.terminateSyncOps(statcode);
                if (c.getConnectionInfo() == null) continue;
                c.getConnectionInfo().notifyConnectionDropped();
            }
            enu = cloned.elements();
            while (enu.hasMoreElements()) {
                c = (Connection)enu.nextElement();
                if (c == null) continue;
                c.dropConnection(errcode, errinfo);
            }
        }
    }
}

