/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.Serializable;
import java.util.Vector;
import progress.message.zclient.SessionConfig;

public class FastVector
implements Cloneable,
Serializable {
    public Object[] m_data;
    public int m_count;
    private static final int DEFAULT_SIZE = 8;

    public FastVector() {
        this.m_data = new Object[8];
    }

    public FastVector(int capacity) {
        this.m_data = new Object[capacity];
    }

    public FastVector(FastVector v) {
        this.m_count = v.m_count;
        this.m_data = v.m_data;
    }

    public FastVector(Vector v) {
        try {
            this.m_data = new Object[v.size()];
            v.copyInto(this.m_data);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.m_count = v.size();
    }

    public void addElement(Object obj) {
        if (this.m_data.length == this.m_count) {
            int size = this.m_data.length << 1;
            if (size == 0) {
                size = 8;
            }
            this.initData(size);
        }
        this.m_data[this.m_count++] = obj;
    }

    public Object[] toArray() {
        Object[] a = new Object[this.m_count];
        System.arraycopy(this.m_data, 0, a, 0, this.m_count);
        return a;
    }

    public Object clone() {
        FastVector v = new FastVector(this);
        v.m_data = new Object[this.m_count];
        System.arraycopy(this.m_data, 0, v.m_data, 0, this.m_count);
        return v;
    }

    public Vector makeVector() {
        Vector<Object> v = new Vector<Object>(this.m_count);
        try {
            for (int i = 0; i < this.m_count; ++i) {
                v.addElement(this.m_data[i]);
            }
        }
        catch (IndexOutOfBoundsException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        return v;
    }

    public void append(FastVector v) {
        int newlength;
        if (v.m_count == 0) {
            return;
        }
        for (newlength = this.m_data.length; v.m_count + this.m_count >= newlength; newlength <<= 1) {
        }
        if (newlength != this.m_data.length) {
            this.initData(newlength);
        }
        System.arraycopy(v.m_data, 0, this.m_data, this.m_count, v.m_count);
        this.m_count += v.m_count;
    }

    private void initData(int newlength) {
        Object[] newdata = new Object[newlength];
        System.arraycopy(this.m_data, 0, newdata, 0, this.m_count);
        this.m_data = newdata;
    }

    public void removeElementAt(int i) {
        System.arraycopy(this.m_data, i + 1, this.m_data, i, this.m_count - i - 1);
        --this.m_count;
    }

    public final int indexOf(Object elem, int index) {
        for (int i = index; i < this.m_count; ++i) {
            if (!elem.equals(this.m_data[i])) continue;
            return i;
        }
        return -1;
    }

    public void empty() {
        this.m_data = new Object[8];
        this.m_count = 0;
    }
}

