/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.ETimeout;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IJobCompletionListener;

public abstract class Job
extends DebugObject {
    protected int m_status = 2;
    protected String m_message;
    private boolean m_unrecoverable = false;
    private IJobCompletionListener m_listener;
    public static final int SUCCESS = 0;
    public static final int RUNNING = 1;
    public static final int SUSPENDED = 2;
    public static final int UNINITIALIZED = 3;
    public static final int ERROR = -1;
    public static final int ERROR_PRIVACY_FAILED = -2;
    public static final int ERROR_INTEGRITY_FAILED = -3;
    public static final int ERROR_NONREPUDIATION_FAILED = -4;
    public static final int ERROR_CONNECTION_DROPPED = -5;
    public static final int ERROR_PUBLISH_NOT_AUTHORIZED = -6;
    public static final int ERROR_SUBSCRIBE_NOT_AUTHORIZED = -7;
    public static final int ERROR_GUARANTEE_NOT_AUTHORIZED = -8;
    public static final int ERROR_WRONG_SUBJECT_ADDR = -9;
    public static final int ERROR_GENERAL_SECURITY_ERR = -10;
    public static final int ERROR_TXN_NOT_FOUND = -11;
    public static final int ERROR_TXN_ACCESS_VIOLATION = -12;
    public static final int ERROR_TXN_SEQUENCE_ERR = -13;
    public static final int ERROR_REQUEST_NOSUB_FOR_SUBJECT = -14;
    public static final int ERROR_QUEUE_NOT_FOUND = -15;
    public static final int ERROR_TOO_LARGE_FOR_QUEUE = -16;
    public static final int ERROR_CONNECTION_CLOSING = -17;
    public static final int ERROR_QUEUE_MSG_NACKED_WHILE_FLOW_CONTROL_DISABLED = -18;
    public static final int ERROR_STORE_ERR = -19;
    public static final int ERROR_STORE_INIT_ERR = -20;
    public static final int ERROR_STORE_SIZE_EXCEEDED_ERR = -21;
    public static final int ERROR_INVALID_SELECTOR_ERR = -22;
    public static final int ERROR_TOPIC_MSG_NACKED_WHILE_FLOW_CONTROL_DISABLED = -23;
    public static final int ERROR_INVALID_TTL = -24;
    public static final int ERROR_OLD_VIRTUAL_CLOCK = -25;
    public static final int ERROR_UNDELIVERED_DESTINATION_NOT_AUTHORIZED = -26;
    public static final int ERROR_PUBLISH_INVALID_NODE = -27;
    public static final int ERROR_UNDELIVERED_DESTINATION_INVALID_NODE = -28;
    public static final int ERROR_HTTP_OVERRIDE_DESTINATION_NOT_AUTHORIZED = -29;
    public static final int ERROR_HTTP_NODE_URL_NOT_AUTHORIZED = -30;
    public static final int ERROR_PUBLISH_INVALID_HTTP_DESTINATION_OVERRIDE = -31;
    public static final int ERROR_CONNECTION_UNRESUMABLE = -39;
    public static final int ERROR_BROKER_EXCEPTION = -40;
    public static final int ERROR_DELIVERY_LIMIT_EXCEEDED = -41;
    public static final int ERROR_DELIVERY_TIMEOUT_ON_CLOSE = -42;
    public static final int ERROR_NO_ROOM_IN_DB = -43;
    public static final int ERROR_INVALID_ENTERPRISE_LICENSE = -44;

    public void setUnrecoverable(boolean unrecoverable) {
        this.m_unrecoverable = unrecoverable;
    }

    public boolean getUnrecoverable() {
        return this.m_unrecoverable;
    }

    public abstract void start() throws EGeneralException;

    public abstract void suspend();

    public abstract void cancel() throws EGeneralException;

    public abstract void resolve();

    public synchronized void join() throws EInterrupted, EGeneralException {
        String savedThreadName = null;
        try {
            savedThreadName = this.setThreadName();
            while (this.m_status > 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
        finally {
            this.restoreThreadName(savedThreadName);
        }
    }

    public void setJobCompletionListener(IJobCompletionListener listener) {
        this.m_listener = listener;
    }

    public void join(int seconds) throws EInterrupted, EGeneralException, ETimeout {
        this.joinMillis(seconds * 1000);
    }

    synchronized void joinMillis(long millis) throws EInterrupted, EGeneralException, ETimeout {
        String savedThreadName = null;
        try {
            savedThreadName = this.setThreadName();
            long starttime = System.currentTimeMillis();
            long endtime = starttime + millis;
            while (this.m_status > 0 && starttime < endtime) {
                this.wait(endtime - starttime);
                starttime = System.currentTimeMillis();
            }
            if (this.m_status > 0) {
                String jobInfo = this.DEBUG ? this.getDiagnosticThreadInfo() : this.getClass().getSimpleName();
                throw new ETimeout("Timeout while waiting for " + jobInfo);
            }
        }
        catch (InterruptedException e) {
            throw new EInterrupted();
        }
        finally {
            this.restoreThreadName(savedThreadName);
        }
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public synchronized String getMessage() {
        return this.m_message;
    }

    public synchronized boolean isRunning() {
        return this.m_status == 1;
    }

    public synchronized boolean isComplete() {
        return this.m_status == 0;
    }

    public synchronized boolean isSuspended() {
        return this.m_status == 2;
    }

    public synchronized boolean isError() {
        return this.m_status < 0;
    }

    public final void setStatus(int status) {
        this.setStatus(status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status, String message) {
        Job job = this;
        synchronized (job) {
            this.m_status = status;
            this.m_message = message;
            this.notifyAll();
        }
        if (this.m_listener != null && status < 1) {
            this.m_listener.onJobComplete(this);
        }
    }

    private String setThreadName() {
        String diagThreadInfo;
        String savedThreadName = null;
        if (DebugState.GLOBAL_DEBUG_ON && this.checkDebugFlags(32768) && (diagThreadInfo = this.getDiagnosticThreadInfo()) != null) {
            savedThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName(savedThreadName + " [" + diagThreadInfo + ']');
        }
        return savedThreadName;
    }

    private void restoreThreadName(String savedThreadName) {
        if (savedThreadName != null) {
            Thread.currentThread().setName(savedThreadName);
        }
    }

    protected String getDiagnosticThreadInfo() {
        return null;
    }

    @Override
    public String toString() {
        String info = this.getDiagnosticThreadInfo();
        if (info == null) {
            info = this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
        }
        return info + " -- status: " + this.m_status;
    }
}

