/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security.cert;

import java.io.File;
import java.text.MessageFormat;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.ProgressSslSocketFactory;
import progress.message.security.cert.ECertificateException;
import progress.message.security.cert.X500Name;
import progress.message.security.cert.prAccessor;

public abstract class X509Certificate
extends java.security.cert.X509Certificate {
    public static final X509Certificate loadCertificate(File file) throws ESocketConfigException {
        return ProgressSslSocketFactory.getSSLImpl().loadCertificate(file);
    }

    public static final X509Certificate loadCertificate(String file) throws ESocketConfigException {
        return ProgressSslSocketFactory.getSSLImpl().loadCertificate(file);
    }

    public X500Name getSubjectName() throws ECertificateException {
        String msg = prAccessor.getString(prAccessor.getString("STR143"));
        Object[] obj = new Object[]{"getSubjectName"};
        throw new ECertificateException(MessageFormat.format(msg, obj));
    }

    public X500Name getIssuerName() throws ECertificateException {
        String msg = prAccessor.getString(prAccessor.getString("STR143"));
        Object[] obj = new Object[]{"getIssuerName"};
        throw new ECertificateException(MessageFormat.format(msg, obj));
    }

    public String getIssuerCommonName() throws ECertificateException {
        String msg = prAccessor.getString(prAccessor.getString("STR143"));
        Object[] obj = new Object[]{"getIssuerCommonName"};
        throw new ECertificateException(MessageFormat.format(msg, obj));
    }

    public String getSubjectCommonName() throws ECertificateException {
        String msg = prAccessor.getString(prAccessor.getString("STR143"));
        Object[] obj = new Object[]{"getSubjectCommonName"};
        throw new ECertificateException(MessageFormat.format(msg, obj));
    }

    protected static ECertificateException getECertificateException(String methodName) {
        String msg = prAccessor.getString("STR143");
        Object[] obj = new Object[]{methodName};
        ECertificateException ex = new ECertificateException(MessageFormat.format(msg, obj));
        return ex;
    }
}

