/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Objects;
import progress.message.zclient.SessionConfig;

public class VersionData
implements Cloneable {
    private String m_name;
    private short m_majorVersion;
    private byte m_minorVersion;
    private byte m_pointVersion;
    private int m_buildNumber;

    public VersionData(String name, short majorVers, byte minorVers, byte point, int build) {
        this.m_name = name;
        this.m_majorVersion = majorVers;
        this.m_minorVersion = minorVers;
        this.m_pointVersion = point;
        this.m_buildNumber = build;
    }

    public String getName() {
        return this.m_name;
    }

    public int getMajorNumber() {
        return this.m_majorVersion;
    }

    public int getBuildNumber() {
        return this.m_buildNumber;
    }

    public String getReleaseAndBuildString() {
        if (this.m_majorVersion == 0) {
            return "";
        }
        String relname = this.m_majorVersion + "." + this.m_minorVersion + "." + this.m_pointVersion;
        return SessionConfig.buildReleaseName(relname, Integer.toString(this.m_buildNumber));
    }

    public String getReleaseString() {
        if (this.m_majorVersion == 0) {
            return "";
        }
        String relname = this.m_majorVersion + "." + this.m_minorVersion + "." + this.m_pointVersion;
        return relname;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VersionData dat = (VersionData)obj;
        if (this.m_majorVersion == 0) {
            return false;
        }
        return this.m_majorVersion == dat.m_majorVersion && this.m_minorVersion == dat.m_minorVersion && this.m_pointVersion == dat.m_pointVersion && this.m_buildNumber == dat.m_buildNumber;
    }

    public int hashCode() {
        return Objects.hash(this.m_majorVersion, this.m_minorVersion, this.m_pointVersion, this.m_buildNumber);
    }

    public boolean isLT(VersionData dat) {
        if (this.m_majorVersion < dat.m_majorVersion) {
            return true;
        }
        if (this.m_majorVersion == dat.m_majorVersion) {
            if (this.m_minorVersion < dat.m_minorVersion) {
                return true;
            }
            if (this.m_minorVersion == dat.m_minorVersion) {
                if (this.m_pointVersion < dat.m_pointVersion) {
                    return true;
                }
                if (this.m_pointVersion == dat.m_pointVersion) {
                    return this.m_buildNumber < dat.m_buildNumber;
                }
            }
        }
        return false;
    }

    public boolean isGT(VersionData dat) {
        if (this.m_majorVersion > dat.m_majorVersion) {
            return true;
        }
        if (this.m_majorVersion == dat.m_majorVersion) {
            if (this.m_minorVersion > dat.m_minorVersion) {
                return true;
            }
            if (this.m_minorVersion == dat.m_minorVersion) {
                if (this.m_pointVersion > dat.m_pointVersion) {
                    return true;
                }
                if (this.m_pointVersion == dat.m_pointVersion) {
                    return this.m_buildNumber > dat.m_buildNumber;
                }
            }
        }
        return false;
    }

    public String toString() {
        if (this.m_majorVersion == 0) {
            return "";
        }
        return "VersionData: " + this.m_majorVersion + "." + this.m_minorVersion + "." + this.m_pointVersion + "." + this.m_buildNumber;
    }

    public static String getReleaseString(VersionData dat, String unknown) {
        if (dat == null || dat.m_majorVersion == 0) {
            return unknown;
        }
        return dat.getReleaseString();
    }

    public static String getReleaseAndBuildString(VersionData dat, String unknown) {
        if (dat == null || dat.m_majorVersion == 0) {
            return unknown;
        }
        return dat.getReleaseAndBuildString();
    }

    public Object clone() {
        VersionData clone = null;
        try {
            clone = (VersionData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

