/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.jclient;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Topic;
import progress.message.client.prAccessor;
import progress.message.jclient.DestinationFactory;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.DurableSubscriber;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.TopicSubscriber;
import progress.message.zclient.Subject;

public final class SharedSubscriptionUtil {
    private static final String MESSAGE_CANNOT_CHANGE_MESSAGE_SELECTOR = "The message selector of an active consumer cannot be changed";
    private static final String MESSAGE_CANNOT_CHANGE_TOPIC = "The topic of an active consumer cannot be changed";
    private static final String MESSAGE_ERROR_GETTING_TOPIC_FROM_CLOSING_SUBSCRIBER = "Error getting topic from closed subscriber";
    private static final String MESSAGE_ACTIVE_UNSHARED_DURABLE_CONSUMER_USING_THE_SAME_NAME = "There is an active unshared durable consumer using the same name";
    private static final String MESSAGE_SHARED_SUBSCRIPTION_NAME_CANNOT_BE_NULL = "Shared subscription name cannot be null";
    private static final String MESSAGE_KEY_DEST_NULL = "DEST_NULL";

    private SharedSubscriptionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void checkSharedSubscriptionRequest(Topic topic, String sharedSubscriptionName, String messageSelector, String clientId, List<MessageConsumer> nonDurableConsumers) throws JMSException {
        Optional<TopicSubscriber> matchingSubscriber = nonDurableConsumers.stream().filter(messageConsumer -> SharedSubscriptionUtil.isMatchingSharedSubscription(messageConsumer, clientId, sharedSubscriptionName)).map(messageConsumer -> (TopicSubscriber)messageConsumer).findFirst();
        if (matchingSubscriber.isPresent()) {
            TopicSubscriber consumer = matchingSubscriber.get();
            String consumerMessageSelector = consumer.getMessageSelector();
            SharedSubscriptionUtil.checkMessageSelectorDiffers(messageSelector, consumerMessageSelector);
            SharedSubscriptionUtil.checkTopicDiffers(topic, consumer.getTopic());
        }
    }

    private static boolean isMatchingSharedSubscription(MessageConsumer messageConsumer, String clientId, String subscriptionName) {
        if (messageConsumer instanceof TopicSubscriber) {
            TopicSubscriber subscriber = (TopicSubscriber)messageConsumer;
            try {
                if (!subscriber.isClosing() && subscriber.getTopic() instanceof progress.message.jimpl.Topic) {
                    progress.message.jimpl.Topic subscriberTopic = (progress.message.jimpl.Topic)subscriber.getTopic();
                    boolean isSameSubscriptionName = subscriptionName.equals(subscriberTopic.getGroupName());
                    boolean isSameClientId = Objects.equals(clientId, subscriber.getConnection().getClientID());
                    return isSameClientId && isSameSubscriptionName;
                }
            }
            catch (JMSException jmsex) {
                throw new RuntimeException(MESSAGE_ERROR_GETTING_TOPIC_FROM_CLOSING_SUBSCRIBER, jmsex);
            }
        }
        return false;
    }

    private static void checkMessageSelectorDiffers(String messageSelector, String otherMessageSelector) throws InvalidSelectorException {
        boolean isSameMessageSelector = Objects.equals(messageSelector, otherMessageSelector);
        if (!isSameMessageSelector) {
            throw new InvalidSelectorException(MESSAGE_CANNOT_CHANGE_MESSAGE_SELECTOR);
        }
    }

    private static void checkTopicDiffers(Topic topic, Topic otherTopic) throws JMSException {
        boolean isSameTopicName = Objects.equals(topic.getTopicName(), otherTopic.getTopicName());
        if (!isSameTopicName) {
            throw new InvalidDestinationException(MESSAGE_CANNOT_CHANGE_TOPIC);
        }
    }

    public static void checkSharedDurableSubscriptionRequest(Topic topic, String sharedSubscriptionName, String messageSelector, String clientId, Map<String, DurableSubscriber> durableSubscribers) throws JMSException {
        DurableSubscriber activeSubscriber = durableSubscribers.get(sharedSubscriptionName);
        if (activeSubscriber != null && !activeSubscriber.isClosing()) {
            progress.message.jimpl.Topic activeSubscriberTopic = (progress.message.jimpl.Topic)activeSubscriber.getTopic();
            if (!activeSubscriberTopic.getSubject().hasGroup()) {
                throw new JMSException(MESSAGE_ACTIVE_UNSHARED_DURABLE_CONSUMER_USING_THE_SAME_NAME);
            }
            SharedSubscriptionUtil.checkTopicDiffers(topic, activeSubscriberTopic);
            SharedSubscriptionUtil.checkMessageSelectorDiffers(messageSelector, activeSubscriber.getMessageSelector());
        }
    }

    public static progress.message.jimpl.Destination convertToConsumerDestination(Destination destination, Connection connection) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException(prAccessor.getString(MESSAGE_KEY_DEST_NULL));
        }
        progress.message.jimpl.Destination convertedDestination = (progress.message.jimpl.Destination)DestinationFactory.createSonicDestination(destination);
        convertedDestination.validateForConsume(connection);
        return convertedDestination;
    }

    public static progress.message.jimpl.Topic createSharedTopic(Topic topic, String sharedSubscriptionName, Connection connection) throws JMSException {
        if (sharedSubscriptionName == null) {
            throw new InvalidDestinationException(MESSAGE_SHARED_SUBSCRIPTION_NAME_CANNOT_BE_NULL);
        }
        DestUtil.validateGroupPrefix(sharedSubscriptionName);
        progress.message.jimpl.Topic destination = (progress.message.jimpl.Topic)SharedSubscriptionUtil.convertToConsumerDestination(topic, connection);
        Subject subject = (Subject)destination.getSubject();
        subject.setGroupName(sharedSubscriptionName);
        return destination;
    }
}

