/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf;

import com.sonicsw.sdf.DiagnosticsManagerAccess;
import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IDiagnosticsManager;
import com.sonicsw.sdf.IDiagnosticsProvider;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.ITracer;
import com.sonicsw.sdf.WriterUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractDiagnosticsProvider
implements IDiagnosticsProvider,
IDiagnosticsConstants {
    public static final String NON_TRACE_LEVEL = "no_trace";
    public static final String BASIC_TRACE_LEVEL = "basic_trace";
    public static final String VERBOSE_TRACE_LEVEL = "verbose_trace";
    public static final String OP_PARAM_OVERWRITE = "overwrite";
    public static final String OP_PARAM_OUTPUT_LOCATION = "output";
    public static final String OP_PARAM_FILE_ACCESS = "output_access";
    public static String OP_PARAM_OVERWRITE_DESCRIPTION;
    public static String OP_PARAM_OUTPUT_LOCATION_DESCRIPTION;
    public static String OP_PARAM_FILE_ACCESS_DESCRIPTION;
    private static String[] OPERATIONS;
    private static String TRACE_LEVEL_PARAM_DESCRIPTION;
    private static HashMap UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR;
    private static HashMap PARAM_DESCRIPTOR;
    protected String m_traceLevel;
    protected String m_stateDescription;
    protected String m_subsystemName;
    protected String m_subsystemID;
    protected IDiagnosticsContext m_diagnosticsContext;
    protected ITracer m_tracer;

    public AbstractDiagnosticsProvider(String subsystemName) {
        this.m_subsystemName = subsystemName;
        this.m_traceLevel = NON_TRACE_LEVEL;
        this.m_diagnosticsContext = null;
        this.m_tracer = null;
        this.m_stateDescription = "initialState";
        this.m_subsystemID = null;
    }

    public IDiagnosticsContext register() {
        IDiagnosticsManager manager = DiagnosticsManagerAccess.getManager();
        if (manager == null) {
            return DiagnosticsManagerAccess.createContext(this);
        }
        this.m_diagnosticsContext = manager.register(this);
        return this.m_diagnosticsContext;
    }

    @Override
    public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
        this.m_traceLevel = (String)parameters.get("stringTraceLevel");
        if (this.m_traceLevel == null) {
            return;
        }
        if (this.m_traceLevel.equalsIgnoreCase(NON_TRACE_LEVEL)) {
            if (this.m_tracer != null) {
                this.m_tracer.close();
            }
            return;
        }
        try {
            if (this.m_tracer == null) {
                this.m_tracer = this.m_diagnosticsContext.getTracer();
            }
            buffer.append("Tracer file for '").append(this.m_subsystemName).append("' is '").append(this.m_tracer.getFilePath()).append("'");
            this.m_tracer.trace("Start tracing with tracing level '" + this.m_traceLevel + "'", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            buffer.append(e.toString());
        }
    }

    @Override
    public void showTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
        buffer.append("Trace level is: " + this.m_traceLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendStateDump(String doiID, HashMap parameters, StringBuffer buffer) {
        try (IStateWriter writer = null;){
            writer = this.m_diagnosticsContext.getStateWriter();
            String instruction = WriterUtil.rebuildInstruction(this, "dumpState", parameters);
            WriterUtil.writeHeader(writer, instruction, null);
            writer.write(this.m_stateDescription);
            WriterUtil.writeFooter(writer, null);
        }
        buffer.append("State written to file ").append(writer.getFilePath());
        writer.close();
    }

    @Override
    public void test(HashMap parameters, StringBuffer buffer) {
        buffer.append(this.getClass().getName()).append(" does not implement test()");
    }

    @Override
    public String getSubsystemName() {
        return this.m_subsystemName;
    }

    @Override
    public String getSubsystemID() {
        return this.m_subsystemID;
    }

    @Override
    public String describe() {
        return "Replace this with a text decription of the subsystem";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    public String[] getDOInstances() {
        return null;
    }

    @Override
    public HashMap describeParameters(String operationName) {
        return (HashMap)PARAM_DESCRIPTOR.get(operationName);
    }

    @Override
    public void executeOperation(String doiID, String operation, HashMap parameters, StringBuffer buffer) {
        buffer.append(this.getClass().getName()).append(" does not implement '").append(operation).append("'");
    }

    public static String[] toOpnameArray(HashMap paramDescriptor) {
        ArrayList list = new ArrayList();
        Iterator iter = paramDescriptor.keySet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    protected void printFromFileToBuffer(String file, StringBuffer buffer) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append(NEWLINE);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR = new HashMap();
        DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();
        StringBuilder tmp = new StringBuilder();
        tmp.append("Values: ").append(NON_TRACE_LEVEL).append(" | ").append(BASIC_TRACE_LEVEL).append(" | ").append(VERBOSE_TRACE_LEVEL);
        TRACE_LEVEL_PARAM_DESCRIPTION = tmp.toString();
        tmp = new StringBuilder();
        tmp.append("Optional, Values: ").append("true").append(" | ").append("false").append("\n\tEstablishes if the dump file should be overwritten or not.").append("\n\texample: overwrite=true");
        OP_PARAM_OVERWRITE_DESCRIPTION = tmp.toString();
        tmp = new StringBuilder();
        tmp.append("Optional, home folder for the output files, it should have write access").append("\n\tchild folders will be created if necessary, default to").append("\n\tcontainer's home folder").append("\n\texample: output=/home/user/dumps ");
        OP_PARAM_OUTPUT_LOCATION_DESCRIPTION = tmp.toString();
        tmp = new StringBuilder();
        tmp.append("Optional, specify the dump file access permissions in the form").append("\n\tof 9 characters within 3 groups of 3 chars each for user-group-all").append("\n\taccess being 'r' read, 'w' write and 'x' execute, if no particular").append("\n\tpermission need to be set then use the character '-'").append("\n\texample: output_access=rw-r--r-- to set read to everyone and write").append("\n\tonly to the owner.\n\t");
        OP_PARAM_FILE_ACCESS_DESCRIPTION = tmp.toString();
        UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR.put("stringTraceLevel", TRACE_LEVEL_PARAM_DESCRIPTION);
        PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("updateTraceLevel", UPDATE_TRACE_LEVEL_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("listDiagnosticsInstances", LIST_DIAGNOSTICS_INSTANCES_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
    }
}

