/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import progress.message.client.prAccessor;
import progress.message.jclient.MultiTopic;
import progress.message.jimpl.Queue;

public abstract class DestinationFactory {
    public static final Topic createTopic(String topicName) throws JMSException {
        int multiIndex = topicName.indexOf("MULTITOPIC:");
        if (multiIndex == -1) {
            return new progress.message.jimpl.Topic(topicName);
        }
        String routing = null;
        String groupName = null;
        if (multiIndex > 0) {
            String preMulti = topicName.substring(0, multiIndex);
            if (preMulti.endsWith("::")) {
                routing = preMulti.substring(0, preMulti.length() - 2);
            }
            if (preMulti.startsWith("[[") && preMulti.endsWith("]]")) {
                groupName = preMulti.substring("[[".length(), preMulti.length() - "]]".length());
            }
            if (groupName == null && routing == null) {
                return new progress.message.jimpl.Topic(topicName);
            }
        }
        String mtString = topicName.substring(multiIndex + "MULTITOPIC:".length());
        progress.message.jimpl.MultiTopic mt = new progress.message.jimpl.MultiTopic(groupName, routing);
        int pos = 0;
        int nextTok = 0;
        while (nextTok != -1) {
            nextTok = mtString.indexOf("||", pos);
            String topString = null;
            topString = nextTok == -1 ? mtString.substring(pos) : mtString.substring(pos, nextTok);
            if (topString.length() > 0) {
                progress.message.jimpl.Topic t = new progress.message.jimpl.Topic(topString);
                if (routing != null && !t.hasRouting()) {
                    t.initRouting(routing);
                }
                if (groupName != null && !t.hasGroup()) {
                    t.initGroupName(groupName);
                }
                mt.add(t);
            }
            pos = nextTok + "||".length();
        }
        return mt;
    }

    public static final javax.jms.Queue createQueue(String queueName) throws JMSException {
        return new Queue(queueName);
    }

    public static final MultiTopic createMultiTopic() throws JMSException {
        return new progress.message.jimpl.MultiTopic();
    }

    public static final Destination createSonicDestination(Destination dest) throws JMSException {
        if (dest == null) {
            return null;
        }
        if (dest instanceof progress.message.jimpl.Destination) {
            return dest;
        }
        if (dest instanceof javax.jms.Queue) {
            return new Queue(((javax.jms.Queue)dest).getQueueName());
        }
        if (dest instanceof Topic) {
            return new progress.message.jimpl.Topic(((Topic)dest).getTopicName());
        }
        throw new InvalidDestinationException(prAccessor.getString("MSG_UNKNOWN_DEST_TYPE") + dest.getClass().getName());
    }
}

