/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.evs;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkInterceptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import progress.message.net.ProgressInetAddress;

public class ProgressEvsLinkInterceptor
implements INetworkLinkInterceptor {
    private static final ProgressEvsLinkInterceptor s_instance = new ProgressEvsLinkInterceptor();

    public static INetworkLinkInterceptor getInstance() {
        return s_instance;
    }

    @Override
    public void onLinkEstablished(IEvsNetworkLink link, String contextInfo) {
        if (ProgressInetAddress.debugIPAddress()) {
            ProgressInetAddress.showIPAddressDiagnostic("Link established (" + contextInfo + ") - local: " + link.getLocalInetAddress() + ":" + link.getLocalPort() + ", remote: " + link.getRemoteInetAddress() + ":" + link.getRemotePort());
        }
    }

    @Override
    public InetAddress getInetAddressByName(String host) throws EEvsIOException {
        try {
            return ProgressInetAddress.getByName(host).getDelegateInetAddress();
        }
        catch (UnknownHostException e) {
            throw new EEvsIOException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    public String getLocalHostName() {
        return ProgressInetAddress.getLocalHostName();
    }
}

