/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import progress.message.util.DebugState;

public enum DebugFormatter {
    SINGLE_THREAD(true),
    MULTI_THREAD(false);

    private final boolean disableThreadName;
    private static final ThreadLocal<DateFormat> DATE_PARSER_THREAD_LOCAL;

    private DebugFormatter(boolean disableThreadName) {
        this.disableThreadName = disableThreadName;
    }

    public String format(String message) {
        return this.format(message, true);
    }

    public String format(String message, boolean logTimestamp) {
        return this.format(null, message, logTimestamp);
    }

    public String format(String name, String message) {
        return this.format(name, message, true);
    }

    public String format(String name, String message, boolean logTimestamp) {
        return this.getMessageBuilder(name, logTimestamp).append(message).toString();
    }

    public StringBuilder getMessageBuilder(String name, boolean logTimestamp) {
        StringBuilder builder = new StringBuilder();
        if (logTimestamp) {
            builder.append("[").append(DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))).append("] ");
        }
        if (!this.disableThreadName && DebugState.getDebugThreadName()) {
            builder.append(Thread.currentThread().getName()).append(": ");
        }
        if (name != null) {
            builder.append(name).append(": ");
        }
        return builder;
    }

    static {
        DATE_PARSER_THREAD_LOCAL = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                if (dateFormat instanceof SimpleDateFormat) {
                    ((SimpleDateFormat)dateFormat).applyPattern("yy/MM/dd kk:mm:ss");
                }
                return dateFormat;
            }
        };
    }
}

