/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.jclient;

import java.io.DataOutput;
import java.io.IOException;
import javax.jms.MessageFormatException;

public class StreamMessageOutputStream {
    static final int TYPE_BOOLEAN = 0;
    static final int TYPE_BYTE = 1;
    static final int TYPE_SHORT = 2;
    static final int TYPE_CHAR = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_FLOAT = 6;
    static final int TYPE_DOUBLE = 7;
    static final int TYPE_STRING = 8;
    static final int TYPE_BYTES = 9;
    static final int TYPE_NULL = 10;
    private DataOutput m_dataout = null;

    public StreamMessageOutputStream(DataOutput out) {
        this.m_dataout = out;
    }

    public void writeBoolean(boolean value) throws IOException {
        this.m_dataout.writeByte(0);
        this.m_dataout.writeBoolean(value);
    }

    public void writeByte(byte value) throws IOException {
        this.m_dataout.writeByte(1);
        this.m_dataout.writeByte(value);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.m_dataout.writeByte(9);
        this.m_dataout.writeInt(value.length);
        this.m_dataout.write(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws IOException {
        this.m_dataout.writeByte(9);
        this.m_dataout.writeInt(length);
        this.m_dataout.write(value, offset, length);
    }

    public void writeChar(char value) throws IOException {
        this.m_dataout.writeByte(3);
        this.m_dataout.writeChar(value);
    }

    public void writeDouble(double value) throws IOException {
        this.m_dataout.writeByte(7);
        this.m_dataout.writeDouble(value);
    }

    public void writeFloat(float value) throws IOException {
        this.m_dataout.writeByte(6);
        this.m_dataout.writeFloat(value);
    }

    public void writeInt(int value) throws IOException {
        this.m_dataout.writeByte(4);
        this.m_dataout.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.m_dataout.writeByte(5);
        this.m_dataout.writeLong(value);
    }

    public void writeObject(Object value) throws IOException, MessageFormatException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value == null) {
            this.writeNull();
        } else {
            throw new MessageFormatException("");
        }
    }

    public void writeShort(short value) throws IOException {
        this.m_dataout.writeByte(2);
        this.m_dataout.writeShort(value);
    }

    public void writeString(String value) throws IOException {
        this.m_dataout.writeByte(8);
        this.m_dataout.writeUTF(value);
    }

    public void writeNull() throws IOException {
        this.m_dataout.writeByte(10);
    }
}

