/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.IOException;
import progress.message.net.ISocket;
import progress.message.zclient.ClientListener;
import progress.message.zclient.ClientSender;
import progress.message.zclient.Connection;

public class ConnectionContext {
    protected ClientSender m_sender;
    protected ClientListener m_listener;
    protected ISocket m_socket;
    protected boolean m_connectInProgress;
    private long m_socketId;

    public long getSocketId() {
        return this.m_socketId;
    }

    public void setSocketId(long id) {
        this.m_socketId = id;
    }

    public ISocket getSocket() {
        return this.m_socket;
    }

    public ClientSender getClientSender() {
        return this.m_sender;
    }

    public ClientListener getClientListener() {
        return this.m_listener;
    }

    public synchronized void setConnectInProgress() {
        this.m_connectInProgress = true;
        this.notifyAll();
    }

    public synchronized void clearConnectInProgress() {
        this.m_connectInProgress = false;
        this.notifyAll();
    }

    public synchronized void waitNoConnectInProgress() {
        while (this.m_connectInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException ioe) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void waitForPeersToTerminate() {
        Thread currentThread = Thread.currentThread();
        Thread pingThread = null;
        if (this.m_sender != null) {
            pingThread = this.m_sender.getPingThread();
        }
        boolean continueWhile = true;
        boolean wasInterrupted = false;
        do {
            try {
                if (this.m_listener != null && currentThread != this.m_listener) {
                    this.m_listener.join();
                }
                if (this.m_sender != null && currentThread != this.m_sender) {
                    this.m_sender.join();
                }
                if (pingThread != null && currentThread != pingThread) {
                    pingThread.join();
                }
                continueWhile = false;
            }
            catch (InterruptedException ie) {
                wasInterrupted = true;
            }
        } while (continueWhile);
        if (wasInterrupted) {
            currentThread.interrupt();
        }
    }

    public ConnectionContext(ISocket socket, ClientSender sender, ClientListener listener) {
        this.m_socket = socket;
        this.m_sender = sender;
        this.m_listener = listener;
    }

    protected void newChannel(Connection c, int chan) {
        this.m_listener.newChannel(c, chan);
        this.m_sender.newChannel(c, chan);
    }

    protected void removeChannel(int chan) {
        this.m_listener.removeChannel(chan);
        this.m_sender.removeChannel(chan);
    }

    public void close() {
        if (this.m_socket == null) {
            return;
        }
        try {
            this.m_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

